# @(#)$Mu: make/sys.sinix.mk,v 1.41 $
##
## sys.sinix.mk
##	system dependent makefile for Sinix 5.42 with c89
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## Siemens Nixdorf Sinix 5.42/c89
##
sysname    = Sinix 5.42 (c89)
sys        = SY_SINIX
mk-putenv  = yes
mk-xpm     = yes
mk-libhelp = no
mk-editres = yes

cc      = c89
perl    = /usr/local/bin/perl
warn    = # this compiler doesn't need any extra warning flags!
defs    = -D$(sys) -D_POSIX_SOURCE -D_XOPEN_SOURCE
opt     = -O2
incl    = -I. -I/usr/local/include
ldflags = -s $(opt) -L/usr/local/lib
xlibs   = -lXm -lXpm -lXmu -lXt -lX11 -lm -lnsl -lgen -lsocket
hlibs   = -lhlpclient
ar      = ar
arflags = r
m4      = $(top)/tools/p4 -P

defs_socket = -U_POSIX_SOURCE -U_XOPEN_SOURCE -DFDOPEN_BY_HAND

dep    = makedepend
dflags = -f-

mkdir    = mkdirhier
install  = /usr/ucb/install -c
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g man -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
