/*
 * strdefs.h
 *	Extra string defs for MGv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#ifndef	MGV_STRDEFS_H
#define	MGV_STRDEFS_H
MU_HID(strdefs_h, "$Mu: mgv/mine/strdefs.h,v 1.49 $")

extern const char mgv_strdefs[];

#define	MgvNantialiasEPS	((char *)&mgv_strdefs[0])
#define	MgvCAntialiasEPS	((char *)&mgv_strdefs[13])

#define	MgvNautoHeight	((char *)&mgv_strdefs[26])
#define	MgvCAutoHeight	((char *)&mgv_strdefs[37])

#define	MgvNautoWidth	((char *)&mgv_strdefs[48])
#define	MgvCAutoWidth	((char *)&mgv_strdefs[58])

#define MgvNbunzip	((char *)&mgv_strdefs[68])
#define MgvCBunzip	((char *)&mgv_strdefs[75])

#define	MgvNbzip	((char *)&mgv_strdefs[82])
#define	MgvCBzip	((char *)&mgv_strdefs[87])

#define	MgvNconfirmExit	((char *)&mgv_strdefs[92])
#define	MgvCConfirmExit	((char *)&mgv_strdefs[104])

#define	MgvNdecompress	((char *)&mgv_strdefs[116])
#define	MgvCDecompress	((char *)&mgv_strdefs[127])

#define	MgvNcompress	((char *)&mgv_strdefs[138])
#define	MgvCCompress	((char *)&mgv_strdefs[147])

#define	MgvNdefaultPageMedia	((char *)&mgv_strdefs[156])
#define	MgvCDefaultPageMedia	((char *)&mgv_strdefs[173])
#define	MgvRPageMedia		((char *)&mgv_strdefs[190])

#define MgvNgunzip	((char *)&mgv_strdefs[200])
#define MgvCGunzip	((char *)&mgv_strdefs[207])

#define	MgvNgzip	((char *)&mgv_strdefs[214])
#define	MgvCGzip	((char *)&mgv_strdefs[219])

#define	MgvNhideLog	((char *)&mgv_strdefs[224])
#define	MgvCHideLog	((char *)&mgv_strdefs[232])

#define	MgvNhideMenuBar	((char *)&mgv_strdefs[240])
#define	MgvCHideMenuBar	((char *)&mgv_strdefs[252])

#define	MgvNhidePageList	((char *)&mgv_strdefs[264])
#define	MgvCHidePageList	((char *)&mgv_strdefs[277])

#define	MgvNhideStatusLine	((char *)&mgv_strdefs[290])
#define	MgvCHideStatusLine	((char *)&mgv_strdefs[305])

#define	MgvNkillChildrenAtExit	((char *)&mgv_strdefs[320])
#define	MgvCKillChildrenAtExit	((char *)&mgv_strdefs[339])

#define	MgvNmagicResistance	((char *)&mgv_strdefs[358])
#define	MgvCMagicResistance	((char *)&mgv_strdefs[374])

#define	MgvNprintCommand	((char *)&mgv_strdefs[390])
#define	MgvCPrintCommand	((char *)&mgv_strdefs[403])

#define	MgvNprinter	((char *)&mgv_strdefs[416])
#define	MgvCPrinter	((char *)&mgv_strdefs[424])

#define	MgvNresetScrollBars	((char *)&mgv_strdefs[432])
#define	MgvCResetScrollBars	((char *)&mgv_strdefs[448])
#define	MgvRResetScrollBars	((char *)&mgv_strdefs[464])

#define	MgvNreticuleForeground	((char *)&mgv_strdefs[480])
#define	MgvCReticuleForeground	((char *)&mgv_strdefs[499])

#define	MgvNreticuleLineWidth	((char *)&mgv_strdefs[518])
#define	MgvCReticuleLineWidth	((char *)&mgv_strdefs[536])

#define	MgvNshowLabels	((char *)&mgv_strdefs[554])
#define	MgvCShowLabels	((char *)&mgv_strdefs[565])

#define	MgvNshowPageNumbers	((char *)&mgv_strdefs[576])
#define	MgvCShowPageNumbers	((char *)&mgv_strdefs[592])

#define	MgvNtempDir	((char *)&mgv_strdefs[608])
#define	MgvCTempDir	((char *)&mgv_strdefs[616])

#define	MgvNmagicScrolling	((char *)&mgv_strdefs[624])
#define	MgvCMagicScrolling	((char *)&mgv_strdefs[639])

#define	MgvNsmoothScrolling	((char *)&mgv_strdefs[654])
#define	MgvCSmoothScrolling	((char *)&mgv_strdefs[670])

#define	MgvNsmoothness	((char *)&mgv_strdefs[686])
#define	MgvCSmoothness	((char *)&mgv_strdefs[697])

#define	MgvNmagstep	((char *)&mgv_strdefs[708])
#define	MgvCMagstep	((char *)&mgv_strdefs[716])

#define	MgvNsmartSizing	((char *)&mgv_strdefs[724])
#define	MgvCSmartSizing	((char *)&mgv_strdefs[736])

#define	MgvNwmWidth	((char *)&mgv_strdefs[748])
#define	MgvCWmWidth	((char *)&mgv_strdefs[756])

#define	MgvNwmHeight	((char *)&mgv_strdefs[764])
#define	MgvCWmHeight	((char *)&mgv_strdefs[773])

#define	MgvNscrollPercentage	((char *)&mgv_strdefs[782])
#define	MgvCScrollPercentage	((char *)&mgv_strdefs[799])

#define	MgvNcopyStdin		((char *)&mgv_strdefs[816])
#define	MgvCCopyStdin		((char *)&mgv_strdefs[826])

/*
 * strings
 */
#define	MgvNstringBadArgument	((char *)&mgv_strdefs[836])
#define	MgvCStringBadArgument	((char *)&mgv_strdefs[854])

#define	MgvNstringBadVersion	((char *)&mgv_strdefs[872])
#define	MgvCStringBadVersion	((char *)&mgv_strdefs[889])

#define	MgvNstringCantAllocPixmap	((char *)&mgv_strdefs[906])
#define	MgvCStringCantAllocPixmap	((char *)&mgv_strdefs[928])

#define	MgvNstringCantDecompress	((char *)&mgv_strdefs[950])
#define	MgvCStringCantDecompress	((char *)&mgv_strdefs[971])

#define	MgvNstringCantHideMenu	((char *)&mgv_strdefs[992])
#define	MgvCStringCantHideMenu	((char *)&mgv_strdefs[1011])

#define	MgvNstringCantOpen	((char *)&mgv_strdefs[1030])
#define	MgvCStringCantOpen	((char *)&mgv_strdefs[1045])

#define	MgvNstringCantPrint	((char *)&mgv_strdefs[1060])
#define	MgvCStringCantPrint	((char *)&mgv_strdefs[1076])

#define	MgvNstringError		((char *)&mgv_strdefs[1092])
#define	MgvCStringError		((char *)&mgv_strdefs[1104])

#define	MgvNstringFileExists	((char *)&mgv_strdefs[1116])
#define	MgvCStringFileExists	((char *)&mgv_strdefs[1133])

#define	MgvNstringInterpDone	((char *)&mgv_strdefs[1150])
#define	MgvCStringInterpDone	((char *)&mgv_strdefs[1167])

#define	MgvNstringInterpFailed	((char *)&mgv_strdefs[1184])
#define	MgvCStringInterpFailed	((char *)&mgv_strdefs[1203])

#define	MgvNstringMessage	((char *)&mgv_strdefs[1222])
#define	MgvCStringMessage	((char *)&mgv_strdefs[1236])

#define	MgvNstringNoCoordinates	((char *)&mgv_strdefs[1250])
#define	MgvCStringNoCoordinates	((char *)&mgv_strdefs[1270])

#define	MgvNstringNoDate	((char *)&mgv_strdefs[1290])
#define	MgvCStringNoDate	((char *)&mgv_strdefs[1303])

#define	MgvNstringNoFile	((char *)&mgv_strdefs[1316])
#define	MgvCStringNoFile	((char *)&mgv_strdefs[1329])

#define	MgvNstringNoPrintCommand	((char *)&mgv_strdefs[1342])
#define	MgvCStringNoPrintCommand	((char *)&mgv_strdefs[1363])

#define	MgvNstringPageFinished	((char *)&mgv_strdefs[1384])
#define	MgvCStringPageFinished	((char *)&mgv_strdefs[1403])

#define	MgvNstringUnknownSwitch	((char *)&mgv_strdefs[1422])
#define	MgvCStringUnknownSwitch	((char *)&mgv_strdefs[1442])

#define	MgvNstringPS	((char *)&mgv_strdefs[1462])
#define	MgvCStringPS	((char *)&mgv_strdefs[1471])

#define	MgvNstringEPS	((char *)&mgv_strdefs[1480])
#define	MgvCStringEPS	((char *)&mgv_strdefs[1490])

#define	MgvNstringPDF	((char *)&mgv_strdefs[1500])
#define	MgvCStringPDF	((char *)&mgv_strdefs[1510])

#define	MgvNstringUnknownType	((char *)&mgv_strdefs[1520])
#define	MgvCStringUnknownType	((char *)&mgv_strdefs[1538])

#define	MgvNstringUnknownMedia	((char *)&mgv_strdefs[1556])
#define	MgvCStringUnknownMedia	((char *)&mgv_strdefs[1575])

#define	MgvNstringUnknown	((char *)&mgv_strdefs[1594])
#define	MgvCStringUnknown	((char *)&mgv_strdefs[1608])

#endif
