#!@@PERL@@ -w
# $Mu: tools/mkresm4.pl,v 1.9 $
##
## mkresm4.pl
##	Generate a resoure substitution m4 script from an SGML file.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

use Getopt::Long;
($me = $0) =~ s/.*\///g;

$verbose = 0;
$outfile = "";
$prefix  = "";
%options = (
	'verbose'	=> \$verbose,
	'output=s'	=> \$outfile,
	'prefix=s',	=> \$prefix
);
&GetOptions(%options) || die "$me : aborting\n";
die "$me : --prefix required!\n" if(!$prefix);

open(OUT, !$outfile ? ">-" : "> $outfile") || die "cannot open output: $!\n";
print OUT "m4_define(\`__URL_CONTENTS__\',\`$prefix\')m4_dnl\n";
$section = 0;
while(defined($line = <>)) {
	chop($line);
	next if($line !~ /^<sect>/);
	++$section;
	$line =~ s/^<sect>//;
	$line =~ s/<.*$//;
	$line =~ tr/ /_/;
	print OUT "m4_define(\`__URL_${line}__\',\`$prefix-$section\')m4_dnl\n";
}
close(OUT);
