#!@@PERL@@
##
## p4.pl
##	very simple and minimal m4 replacement in perl (if you have GNU
##	m4 then use it instead, I don't know about any other m4).
##	This script is just enough to handle the m4 code that I use.
##	I've tried to make sure this will work with both perl 4 and
##	perl 5 but I don't have perl 4 kicking around anywhere so
##	I give no guarantees.
##
## Copyright (C) 1997  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Eric A. Howe (mu@trends.net)
##
# @(#)$Mu: tools/p4.pl,v 1.12 $

@incls    = ('.');
%defs     = ();
$m4prefix = "";

sub find {
	local($file) = shift;
	local($dir);

	foreach $dir (@incls) {
		next if(!-r "$dir/$file");
		$file = "$dir/$file";
		last;
	}
	return $file;
}

sub include {
	local($input) = shift;
	local(*IN);
	local($def);
	local($val);
	local($inif) = 0;
	local($nl);

	open(IN, "< $input") || die "cannot open $input: $!\n";
	while(defined($line = <IN>)) {
		chop($line);

		##
		## Not quite correct but good enough
		##
		if($line =~ /\b${m4prefix}dnl\b/) {
			$line =~ s/dnl\b.*//;
			$nl = "";
		}
		else {
			$nl = "\n";
		}
		if($inif != 0 && $line =~ /^\'\s*,\s*\`/) {
			$inif *= -1;
			print $nl;
			next;
		}
		if($inif != 0 && $line =~ /^'\)/) {
			$inif = 0;
			print $nl;
			next;
		}
		if($inif == -1) {
			next;
		}
		if($line =~ /^${m4prefix}include\(`.*'\)/) {
			$line =~ s/^${m4prefix}include\(`(.*)'\).*$/$1/;
			&include(&find($line));
			print $nl;
			next;
		}
		if($line =~ /^${m4prefix}define\(.*\)/) {
			$line =~ s/^${m4prefix}define\((.*)\).*$/$1/g;
			($def,$val) = split(/,/, $line, 2);
			$def =~ s/.*\`(.*)\'.*/$1/;
			$val =~ s/.*\`(.*)\'.*/$1/;
			$defs{$def} = $val;
			print $nl;
			next;
		}
		if($line =~ /^${m4prefix}ifdef\(/) {
			$line =~ s/^.*\`([^']+)\'.*$/$1/;
			if(defined($defs{$line})) {
				$inif = 1;
			}
			else {
				$inif = -1;
			}
			print $nl;
			next;
		}
		foreach $def (keys(%defs)) {
			$line =~ s/\b$def\b/$defs{$def}/g;
		}
		print "$line$nl";
	}
	close(IN);
}

while($ARGV[0] =~ /^-[DIP]/) {
	$sw = shift @ARGV;
	if($sw =~ /^-I/) {
		$sw =~ s/^-I//;
		push(@incls, $sw);
	}
	elsif($sw =~ /^-D/) {
		$sw =~ s/^-D//;
		if($sw =~ /=/) {
			($d, $v) = split(/=/, $sw, 2);
			$defs{$d} = $v;
		}
		else {
			$defs{$sw} = $sw;
		}
	}
	elsif($sw =~ /^-P/) {
		$m4prefix = "m4_";
	}
}

while($#ARGV >= 0) {
	&include($ARGV[0]);
	shift @ARGV;
}

exit(0);
