#!@@PERL@@ -w
# $Mu: tools/yanksect.pl,v 1.8 $
##
## yanksect.pl
##	Yank out a section of an SGML file (I'm assuming the linuxdoc
##	article dtd for convenience).
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

use Getopt::Long;
($me = $0) =~ s/.*\///g;

$section = $abstract = 0;
%options = (
	'section=s'	=> \$section,
	'abstract'	=> \$abstract,
);
&GetOptions(%options) || die "$me : aborting\n";
die "$me : you must specify a section\n" if(!$section);

##
## we'll start off acting interested since we're not rude people
##
$interested = 1;
$foundit    = 0;
while(defined($line = <>)) {
	chop($line);

	##
	## we need the end-of-article tag even if we're not that interested
	## when we get there
	##
	if($line =~ /^<\/article>/) {
		print "$line\n";
		next;
	}
	if($line =~ /^<sect>/) {
		$interested = ($line =~ /^<sect>$section(<label id.*>)?$/);
		$foundit += $interested;
	}
	if(!$interested) {
		next;
	}

	##
	## we want a sensible title, the titles that I use
	## will always match the supplied regex in a sensible
	## fashion
	##
	if($line =~ /^<title>/) {
		$line =~ s/^(.+:).*/$1 $section/;
	}
	elsif($line =~ /^<abstract>/ && !$abstract) {
		$interested = !$interested;
		next;
	}
	elsif($line =~ /^<\/abstract>/) {
		$interested = 0;
	}
	print "$line\n";
}

exit(($foundit > 0) ? 0 : 1);
