/*
 * dirtysocks.c
 *	Socket handling functions for the wlib help system.
 *	These functions are intended to be prototype and behavior
 *	compatible with their stdio counterparts.
 *	This file is part of wlib.
 *
 *	The real purpose of putting this stuff in a separate file is
 *	to keep the wonderful dance of _POSIX_SOURCE/_XOPEN_SOURCE/...
 *	crap that often needs to be done to get at the socket stuff
 *	and still get at the POSIXism that we (rightfully) use and
 *	sometimes depend on.  *sigh* I really hate standards compliance
 *	testing.  Just what was the POSIX committee thinking (drinking?)
 *	when they left out sockets?  The least they could have done was
 *	say "you must do X and Y this way, if you want to do W and/or Z
 *	as well, then you must do them this way..." (I think the Forth
 *	standard took this approach).
 *
 *	The dirtysocks.h header contains the various incantations needed
 *	to get around the silly u_int/uint stupidity (I've even come
 *	across systems that use _both_ naming schemes!).
 *
 * Copyright (C) 1997  Eric A. Howe
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#include <wlib/rcs.h>
MU_ID("$Mu: wlib/dirtysocks.c,v 1.18 $")

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <unistd.h>

#include <wlib/dirtysocks.h>
#include <wlib/wlib.h>
#include <wlib/wlibP.h>

/*
 * name should have the format:
 *
 *	name:port
 *
 * The returned FILE * will be just like one returned from fopen().
 */
FILE *
wlp_sopen(char *name, char *mode)
{
	struct sockaddr_in	sa;
	struct hostent		*h;
	char	*server, *port;
	FILE	*fp;
	int	fd, terrno;

	fp   = NULL;
	fd   = -1;
	port = server = NULL;

	if((fd = socket(PF_INET, SOCK_STREAM, 0)) == -1)
		goto Hell;

	if((server = malloc(strlen(name) + 1)) == NULL)
		goto Hell;
	strcpy(server, name);
	if((port = strrchr(server, ':')) == NULL)
		goto Hell;
	*port++ = '\0';

	if((h = gethostbyname(server)) == 0)
		goto Hell;
	sa.sin_family = AF_INET;
	sa.sin_port   = htons((unsigned short)atoi(port));
	memcpy((void *)&sa.sin_addr, (void *)h->h_addr, h->h_length);

	/*
	 * and take the leap...
	 */
	if(connect(fd, (struct sockaddr *)&sa, sizeof(sa)) == -1
	|| (fp = fdopen(fd, mode)) == NULL
	|| setvbuf(fp, NULL, _IOLBF, 0) != 0)
		goto Hell;

	free((void *)server);
	return fp;

Hell:
	terrno = errno;
	free((void *)server);
	if(fp != NULL)
		fclose(fp);
	else if(fd != -1)
		close(fd);
	errno = terrno;
	return NULL;
}

int
wlp_sclose(FILE *fp)
{
	return fclose(fp);
}

size_t
wlp_sread(void *p, size_t size, size_t n, FILE *fp)
{
	fflush(fp);
	return fread(p, size, n, fp);
}

size_t
wlp_swrite(void *p, size_t size, size_t n, FILE *fp)
{
	fflush(fp);
	return fwrite(p, size, n, fp);
}

char *
wlp_sgets(char *s, int n, FILE *fp)
{
	fflush(fp);
	return fgets(s, n, fp);
}

int
wlp_sprintf(FILE *fp, char *fmt, ...)
{
	int	ret;
	va_list	ap;

	fseek(fp, 0, SEEK_CUR);
	va_start(ap, fmt);
	ret = vfprintf(fp, fmt, ap);
	va_end(ap);
	fflush(fp);
	return ret;
}
