/*
 * strdefs.h.in
 *	Extra resource strings for wlib.  This file is converted
 *	to "strdefs.h" so you should do any necessary editting here.
 *
 * Copyright (C) 1997 Eric A. Howe
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#ifndef	WLIB_STRDEFS_H
#define	WLIB_STRDEFS_H
MU_HID(wlib_strdefs_h, "$Mu: wlib/wlib/strdefs.h,v 1.21 $")

extern const char wl_strdefs[];

/**
 ** Resources.
 **/

/*
 * help stuff
 */
#define	XwlNhelpBrowser		((char *)&wl_strdefs[0])
#define	XwlCHelpBrowser		((char *)&wl_strdefs[12])

#define	XwlNhelpChapter		((char *)&wl_strdefs[24])
#define	XwlCHelpChapter		((char *)&wl_strdefs[36])

#define	XwlNhelpPrefix		((char *)&wl_strdefs[48])
#define	XwlCHelpPrefix		((char *)&wl_strdefs[59])

#define	XwlNhelpSection		((char *)&wl_strdefs[70])
#define	XwlCHelpSection		((char *)&wl_strdefs[82])

#define	XwlNhelpCCIPort		((char *)&wl_strdefs[94])
#define	XwlCHelpCCIPort		((char *)&wl_strdefs[106])

#define	XwlNhelpType		((char *)&wl_strdefs[118])
#define	XwlCHelpType		((char *)&wl_strdefs[127])
#define	XwlRHelpType		((char *)&wl_strdefs[136])

#define	XwlNapplicationVersion	((char *)&wl_strdefs[145])
#define	XwlCApplicationVersion	((char *)&wl_strdefs[164])

#define	XwlNinstallIcon	((char *)&wl_strdefs[183])
#define	XwlCInstallIcon	((char *)&wl_strdefs[197])

/*
 * "special" dialog resources
 */
#define	XwlNinitialFocus	((char *)&wl_strdefs[211])
#define	XwlCInitialFocus	((char *)&wl_strdefs[226])

#define	XwlNdefaultButton	((char *)&wl_strdefs[241])
#define	XwlCDefaultButton	((char *)&wl_strdefs[257])

#define	XwlNcancelButton	((char *)&wl_strdefs[273])
#define	XwlCCancelButton	((char *)&wl_strdefs[288])

#define	XwlNautoDismiss		((char *)&wl_strdefs[303])
#define	XwlCAutoDismiss		((char *)&wl_strdefs[317])

/*
 * Extra representation types.
 */
#define	XwlRPercentage		((char *)&wl_strdefs[331])

/*
 * Extras for shell creation.
 */
#define	XwlNvisualClass	((char *)&wl_strdefs[342])
#define	XwlCVisualClass	((char *)&wl_strdefs[356])
#define	XwlRVisualClass	((char *)&wl_strdefs[370])

#define	XwlNvisualID	((char *)&wl_strdefs[384])
#define	XwlCVisualID	((char *)&wl_strdefs[395])
#define	XwlRVisualID	((char *)&wl_strdefs[406])

#define	XwlNdepth	((char *)&wl_strdefs[417])
#define	XwlCDepth	((char *)&wl_strdefs[425])
#define	XwlRDepth	((char *)&wl_strdefs[433])

#define	XwlNusePrivateColormap	((char *)&wl_strdefs[441])
#define	XwlCUsePrivateColormap	((char *)&wl_strdefs[462])

#define	XwlNuseColorIcon	((char *)&wl_strdefs[483])
#define	XwlCUseColorIcon	((char *)&wl_strdefs[498])

#define	XwlNuseEditRes	((char *)&wl_strdefs[513])
#define	XwlCUseEditRes	((char *)&wl_strdefs[526])

/*
 * Splash screen.
 */
#define	XwlNsplashPixmap	((char *)&wl_strdefs[539])
#define	XwlCSplashPixmap	((char *)&wl_strdefs[554])

#define	XwlNsplashBitmap	((char *)&wl_strdefs[569])
#define	XwlCSplashBitmap	((char *)&wl_strdefs[584])

#define	XwlNshowSplashScreen	((char *)&wl_strdefs[599])
#define	XwlCShowSplashScreen	((char *)&wl_strdefs[618])

#define	XwlNuseMonoSplash	((char *)&wl_strdefs[637])
#define	XwlCUseMonoSplash	((char *)&wl_strdefs[653])

/*
 * strings
 */
#define	XwlNstringBadVersion	((char *)&wl_strdefs[669])
#define	XwlCStringBadVersion	((char *)&wl_strdefs[686])

#define	XwlNstringCantBrowse	((char *)&wl_strdefs[703])
#define	XwlCStringCantBrowse	((char *)&wl_strdefs[720])

#define	XwlNstringCantGetFile	((char *)&wl_strdefs[737])
#define	XwlCStringCantGetFile	((char *)&wl_strdefs[755])

#define	XwlNstringEmptyLog	((char *)&wl_strdefs[773])
#define	XwlCStringEmptyLog	((char *)&wl_strdefs[788])

#define	XwlNstringNotSupported	((char *)&wl_strdefs[803])
#define	XwlCStringNotSupported	((char *)&wl_strdefs[822])

#define	XwlNstringUnknown	((char *)&wl_strdefs[841])
#define	XwlCStringUnknown	((char *)&wl_strdefs[855])

/**
 ** Widget types for wlib.
 **/

/*
 * these should cover Motif 1.2
 */
#define	wlArrowB		((char *)&wl_strdefs[869])
#define	wlArrowBG		((char *)&wl_strdefs[876])
#define	wlBulletinB		((char *)&wl_strdefs[884])
#define	wlCascadeB		((char *)&wl_strdefs[894])
#define	wlCascadeBG		((char *)&wl_strdefs[903])
#define	wlCommand		((char *)&wl_strdefs[913])
#define	wlDialogS		((char *)&wl_strdefs[921])
#define	wlDrawingA		((char *)&wl_strdefs[929])
#define	wlDrawnB		((char *)&wl_strdefs[938])
#define	wlFileSB		((char *)&wl_strdefs[945])
#define	wlForm			((char *)&wl_strdefs[952])
#define	wlFrame			((char *)&wl_strdefs[957])
#define	wlLabel			((char *)&wl_strdefs[963])
#define	wlLabelG		((char *)&wl_strdefs[969])
#define	wlList			((char *)&wl_strdefs[976])
#define	wlMainW			((char *)&wl_strdefs[981])
#define	wlMenuShell		((char *)&wl_strdefs[987])
#define	wlMessageB		((char *)&wl_strdefs[997])
#define	wlPanedW		((char *)&wl_strdefs[1006])
#define	wlPushB			((char *)&wl_strdefs[1013])
#define	wlPushBG		((char *)&wl_strdefs[1019])
#define	wlRowColumn		((char *)&wl_strdefs[1026])
#define	wlScale			((char *)&wl_strdefs[1036])
#define	wlScrollBar		((char *)&wl_strdefs[1042])
#define	wlScrolledW		((char *)&wl_strdefs[1052])
#define	wlSelectionB		((char *)&wl_strdefs[1062])
#define	wlSeparator		((char *)&wl_strdefs[1073])
#define	wlSeparatorG		((char *)&wl_strdefs[1083])
#define	wlText			((char *)&wl_strdefs[1094])
#define	wlTextField		((char *)&wl_strdefs[1099])
#define	wlToggleB		((char *)&wl_strdefs[1109])
#define	wlToggleBG		((char *)&wl_strdefs[1117])
#define	wlErrorDialog		((char *)&wl_strdefs[1126])
#define	wlFileSBDialog		((char *)&wl_strdefs[1138])
#define	wlFormDialog		((char *)&wl_strdefs[1151])
#define	wlInformationDialog	((char *)&wl_strdefs[1162])
#define	wlMessageDialog		((char *)&wl_strdefs[1180])
#define	wlPromptDialog		((char *)&wl_strdefs[1194])
#define	wlQuestionDialog	((char *)&wl_strdefs[1207])
#define	wlSelectionDialog	((char *)&wl_strdefs[1222])
#define	wlTemplateDialog	((char *)&wl_strdefs[1238])
#define	wlWarningDialog		((char *)&wl_strdefs[1253])
#define	wlWorkingDialog		((char *)&wl_strdefs[1267])
#define	wlMenuBar		((char *)&wl_strdefs[1281])
#define	wlOptionMenu		((char *)&wl_strdefs[1289])
#define	wlPopupMenu		((char *)&wl_strdefs[1300])
#define	wlPulldownMenu		((char *)&wl_strdefs[1310])
#define	wlRadioBox		((char *)&wl_strdefs[1323])
#define	wlScrolledList		((char *)&wl_strdefs[1332])
#define	wlScrolledText		((char *)&wl_strdefs[1345])

#endif
