/* $XConsortium: LabelF.c,v 1.97 94/04/17 20:12:12 kaleb Exp $ */

/***********************************************************

Copyright (c) 1987, 1988, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * LabelF.c - LabelF widget
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xos.h>
#include <X11/Xaw/XawInit.h>
#include "LabelFP.h"
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <stdio.h>
#include <ctype.h>

/* needed for abs() */
#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#else
int abs();
#endif

#define streq(a,b) (strcmp( (a), (b) ) == 0)

#define MULTI_LINE_LABEL 32767

#ifdef CRAY
#define WORD64
#endif

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffsetOf(LabelFRec, field)
static XtResource resources[] = {
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	offset(labelF.foreground), XtRString, XtDefaultForeground},
    {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	offset(labelF.font),XtRString, XtDefaultFont},
    {XtNfontSet,  XtCFontSet, XtRFontSet, sizeof(XFontSet ),
        offset(labelF.fontset),XtRString, XtDefaultFontSet},
    {XtNlabel,  XtCLabel, XtRString, sizeof(String),
	offset(labelF.labelF), XtRString, NULL},
    {XtNencoding, XtCEncoding, XtRUnsignedChar, sizeof(unsigned char),
	offset(labelF.encoding), XtRImmediate, (XtPointer)XawTextEncoding8bit},
    {XtNjustify, XtCJustify, XtRJustify, sizeof(XtJustify),
	offset(labelF.justify), XtRImmediate, (XtPointer)XtJustifyCenter},
    {XtNinternalWidth, XtCWidth, XtRDimension,  sizeof(Dimension),
	offset(labelF.internal_width), XtRImmediate, (XtPointer)4},
    {XtNinternalHeight, XtCHeight, XtRDimension, sizeof(Dimension),
	offset(labelF.internal_height), XtRImmediate, (XtPointer)2},
    {XtNleftBitmap, XtCLeftBitmap, XtRBitmap, sizeof(Pixmap),
       offset(labelF.left_bitmap), XtRImmediate, (XtPointer) None},
    {XtNbitmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
	offset(labelF.pixmap), XtRImmediate, (XtPointer)None},
    {XtNresize, XtCResize, XtRBoolean, sizeof(Boolean),
	offset(labelF.resize), XtRImmediate, (XtPointer)True},
};
#undef offset

static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
static void Destroy();
static XtGeometryResult QueryGeometry();

LabelFClassRec labelFClassRec = {
  {
/* core_class fields */	
    /* superclass	  	*/	(WidgetClass) &simpleClassRec,
    /* class_name	  	*/	"LabelF",
    /* widget_size	  	*/	sizeof(LabelFRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	NULL,
    /* num_actions	  	*/	0,
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	Destroy,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	NULL,
    /* query_geometry		*/	QueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
/* Simple class fields initialization */
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  },
/* LabelF class fields initialization */
  {
    /* ignore 			*/	0
  }
};
WidgetClass labelFWidgetClass = (WidgetClass)&labelFClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInitialize()
{
    XawInitializeWidgetSet();
    XtAddConverter( XtRString, XtRJustify, XmuCvtStringToJustify, 
		    (XtConvertArgList)NULL, 0 );
}

#ifndef WORD64

#define TXT16 XChar2b

#else

#define TXT16 char

static XChar2b *buf2b;
static int buf2blen = 0;

_XawLabelFWidth16(fs, str, n)
    XFontStruct *fs;
    char *str;
    int	n;
{
    int i;
    XChar2b *ptr;

    if (n > buf2blen) {
	buf2b = (XChar2b *)XtRealloc((char *)buf2b, n * sizeof(XChar2b));
	buf2blen = n;
    }
    for (ptr = buf2b, i = n; --i >= 0; ptr++) {
	ptr->byte1 = *str++;
	ptr->byte2 = *str++;
    }
    return XTextWidth16(fs, buf2b, n);
}

_XawLabelFDraw16(dpy, d, gc, x, y, str, n)
    Display *dpy;
    Drawable d;
    GC gc;
    int x, y;
    char *str;
    int n;
{
    int i;
    XChar2b *ptr;

    if (n > buf2blen) {
	buf2b = (XChar2b *)XtRealloc((char *)buf2b, n * sizeof(XChar2b));
	buf2blen = n;
    }
    for (ptr = buf2b, i = n; --i >= 0; ptr++) {
	ptr->byte1 = *str++;
	ptr->byte2 = *str++;
    }
    XDrawString16(dpy, d, gc, x, y, buf2b, n);
}

#define XTextWidth16 _XawLabelFWidth16
#define XDrawString16 _XawLabelFDraw16

#endif /* WORD64 */

/*
 * Calculate width and height of displayed text in pixels
 */

static void SetTextWidthAndHeight(lw)
    LabelFWidget lw;
{
    XFontStruct	*fs = lw->labelF.font;

    char *nl;

    if (lw->labelF.pixmap != None) {
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;
	if (XGetGeometry(XtDisplay(lw), lw->labelF.pixmap, &root, &x, &y,
			 &width, &height, &bw, &depth)) {
	    lw->labelF.labelF_height = height;
	    lw->labelF.labelF_width = width;
	    lw->labelF.labelF_len = depth;
	    return;
	}
    }
    if ( lw->simple.international == True ) {

      XFontSet	fset = lw->labelF.fontset;
      XFontSetExtents *ext = XExtentsOfFontSet(fset);

      lw->labelF.labelF_height = ext->max_ink_extent.height;
      if (lw->labelF.labelF == NULL) {
	  lw->labelF.labelF_len = 0;
	  lw->labelF.labelF_width = 0;
      }
      else if ((nl = index(lw->labelF.labelF, '\n')) != NULL) {
	  char *labelF;
	  lw->labelF.labelF_len = MULTI_LINE_LABEL;
	  lw->labelF.labelF_width = 0;
	  for (labelF = lw->labelF.labelF; nl != NULL; nl = index(labelF, '\n')) {
	      int width = XmbTextEscapement(fset, labelF, (int)(nl - labelF));

	      if (width > (int)lw->labelF.labelF_width)
		  lw->labelF.labelF_width = width;
	      labelF = nl + 1;
	      if (*labelF)
		  lw->labelF.labelF_height +=
		      ext->max_ink_extent.height;
	  }
	  if (*labelF) {
	      int width = XmbTextEscapement(fset, labelF, strlen(labelF));

	      if (width > (int) lw->labelF.labelF_width)
		  lw->labelF.labelF_width = width;
	  }
      } else {
	  lw->labelF.labelF_len = strlen(lw->labelF.labelF);
	  lw->labelF.labelF_width =
	      XmbTextEscapement(fset, lw->labelF.labelF, (int) lw->labelF.labelF_len);
      }

    } else {

        lw->labelF.labelF_height = fs->max_bounds.ascent + fs->max_bounds.descent;
        if (lw->labelF.labelF == NULL) {
            lw->labelF.labelF_len = 0;
            lw->labelF.labelF_width = 0;
        }
        else if ((nl = index(lw->labelF.labelF, '\n')) != NULL) {
	    char *labelF;
            lw->labelF.labelF_len = MULTI_LINE_LABEL;
            lw->labelF.labelF_width = 0;
            for (labelF = lw->labelF.labelF; nl != NULL; nl = index(labelF, '\n')) {
	        int width;

	        if (lw->labelF.encoding)
		    width = XTextWidth16(fs, (TXT16*)labelF, (int)(nl - labelF)/2);
	        else
		    width = XTextWidth(fs, labelF, (int)(nl - labelF));
	        if (width > (int)lw->labelF.labelF_width)
		    lw->labelF.labelF_width = width;
	        labelF = nl + 1;
	        if (*labelF)
		    lw->labelF.labelF_height +=
		        fs->max_bounds.ascent + fs->max_bounds.descent;
	    }
	    if (*labelF) {
	        int width = XTextWidth(fs, labelF, strlen(labelF));

	        if (lw->labelF.encoding)
		    width = XTextWidth16(fs, (TXT16*)labelF, (int)strlen(labelF)/2);
	        else
		    width = XTextWidth(fs, labelF, strlen(labelF));
	        if (width > (int) lw->labelF.labelF_width)
		    lw->labelF.labelF_width = width;
	    }
        } else {
	    lw->labelF.labelF_len = strlen(lw->labelF.labelF);
	    if (lw->labelF.encoding)
	        lw->labelF.labelF_width =
		    XTextWidth16(fs, (TXT16*)lw->labelF.labelF,
			         (int) lw->labelF.labelF_len/2);
	    else
	        lw->labelF.labelF_width =
		    XTextWidth(fs, lw->labelF.labelF, (int) lw->labelF.labelF_len);
        }

    }
}

static void GetnormalGC(lw)
    LabelFWidget lw;
{
    XGCValues	values;

    values.foreground	= lw->labelF.foreground;
    values.background	= lw->core.background_pixel;
    values.font		= lw->labelF.font->fid;
    values.graphics_exposures = False;

    if ( lw->simple.international == True )
        /* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
        lw->labelF.normal_GC = XtAllocateGC(
                (Widget)lw, 0,
	(unsigned) GCForeground | GCBackground | GCGraphicsExposures,
	&values, GCFont, 0 );
    else
        lw->labelF.normal_GC = XtGetGC(
	(Widget)lw,
	(unsigned) GCForeground | GCBackground | GCFont | GCGraphicsExposures,
	&values);
}

static void GetgrayGC(lw)
    LabelFWidget lw;
{
    XGCValues	values;

    values.foreground = lw->labelF.foreground;
    values.background = lw->core.background_pixel;
    values.font	      = lw->labelF.font->fid;
    values.fill_style = FillTiled;
    values.tile       = XmuCreateStippledPixmap(XtScreen((Widget)lw),
						lw->labelF.foreground, 
						lw->core.background_pixel,
						lw->core.depth);
    values.graphics_exposures = False;

    lw->labelF.stipple = values.tile;
    if ( lw->simple.international == True )
        /* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
        lw->labelF.gray_GC = XtAllocateGC((Widget)lw,  0,
				(unsigned) GCForeground | GCBackground |
					   GCTile | GCFillStyle |
					   GCGraphicsExposures,
				&values, GCFont, 0);
    else
        lw->labelF.gray_GC = XtGetGC((Widget)lw, 
				(unsigned) GCForeground | GCBackground |
					   GCFont | GCTile | GCFillStyle |
					   GCGraphicsExposures,
				&values);
}

static void compute_bitmap_offsets (lw)
    LabelFWidget lw;
{
    /*
     * bitmap will be eventually be displayed at 
     * (internal_width, internal_height + lbm_y)
     */
    if (lw->labelF.lbm_height != 0) {
	lw->labelF.lbm_y = (lw->core.height -
			  (lw->labelF.internal_height * 2 + 
			   lw->labelF.lbm_height)) / 2;
    } else {
	lw->labelF.lbm_y = 0;
    }
}


static void set_bitmap_info (lw)
    LabelFWidget lw;
{
    Window root;
    int x, y;
    unsigned int bw, depth;

    if (!(lw->labelF.left_bitmap &&
	  XGetGeometry (XtDisplay(lw), lw->labelF.left_bitmap, &root, &x, &y,
			&lw->labelF.lbm_width, &lw->labelF.lbm_height,
			&bw, &depth))) {
	lw->labelF.lbm_width = lw->labelF.lbm_height = 0;
    }
    compute_bitmap_offsets (lw);
}



/* ARGSUSED */
static void Initialize(request, new, args, num_args)
    Widget request, new;
    ArgList args;
    Cardinal *num_args;
{
    LabelFWidget lw = (LabelFWidget) new;

    if (lw->labelF.labelF == NULL) 
        lw->labelF.labelF = XtNewString(lw->core.name);
    else {
        lw->labelF.labelF = XtNewString(lw->labelF.labelF);
    }

    GetnormalGC(lw);
    GetgrayGC(lw);

    SetTextWidthAndHeight(lw);

    if (lw->core.height == 0)
        lw->core.height = lw->labelF.labelF_height +
			    2 * lw->labelF.internal_height;

    set_bitmap_info (lw);		/* need core.height */

    if (lw->core.width == 0)		/* need labelF.lbm_width */
        lw->core.width = (lw->labelF.labelF_width +
			    2 * lw->labelF.internal_width +
			    LEFT_OFFSET(lw));

    lw->labelF.labelF_x = lw->labelF.labelF_y = 0;
    (*XtClass(new)->core_class.resize) ((Widget)lw);

} /* Initialize */

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(gw, event, region)
    Widget gw;
    XEvent *event;
    Region region;
{
    extern WidgetClass commandWidgetClass;
    LabelFWidget w = (LabelFWidget) gw;
    LabelFWidgetClass lwclass = (LabelFWidgetClass) XtClass (gw);
    GC gc;

    /*
     * now we'll see if we need to draw the rest of the labelF
     */
    if (region != NULL) {
	int x = w->labelF.labelF_x;
	unsigned int width = w->labelF.labelF_width;
	if (w->labelF.lbm_width) {
	    if (w->labelF.labelF_x > (x = w->labelF.internal_width))
		width += w->labelF.labelF_x - x;
	}
	if (XRectInRegion(region, x, w->labelF.labelF_y,
			 width, w->labelF.labelF_height) == RectangleOut){
	    return;
	}
    }

    gc = XtIsSensitive(gw) ? w->labelF.normal_GC : w->labelF.gray_GC;
#ifdef notdef
    if (region != NULL)
	XSetRegion(XtDisplay(gw), gc, region);
#endif /*notdef*/

    if (w->labelF.pixmap == None) {
	int len = w->labelF.labelF_len;
	char *labelF = w->labelF.labelF;
	Position y = w->labelF.labelF_y + w->labelF.font->max_bounds.ascent;
        Position ksy = w->labelF.labelF_y;

	/* display left bitmap */
	if (w->labelF.left_bitmap && w->labelF.lbm_width != 0) {
	    XCopyPlane (XtDisplay(gw), w->labelF.left_bitmap, XtWindow(gw), gc,
		       0, 0, w->labelF.lbm_width, w->labelF.lbm_height,
		       (int) w->labelF.internal_width,
		       (int) w->labelF.internal_height + w->labelF.lbm_y, 
		       (unsigned long) 1L);
	}

        if ( w->simple.international == True ) {

	    XFontSetExtents *ext = XExtentsOfFontSet(w->labelF.fontset);

	    ksy += abs(ext->max_ink_extent.y);

            if (len == MULTI_LINE_LABEL) {
	        char *nl;
	        while ((nl = index(labelF, '\n')) != NULL) {
	            XmbDrawString(XtDisplay(w), XtWindow(w), w->labelF.fontset, gc,
	  		        w->labelF.labelF_x, ksy, labelF, (int)(nl - labelF));
	            ksy += ext->max_ink_extent.height;
	            labelF = nl + 1;
	        }
	        len = strlen(labelF);
            }
            if (len)
	        XmbDrawString(XtDisplay(w), XtWindow(w), w->labelF.fontset, gc,
			      w->labelF.labelF_x, ksy, labelF, len);

        } else { /*international false, so use R5 routine */

	    if (len == MULTI_LINE_LABEL) {
	        char *nl;
	        while ((nl = index(labelF, '\n')) != NULL) {
		    if (w->labelF.encoding)
		        XDrawString16(XtDisplay(gw), XtWindow(gw), gc,
				 		w->labelF.labelF_x, y,
				 		(TXT16*)labelF, (int)(nl - labelF)/2);
		    else
		        XDrawString(XtDisplay(gw), XtWindow(gw), gc,
			       		w->labelF.labelF_x, y, labelF, (int)(nl - labelF));
		    y += w->labelF.font->max_bounds.ascent + 
		                        w->labelF.font->max_bounds.descent;
		    labelF = nl + 1;
	        }
	        len = strlen(labelF);
	    }
	    if (len) {
	        if (w->labelF.encoding)
		    XDrawString16(XtDisplay(gw), XtWindow(gw), gc,
			     w->labelF.labelF_x, y, (TXT16*)labelF, len/2);
	        else
		    XDrawString(XtDisplay(gw), XtWindow(gw), gc,
			   w->labelF.labelF_x, y, labelF, len);
	    }

        } /*endif international*/

    } else if (w->labelF.labelF_len == 1) { /* depth */
	XCopyPlane(XtDisplay(gw), w->labelF.pixmap, XtWindow(gw), gc,
				0, 0, w->labelF.labelF_width, w->labelF.labelF_height,
				w->labelF.labelF_x, w->labelF.labelF_y, 1L);
    } else {
	XCopyArea(XtDisplay(gw), w->labelF.pixmap, XtWindow(gw), gc,
				0, 0, w->labelF.labelF_width, w->labelF.labelF_height,
				w->labelF.labelF_x, w->labelF.labelF_y);
    }

#ifdef notdef
    if (region != NULL)
	XSetClipMask(XtDisplay(gw), gc, (Pixmap)None);
#endif /* notdef */
}

static void _Reposition(lw, width, height, dx, dy)
    LabelFWidget lw;
    Dimension width, height;
    Position *dx, *dy;
{
    Position newPos;
    Position leftedge = lw->labelF.internal_width + LEFT_OFFSET(lw);

    switch (lw->labelF.justify) {

	case XtJustifyLeft   :
	    newPos = leftedge;
	    break;

	case XtJustifyRight  :
	    newPos = width -
		(lw->labelF.labelF_width + lw->labelF.internal_width);
	    break;

	case XtJustifyCenter :
	default:
	    newPos = (int)(width - lw->labelF.labelF_width) / 2;
	    break;
    }
    if (newPos < (Position)leftedge)
	newPos = leftedge;
    *dx = newPos - lw->labelF.labelF_x;
    lw->labelF.labelF_x = newPos;
    *dy = (newPos = (int)(height - lw->labelF.labelF_height) / 2)
	  - lw->labelF.labelF_y;
    lw->labelF.labelF_y = newPos;
    return;
}

static void Resize(w)
    Widget w;
{
    LabelFWidget lw = (LabelFWidget)w;
    Position dx, dy;

    _Reposition(lw, w->core.width, w->core.height, &dx, &dy);
    compute_bitmap_offsets (lw);
}

/*
 * Set specified arguments into widget
 */

#define PIXMAP 0
#define WIDTH 1
#define HEIGHT 2
#define NUM_CHECKS 3

static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
    LabelFWidget curlw = (LabelFWidget) current;
    LabelFWidget reqlw = (LabelFWidget) request;
    LabelFWidget newlw = (LabelFWidget) new;
    int i;
    Boolean was_resized = False, redisplay = False, checks[NUM_CHECKS];

    for (i = 0; i < NUM_CHECKS; i++)
	checks[i] = FALSE;

    for (i = 0; i < *num_args; i++) {
	if (streq(XtNbitmap, args[i].name))
	    checks[PIXMAP] = TRUE;
	if (streq(XtNwidth, args[i].name))
	    checks[WIDTH] = TRUE;
	if (streq(XtNheight, args[i].name))
	    checks[HEIGHT] = TRUE;
    }

    if (newlw->labelF.labelF == NULL) {
	newlw->labelF.labelF = newlw->core.name;
    }

    /*
     * resize on bitmap change
     */
    if (curlw->labelF.left_bitmap != newlw->labelF.left_bitmap) {
	was_resized = True;
    }

    if (curlw->labelF.encoding != newlw->labelF.encoding)
	was_resized = True;

    if ( (curlw->labelF.fontset != newlw->labelF.fontset) &&
					 curlw->simple.international ){
	was_resized = True;
    }
    if (curlw->labelF.labelF != newlw->labelF.labelF) {
        if (curlw->labelF.labelF != curlw->core.name)
	    XtFree( (char *)curlw->labelF.labelF );

	if (newlw->labelF.labelF != newlw->core.name) {
	    newlw->labelF.labelF = XtNewString( newlw->labelF.labelF );
	}
	was_resized = True;
    }

    if (was_resized || (curlw->labelF.font != newlw->labelF.font) ||
	(curlw->labelF.justify != newlw->labelF.justify) || checks[PIXMAP]) {

	SetTextWidthAndHeight(newlw);
	was_resized = True;
    }

    /* recalculate the window size if something has changed. */
    if (newlw->labelF.resize && was_resized) {
	if ((curlw->core.height == reqlw->core.height) && !checks[HEIGHT])
	    newlw->core.height = (newlw->labelF.labelF_height +
				    2 * newlw->labelF.internal_height);

	set_bitmap_info (newlw);

	if ((curlw->core.width == reqlw->core.width) && !checks[WIDTH])
	    newlw->core.width = (newlw->labelF.labelF_width +
				    LEFT_OFFSET(newlw) +
				    2 * newlw->labelF.internal_width);
    }

    if (curlw->labelF.foreground		!= newlw->labelF.foreground
	|| curlw->core.background_pixel != newlw->core.background_pixel
	|| curlw->labelF.font->fid	!= newlw->labelF.font->fid	  ) {

        /* The Fontset is not in the GC - don't make a new GC if FS changes! */

	XtReleaseGC(new, curlw->labelF.normal_GC);
	XtReleaseGC(new, curlw->labelF.gray_GC);
	XmuReleaseStippledPixmap( XtScreen(current), curlw->labelF.stipple );
	GetnormalGC(newlw);
	GetgrayGC(newlw);
	redisplay = True;
    }

    if ((curlw->labelF.internal_width != newlw->labelF.internal_width)
        || (curlw->labelF.internal_height != newlw->labelF.internal_height)
	|| was_resized) {
	/* Resize() will be called if geometry changes succeed */
	Position dx, dy;
	_Reposition(newlw, curlw->core.width, curlw->core.height, &dx, &dy);
    }

    return was_resized || redisplay ||
	   XtIsSensitive(current) != XtIsSensitive(new);
}

static void Destroy(w)
    Widget w;
{
    LabelFWidget lw = (LabelFWidget)w;

    if ( lw->labelF.labelF != lw->core.name )
	XtFree( lw->labelF.labelF );
    XtReleaseGC( w, lw->labelF.normal_GC );
    XtReleaseGC( w, lw->labelF.gray_GC);
    XmuReleaseStippledPixmap( XtScreen(w), lw->labelF.stipple );
}


static XtGeometryResult QueryGeometry(w, intended, preferred)
    Widget w;
    XtWidgetGeometry *intended, *preferred;
{
    LabelFWidget lw = (LabelFWidget)w;

    preferred->request_mode = CWWidth | CWHeight;
    preferred->width = (lw->labelF.labelF_width + 
			    2 * lw->labelF.internal_width +
			    LEFT_OFFSET(lw));
    preferred->height = lw->labelF.labelF_height + 
			    2 * lw->labelF.internal_height;
    if (  ((intended->request_mode & (CWWidth | CWHeight))
	   	== (CWWidth | CWHeight)) &&
	  intended->width == preferred->width &&
	  intended->height == preferred->height)
	return XtGeometryYes;
    else if (preferred->width == w->core.width &&
	     preferred->height == w->core.height)
	return XtGeometryNo;
    else
	return XtGeometryAlmost;
}
