#include <stdio.h>
#include <stdlib.h>
#include "file_types.h"
#include "globals.h"
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <regex.h>

#define CONFIG_FILE ".fb/exts"

struct Ext_Check_Data {
       char *Ext;
       char *PixmapName;
       char *LeftClickCommand;
       char *RightClickCommandName;
       char *RightClickCommand;
       Pixmap *PExtCheck;
       Pixmap *Pshape;
       XpmAttributes *Pattrib;
       regex_t preg;
       int index;
          };

/*
Pixmap *ExtCheckPExtCheck=NULL;
Pixmap *ExtCheckPshape=NULL;
XpmAttributes *ExtCheckPattrib=NULL;
char **ExtCheckExts=NULL;
char **PixmapNames=NULL;
char **ExtCheckCommands=NULL;
*/

struct Ext_Check_Data *ExtCheckData;
int numexts;



Pixmap *Recognize_ExtCheck(char *filename,char *dpname)
{
int i;
int go=-1;


if(filename==NULL)return NULL;
 
 
for(i=0;(i<numexts)&&(go<0);i++)
        if((ExtCheckData[i].Ext!=NULL)&&(ExtCheckData[i].PixmapName!=NULL)){
        if(regexec(&(ExtCheckData[i].preg),dpname,0,NULL,0)==0)go=i;
                 }


if(go>=0){ 
 i=go;
 

 if(ExtCheckData[i].PExtCheck==NULL){ 
 ExtCheckData[i].PExtCheck=calloc(1,sizeof(Pixmap));
 ExtCheckData[i].Pshape=calloc(1,sizeof(Pixmap));
 ExtCheckData[i].Pattrib=calloc(1,sizeof(XpmAttributes));
  XpmReadFileToPixmap(display,root,ExtCheckData[i].PixmapName,
          ExtCheckData[i].PExtCheck,ExtCheckData[i].Pshape,ExtCheckData[i].Pattrib);
           }
   return ExtCheckData[i].PExtCheck;
      }
      else return NULL;
}

void ExtCheck_CallBack(char *filename)
{
int i,j;
int go=-1;
char *command;

#ifdef __DEBUG__
fprintf(stdout,"%s\n",filename);
#endif
if(filename==NULL)return;


 

for(i=0;(i<numexts)&&(go<0);i++)
        if((ExtCheckData[i].Ext!=NULL)&&(ExtCheckData[i].PixmapName!=NULL)){
        if(regexec(&(ExtCheckData[i].preg),filename,0,NULL,0)==0)go=i;
                 }

if(go>=0){
i=go;

if(ExtCheckData[i].LeftClickCommand!=NULL){
           command=NULL;
           (void *)command=calloc(strlen(ExtCheckData[i].LeftClickCommand)+strlen(filename)+20,sizeof(char));
           if(command==NULL)return;
           for(j=0;ExtCheckData[i].LeftClickCommand[j];j++)
                 command[j]=ExtCheckData[i].LeftClickCommand[j];
           command[j]=0;
           strcat(strcat(strcat(command," \""),filename),"\" >& /dev/null &");
           system(command);
           free(command);
                }
}
}


void ExtCheck_RightClickCallback(char *filename)
{
int i,j;
int go=-1;
char *command;

#ifdef __DEBUG__
fprintf(stdout,"%s\n",filename);
#endif
if(filename==NULL)return;


 

for(i=0;(i<numexts)&&(go<0);i++)
        if((ExtCheckData[i].Ext!=NULL)&&(ExtCheckData[i].PixmapName!=NULL)){
        if(regexec(&(ExtCheckData[i].preg),filename,0,NULL,0)==0)go=i;
                 }

if(go>=0){
i=go;

if(ExtCheckData[i].RightClickCommand!=NULL){
           command=NULL;
           (void *)command=calloc(strlen(ExtCheckData[i].RightClickCommand)+strlen(filename)+20,sizeof(char));
           if(command==NULL)return;
           for(j=0;ExtCheckData[i].RightClickCommand[j];j++)
                 command[j]=ExtCheckData[i].RightClickCommand[j];
           command[j]=0;
           strcat(strcat(strcat(command," \""),filename),"\" >& /dev/null &");
           system(command);
           free(command);
                }
}
}

char * ExtCheck_RightClickCallbackName(char *filename)
{
int i;
int go=-1;


#ifdef __DEBUG__
fprintf(stdout,"%s\n",filename);
#endif
if(filename==NULL)return NULL;


 

for(i=0;(i<numexts)&&(go<0);i++)
        if((ExtCheckData[i].Ext!=NULL)&&(ExtCheckData[i].PixmapName!=NULL)){
        if(regexec(&(ExtCheckData[i].preg),filename,0,NULL,0)==0)go=i;
                 }

if(go>=0){
i=go;

return(ExtCheckData[i].RightClickCommandName);
}
return NULL;
}


void ExtCheckAllocOne(struct Ext_Check_Data *a)
{
a->Ext=NULL;
a->PixmapName=NULL;
a->LeftClickCommand=NULL;
a->RightClickCommandName=NULL;
a->RightClickCommand=NULL;
a->PExtCheck=NULL;
a->Pshape=NULL;
a->Pattrib=NULL;
a->index=-1;
}

void ExtCheckAllocAll(void)
{
int i;

(void *)ExtCheckData=calloc(numexts,sizeof(struct Ext_Check_Data));
  if(ExtCheckData==NULL){numexts=0; return ;}
for(i=0;i<numexts;i++)ExtCheckAllocOne(&(ExtCheckData[i]));
}

void Register_ExtCheck(void)
{
struct Pattern *p;
FILE *exts=NULL;
char s[1000];
int i=0;
char **a;
char *config_file;

config_file=expand(CONFIG_FILE);
exts=fopen(config_file,"r");
if(exts==NULL){
    fprintf(stderr,"Register_ExtCheck():loading \"%s\":",config_file);
    perror("");
    return;}
numexts=0;
while(!feof(exts)){
fgets(s,999,exts);

if(s[0] && (s[0]!='#')){
   if(!strncasecmp(s,"numext",6)){
              numexts=atoi(s+7);
              ExtCheckAllocAll();
                } else
   if(i<numexts){             
   if(!strncasecmp(s,"ext",3)){
           a=&(ExtCheckData[i].Ext);
           (*a)=strdup(s)+4;
           if((*a)[strlen(*a)-1]=='\n')
                 (*a)[strlen(*a)-1]=0;
           if(regcomp(&(ExtCheckData[i].preg),*a,REG_NEWLINE)<0)(*a)=NULL;      
           if(ExtCheckData[i].PixmapName!=NULL)i++;
           } else
   if(!strncasecmp(s,"pixmap",6)){
           a=&(ExtCheckData[i].PixmapName);
           (*a)=strdup(s)+7;          
           if((*a)[strlen(*a)-1]=='\n')
                 (*a)[strlen(*a)-1]=0;
           if(ExtCheckData[i].PixmapName!=NULL)i++;
           }else
   if(!strncasecmp(s,"LCcommand",9)){
           a=&(ExtCheckData[i].LeftClickCommand);
           (*a)=strdup(s)+10;
           if((*a)[strlen(*a)-1]=='\n')
                 (*a)[strlen(*a)-1]=0;
           }else
   if(!strncasecmp(s,"RCcommandName",13)){
           a=&(ExtCheckData[i].RightClickCommandName);
           (*a)=strdup(s)+14;
           if((*a)[strlen(*a)-1]=='\n')
                 (*a)[strlen(*a)-1]=0;
           }else
   if(!strncasecmp(s,"RCcommand",9)){
           a=&(ExtCheckData[i].RightClickCommand);
           (*a)=strdup(s)+10;
           if((*a)[strlen(*a)-1]=='\n')
                 (*a)[strlen(*a)-1]=0;
           }
 
     }
   }
}
fclose(exts);

 p=NULL;
 (void *)p=calloc(1,sizeof(struct Pattern)); 
 if(p==NULL){
  perror("type_ExtCheck.Register_ExtCheck()");
  exit(-1);
  }
  p->R_P=& Recognize_ExtCheck;
  p->C_B=& ExtCheck_CallBack;
  p->data=NULL;
 RegisterPattern(p);

}


