#include <stdio.h>
#include <string.h>

#include "ReadAnImage.h"

/* --------------------------------------------------------------- */
/* An array of strings.  Pointer to this is returned by ReadAnImage_WhatTypes() */
char *ReadAnImage_Types[] = 
{
  "PGM", "PPM",
#ifdef JPEG
  "JPEG",
#endif
#ifdef GIF
  "GIF87a",
  "GIF89a",
#endif
#ifdef PNG
  "PNG",
#endif
  "",
  NULL
};

char **
ReadAnImage_WhatTypes()
{
  return ReadAnImage_Types;
}

/*
  Returns 
  0 on successful reading
  */
int
ReadAnImage(FILE *fh_in, struct RAI_IMAGE *image)
{

  unsigned char *readbuf;
  int buf_offset;
  int itemp;
  int erc;
  int glevels;
  FILE *fh_input;

  /* private buffer so we can look at magic number */
  readbuf=(unsigned char *)malloc(BUFSIZ);
  setbuf(fh_in, readbuf);

  /* Where will beginning of file data be in readbuf */
  buf_offset=StdioBufStart();

  /* hackify to fill our new buffer */
  ungetc( getc(fh_in), fh_in);

  if( 
     (readbuf[buf_offset] == 0x1f) 
     && (readbuf[1+buf_offset] == 0x8b)  || /* Gzipped ? */
     (readbuf[buf_offset] == 0x1f)
     && (readbuf[1+buf_offset] == 0x9d) )  /* Compressed ? */
    {
      char *tempfile;
      char buff[1024];
      unsigned char uc;
      FILE *fh_out;

      if(flag_verbose)
	puts("gzipped/compressed data");

      sprintf(buff, "/tmp/zview.%d", (int)getpid());
      tempfile=strdup(buff);
      fh_out=fopen(tempfile, "w");
      while(fread(&uc, 1, 1, fh_in))
	fwrite(&uc, 1, 1, fh_out);
      fclose(fh_out);

      fclose(fh_in);

      sprintf(buff, "zcat %s", tempfile);
      fh_in=popen(buff, "r");
      setbuf(fh_in, readbuf);
      /* hackify to fill our new buffer */
      ungetc( getc(fh_in), fh_in);
      
      free(tempfile);
    }

  /* Check magic numbers */
  if(     strncmp(readbuf+buf_offset,     "P5", 2) == 0)
    image->type=RAI_TYPE_PGM;
  else if(strncmp(readbuf+buf_offset,     "P2", 2) == 0)
    image->type=RAI_TYPE_PGM;
  else if(strncmp(readbuf+buf_offset,     "P6", 2) == 0)
    image->type=RAI_TYPE_PPM;
  else if(strncmp(readbuf+buf_offset,     "P3", 2) == 0)
    image->type=RAI_TYPE_PPM;
  else if(strncmp(&readbuf[6+buf_offset], "JFIF", 4) == 0)
    image->type=RAI_TYPE_JPEG;
  else if(strncmp(readbuf+buf_offset,     "GIF87a", 6) == 0)
    image->type=RAI_TYPE_GIF87;
  else if(strncmp(readbuf+buf_offset,     "GIF89a", 6) == 0)
    image->type=RAI_TYPE_GIF89;
#ifdef PNG
  else if(png_check_sig(readbuf+buf_offset, 8))
    image->type=RAI_TYPE_PNG;
#endif

  else
    {

      /* Hope for pre-specified raw types */

      if(RAI_TYPE_RGB==image->type)
	{
	  if(flag_verbose)
	    printf(" ReadAnImage: Raw RGB bytes\n");
	  image->bytespp=3;
	}
      else if(RAI_TYPE_GRAY8==image->type)
	{
	  if(flag_verbose)
	    printf(" ReadAnImage: Raw GRAY8 bytes\n");
	  image->bytespp=1;
	}
      else
	return -1;

      if(image->height>0)
	{
	  /* Read whole thing at once */
	  image->data=(unsigned char **)
	    Calloc2d(image->height, image->bytespp*image->width,
		     sizeof(unsigned char));
	  fread(*(image->data), image->bytespp, image->height*image->width, fh_in);
	}
      else
	{
	  int count;
	  /* Lazy caller.  Have to read one damn row at a time */
	  image->data=(unsigned char **)0;
	  image->height=0;
	  do
	    {
	      image->data=(unsigned char **)realloc(image->data,
						    1+image->height*sizeof(unsigned char *));
	      image->data[image->height]=(unsigned char *)calloc(image->width*image->bytespp);
	      count=fread(image->data[image->height], image->bytespp, image->width, fh_in);
	      if(image->width==count)
		{
		  if(flag_verbose>1)
		    printf(" ReadAnImage(): read row %d, %d bytes (%d pixels)\n",
			   image->height, count, image->width);
		  image->height++;
		}
	      else
		count=0;
	    }
	  while(count);
	}
    }


  switch (image->type) {
    struct RAI_IMAGE img;
  case RAI_TYPE_PGM:
    if(flag_verbose)
      printf(" ReadAnImage: PGM\n");
    erc=ReadPGM(fh_in, &image->data, &image->height, &image->width, &glevels);
    image->bytespp=8;
    break;
  case RAI_TYPE_PPM:
    if(flag_verbose)
      printf(" ReadAnImage: PPM\n");
    erc=ReadPPM(fh_in, &image->data, &image->height, &image->width, &glevels);
    image->bytespp=3;
    break;
  case RAI_TYPE_PNG:
    if(flag_verbose)
      printf(" ReadAnImage: PNG\n");
    erc=ReadPNG(fh_in, &image->data, &image->height, &image->width, &image->bytespp);
    break;
  case RAI_TYPE_JPEG:
    if(flag_verbose)
      printf(" ReadAnImage: JPEG\n");
    erc=ReadJPEG(fh_in, &image->data, &image->height, &image->width, &image->bytespp);
    break;
  case RAI_TYPE_GIF87:
    if(flag_verbose)
      printf(" ReadAnImage: GIF87a\n");
    erc=ReadGIF(fh_in, &image->data, &image->height, &image->width, &glevels);
    image->bytespp=3;
    break;
  case RAI_TYPE_GIF89:
    if(flag_verbose)
      printf(" ReadAnImage: GIF89a\n");
    erc=ReadGIF(fh_in, &image->data, &image->height, &image->width, &glevels);
    image->bytespp=3;
    break;
  }
  return erc;
}
