#ifndef readanimage_h
#define readanimage_h


#ifdef PNG
#include "png.h"
#endif

/* --------------------------------------------------------------- */
/* ReadAnImage.h */

struct RAI_IMAGE
{
  int width;
  int height;
  int bytespp;
  unsigned char **data;
  int type;
};
extern int flag_verbose;
int ReadAnImage(FILE *fh_in, struct RAI_IMAGE *image);
char **ReadAnImage_WhatTypes();

#define RAI_TYPE_GIF87 0x010
#define RAI_TYPE_GIF89 0x020
#define RAI_TYPE_JPEG  0x030
#define RAI_TYPE_PPM   0x040
#define RAI_TYPE_PGM   0x050
#define RAI_TYPE_PBM   0x060
#define RAI_TYPE_PNG   0x070
#define RAI_TYPE_RAW   0x080
#define RAI_TYPE_GRAY8 0x080
#define RAI_TYPE_RGB   0x090

#define RAI_COLOR      0x001
#define RAI_GRAY       0x000

#define RAI_IsColor(img) (img->type && RAI_COLOR)

#endif
