#include <stdio.h>
#include <stdarg.h>
#include "gd.h"

/*
 * ReadGIF()
 * Reads a GIF.  Duh.
 * Requires gd.h from libgd
 */

int ReadGIF(FILE *fh, unsigned char ***image, int *image_height, int *image_width, int *glevels);
     

int
ReadGIF(FILE *fh, unsigned char ***image, int *image_height, int *image_width, int *glevels)
{
  unsigned char **img_uc;
  int ih, iw;
  int iindex;

  gdImagePtr im;
  im = gdImageCreateFromGif(fh);

  *image_width=gdImageSX(im);
  *image_height=gdImageSY(im);
  *glevels=255;

  img_uc=(unsigned char **)Calloc2d(*image_height, *image_width*3, sizeof(unsigned char));

  for(ih=0; ih<*image_height; ih++)
    for(iw=0; iw<*image_width; iw++)
      {
	iindex=gdImageGetPixel(im,iw,ih);
	img_uc[ih][3*iw]=gdImageRed(im, iindex);
	img_uc[ih][3*iw+1]=gdImageGreen(im, iindex);
	img_uc[ih][3*iw+2]=gdImageBlue(im, iindex);
      }

  gdImageDestroy(im);

  *image=img_uc;
  
  return(0);
}
