#include <fcntl.h>
#include <stdio.h>


#define BUFFLEN 1024

ReadPGM(FILE *fh, unsigned char ***image, int *image_height, int *image_width, int *glevels)
{
  int i;
  int erc;
  char buff[BUFFLEN];
  int image_glevels;
  int ih;
  int iw;
  int itemp;
  int flag_raw = 0;
  
  unsigned char **img;
  
  if(fh == NULL)
    {
      fprintf(stderr, "ReadPGM():  Could not read from input.\n");
      return(1);
    }

  fgets(buff, BUFFLEN, fh);

  /* raw or ascii */
  if(strncmp("P5", buff, 2) == 0)
    flag_raw=1;
  else if(strncmp("P2", buff, 2) != 0)
    return -1;
  while(*(fgets(buff, BUFFLEN, fh)) == '#');
  sscanf(buff, "%d %d", image_width, image_height);
  while(*(fgets(buff, BUFFLEN, fh)) == '#');
  sscanf(buff, "%d", &image_glevels);

  *image=(unsigned char **)Calloc2d(*image_height, *image_width, sizeof(unsigned char));
  img=*image;
  *glevels=image_glevels;
  
  if(flag_raw)
    {
      erc=fread(&img[0][0], 1, *image_height**image_width, fh);
      if(erc!= *image_height**image_width)
	{
	  fprintf(stderr, "ReadPGM(): short read\n");
	  return 1;
	}
    }
  else
    for(ih=0; ih<*image_height; ih++)
      for(iw=0; iw<*image_width; iw++)
	{
	  erc=fscanf(fh, "%d ", &itemp);
	  img[ih][iw]=(unsigned char)itemp;

	  if(erc != 1) 
	    Death(-1, "ReadPGM():  short read\n");
	}

  return(0);
      
}

#ifdef UNDEF
for(i=0; i<*image_height; i++)
    {
      erc=fread(img[i], 1, *image_width, fh);
      if(erc != *image_width)
	{
	  fprintf(stderr, "ReadPGM(): short read on line %d.\n", i);
	  return(1);
	}
    }
		
  return(0);
}

#endif
