#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define DEBUG 1
#define BUFFLEN 1024

int
ReadPPM(FILE *fh, unsigned char ***image, int *image_height, int *image_width, int *image_glevels)
{
  int i;
  int erc;
  unsigned char **img;
  int ih;
  int iw;
  long ltemp;
  int arg;
  char buff[BUFFLEN];
  int flag_raw = 0;
  char cdata[3];
  char *cptr[3];
  int data[3];

  fgets(buff, BUFFLEN, fh);

  /* raw or ascii */
  if(strncmp("P6", buff, 2) == 0)
    flag_raw=1;
  else if(strncmp("P3", buff, 2) != 0)
    return -1;

  while(*(fgets(buff, BUFFLEN, fh)) == '#');
  sscanf(buff, "%d %d", image_width, image_height);
  while(*(fgets(buff, BUFFLEN, fh)) == '#');
  sscanf(buff, "%d", image_glevels);

  *image=(unsigned char **)Calloc2d(*image_height, *image_width*3, sizeof(unsigned char));
  img=*image;
  
#ifdef DEBUG
  fprintf(stderr, "ReadPPM():  PPM_FORMAT\n");
#endif
  for(ih=0; ih<*image_height; ih++)
    {
      for(iw=0; iw<*image_width; iw++)
	{
	  if(flag_raw)
	    {
	      erc=fread(&img[ih][iw*3], 1, 3, fh);
	    }
	  else
	    {
	      erc=fscanf(fh, "%d %d %d", &data[0], &data[1], &data[2]);
	      img[ih][iw*3]=(unsigned char)data[0];
	      img[ih][iw*3+1]=(unsigned char)data[1];
	      img[ih][iw*3+2]=(unsigned char)data[2];
	    }

	  if(erc != 3) 
	    Death(-1, "ReadPPM():  short read\n");
	}
    }
  return(0);
      
}





