/* set_sizehints() lifted from xev.c [ J. Crowe ] */

/* $XConsortium: xev.c,v 1.15 94/04/17 20:45:20 keith Exp $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * Author:  Jim Fulton, MIT X Consortium
 */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xutil.h>
#include <ctype.h>

extern Display *display;

set_sizehints (hintp, min_width, min_height,
	       defwidth, defheight, defx, defy, geom)
     XSizeHints *hintp;
     int min_width, min_height, defwidth, defheight, defx, defy;
     char *geom;
{
  int geom_result;

  /* set the size hints, algorithm from xlib xbiff */

  hintp->width = hintp->min_width = min_width;
  hintp->height = hintp->min_height = min_height;
  hintp->flags = PMinSize;
  hintp->x = hintp->y = 0;
  geom_result = NoValue;
  if (geom != NULL)
    {
      geom_result = XParseGeometry (geom, &hintp->x, &hintp->y,
				    (unsigned int *)&hintp->width,
				    (unsigned int *)&hintp->height);
      if ((geom_result & WidthValue) && (geom_result & HeightValue)) {
#define max(a,b) ((a) > (b) ? (a) : (b))
								       hintp->width = max (hintp->width, hintp->min_width);
								       hintp->height = max (hintp->height, hintp->min_height);
								       hintp->flags |= USSize;
								     }
      if ((geom_result & XValue) && (geom_result & YValue)) {
							      hintp->flags += USPosition;
							    }
    }
  if (!(hintp->flags & USSize))
    {
      hintp->width = defwidth;
      hintp->height = defheight;
      hintp->flags |= PSize;
    }
  /*
     if (!(hintp->flags & USPosition)) {
     hintp->x = defx;
     hintp->y = defy;
     hintp->flags |= PPosition;
     }
     */
  if (geom_result & XNegative)
    {
      hintp->x = DisplayWidth (display, DefaultScreen (display)) + hintp->x -
	hintp->width;
    }
  if (geom_result & YNegative) {
    hintp->y = DisplayHeight (display, DefaultScreen (display)) + hintp->y -
      hintp->height;
  }
  return;
}
