/*
	Program : kshow
	Author  : Ralf Berger
	E-Mail  : rberger@fun.horx.de

	configdlg.cpp
*/

#include <kapp.h>
#include <klocale.h>
#include <ktabctl.h>
#include "configdlg.h"

ConfigDialog::ConfigDialog( QWidget *parent )
	: QDialog( parent, "kShow Options", TRUE ) {

	int width = 300;
	int height = 250;

	resize( width, height);
	setFixedSize( size() );
	setCaption( klocale->translate( "kShow Options" ) );

	karten = new KTabCtl( this );
	karten->setGeometry( 5, 5, width - 10, height - 50 );

	///// WINDOW SETTINGS /////

	window = new QWidget( karten );
	karten->addTab( window, klocale->translate( "Window" ) ); 

	win_fix = new QCheckBox( klocale->translate("fixed Rectangle"), window );
	win_fix->setGeometry( 20, 10, width - 20, 30 );

	lb_width = new QLabel( klocale->translate("Window Width:"), window );
	lb_width->setAlignment(AlignRight | AlignVCenter);
	lb_width->setGeometry( 30, 50, 100, 25);
  	win_width = new QLineEdit( window );
	win_width->setGeometry( 150, 50, 50, 25);
	win_width->setMaxLength(4);

	lb_height = new QLabel( klocale->translate("Window Height:"), window );
	lb_height->setAlignment(AlignRight | AlignVCenter);
	lb_height->setGeometry( 30, 90, 100, 25);
  	win_height = new QLineEdit(window );
	win_height->setGeometry( 150, 90, 50, 25);
	win_height->setMaxLength(4);
		
	lb_bgcolor = new QLabel( klocale->translate("BackgroundColor:"), window );
	lb_bgcolor->setAlignment(AlignRight | AlignVCenter);
	lb_bgcolor->setGeometry( 30, 130, 100, 25);

	win_bgcolor = new KColorButton( WinColor, window );
	win_bgcolor->move( 150, 130 );
	win_bgcolor->resize( 50, 25 );

	setFix();
	connect( win_fix, SIGNAL( clicked() ), SLOT( click_win_fix() ) );
	connect( win_bgcolor, SIGNAL( changed( const QColor & ) ), SLOT ( colorchange( const QColor & ) ) ); 
	connect( win_width, SIGNAL( textChanged(constchar*) ), SLOT ( widthchange( const char * ) ) );
	connect( win_height, SIGNAL( textChanged(constchar*) ), SLOT ( heightchange( const char * ) ) );

	///// DiaShow SETTINGS /////

	diashow = new QWidget( karten );
	karten->addTab( diashow, klocale->translate( "PictureShow" ) );

	lb_tx = new QLabel( klocale->translate("Delay Time"), diashow );
	lb_tx->setAlignment(AlignCenter | AlignVCenter);
	lb_tx->setGeometry( 20, 25, 120, 25);

	lcd = new QLCDNumber( 2, diashow );
	lcd->setGeometry( 20, 50 , 120, 30 );
	lcd->setFrameStyle(QFrame::NoFrame);
	lcd->setNumDigits( 2 );

	lb_sk = new QLabel( klocale->translate("Seconds"), diashow );
	lb_sk->setAlignment(AlignCenter | AlignVCenter);
	lb_sk->setGeometry( 20, 80, 120, 25);

	slider = new KSlider( 1, 30, 1, 1, KSlider::Horizontal, diashow );
	slider->setRange( 0, 30 );
	slider->setSteps( 1, 10 );
	slider->setGeometry( 20, 110, 120, 20 );

	connect( slider, SIGNAL( valueChanged( int ) ), SLOT( timechange( int ) ));

	dia_for = new QCheckBox( klocale->translate("show forward"), diashow );
	dia_for->setGeometry( 160, 10, width - 20, 27 );

	dia_bac = new QCheckBox( klocale->translate("show backward"), diashow );
	dia_bac->setGeometry( 160, 40, width - 20, 27 );

	dia_ran = new QCheckBox( klocale->translate("show random"), diashow );
	dia_ran->setGeometry( 160, 70, width - 20, 27 );
	
	dia_loop = new QCheckBox( klocale->translate("show loop"), diashow );
	dia_loop->setGeometry( 160, 120, width - 20, 27 );

	connect( dia_for, SIGNAL( clicked() ), SLOT( showvalue_1() )); 
	connect( dia_bac, SIGNAL( clicked() ), SLOT( showvalue_2() ));
	connect( dia_ran, SIGNAL( clicked() ), SLOT( showvalue_3() ));
	connect( dia_loop, SIGNAL( clicked() ), SLOT( click_dia_loop() ));
	
	///// Ende SETTINGS /////
	// save button
	save = new QPushButton(klocale->translate("Save"), this);
	save->setGeometry( 10, height - 37, 72, 27);
	connect(save, SIGNAL(clicked()), SLOT( press_save() ));
  
	// use button
	use = new QPushButton(klocale->translate("Use"), this);
	use->setGeometry( 92, height - 37, 72, 27);
	connect(use, SIGNAL(clicked()), SLOT( press_use() ));

	// cancel button
	cancel = new QPushButton(klocale->translate("Cancel"), this);
	cancel->setGeometry(width - 82, height - 37, 72, 27);
	connect(cancel, SIGNAL(clicked()), SLOT( reject()));
}

void ConfigDialog::press_use() {

	done(1);
}

void ConfigDialog::press_save() {

	done(2);
}

void ConfigDialog::click_win_fix() {

	if( win_fix->isChecked() == TRUE) {
		WinFix = TRUE;
	} 
	else {	WinFix = FALSE;
	}
	setFix();
}

void ConfigDialog::setFix() {

	if( WinFix == TRUE ) {
		win_fix->setChecked( TRUE );
	}
	win_width->setEnabled( win_fix->isChecked() );
	win_height->setEnabled( win_fix->isChecked() );
}

void ConfigDialog::colorchange( const QColor &newColor ) {

	if (WinColor != newColor )
		WinColor = newColor;
}

void ConfigDialog::widthchange( const char *newWidth ) {

	if (WinWidth != newWidth )
		WinWidth = newWidth;
}

void ConfigDialog::heightchange( const char *newHeight ) {

	if (WinHeight != newHeight )
		WinHeight = newHeight;
}

void ConfigDialog::showvalue_1() {

	dia_for->setChecked( TRUE );
	dia_bac->setChecked( FALSE );
	dia_ran->setChecked( FALSE );	
	ShowAction = 1;
}

void ConfigDialog::showvalue_2() {

	dia_for->setChecked( FALSE );
	dia_bac->setChecked( TRUE );
	dia_ran->setChecked( FALSE );
	ShowAction = 2;
}

void ConfigDialog::showvalue_3() {

	dia_for->setChecked( FALSE );
	dia_bac->setChecked( FALSE );
	dia_ran->setChecked( TRUE );
	click_dia_loop();
	ShowAction = 3;
}

void ConfigDialog::click_dia_loop() {

	if( dia_ran->isChecked() == TRUE)
		dia_loop->setChecked( FALSE );
	if( dia_loop->isChecked() == TRUE) {
		ShowLoop = TRUE;
	} 
	else {	ShowLoop = FALSE;
	}
}

void ConfigDialog::timechange( int newtime ) {

	ShowTime = newtime;
	lcd->display(ShowTime);
}

void ConfigDialog::setOptions( struct opt_struct optstr ) {

	WinFix = optstr.WinFix;	
	WinWidth = optstr.WinWidth;
	WinHeight = optstr.WinHeight;
	WinColor = optstr.WinColor;
	ShowAction = optstr.ShowAction;
	ShowTime = optstr.ShowTime;
	ShowLoop = optstr.ShowLoop;

	win_width->setText( WinWidth );
	win_height->setText( WinHeight );
	win_bgcolor->setColor( WinColor );
	setFix();

	if( ShowLoop == TRUE )
		dia_loop->setChecked( TRUE );
	else { dia_loop->setChecked( FALSE );
	}

	if( ShowAction == 1 )
		showvalue_1();
	else if( ShowAction == 2 )
		showvalue_2();
	else if( ShowAction == 3 )
		showvalue_3();

	slider->setValue( ShowTime );
	lcd->display(ShowTime);
}

struct opt_struct ConfigDialog::getOptions() { 

	optstr.WinFix = WinFix;
	optstr.WinWidth = WinWidth;
	optstr.WinHeight = WinHeight;
	optstr.WinColor = WinColor;
	optstr.ShowAction = ShowAction;
	optstr.ShowTime = ShowTime;
	optstr.ShowLoop = ShowLoop;

	return optstr;
}
