/*
	Program : kshow
	Author  : Ralf Berger
	E-Mail  : rberger@fun.horx.de

	pixview.h
*/

#include <qlabel.h>
#include <qpixmap.h>
#include <qwmatrix.h>
#include <qpopmenu.h>
#include <qpmcache.h>
#include <qpainter.h>
#include <qpen.h>

class PixView : public QLabel
{
	Q_OBJECT
private:
	QWMatrix	*matrix;
	QPopupMenu	*popmenu; 
	QPixmap		*copyimage;
	QPixmap	 	*image;
	int		startx, starty;
	int		oldx, oldy;
	bool		draw;

public:
	PixView(QWidget *parent=0, const char *name=0, WFlags f = 0);
	bool load(const char *filename);

public slots:	
	void restoreImage();
	void zoomIn( int );
	void zoomOut( int );
	void zoomPixmap( int );
signals:
	void sizeChanged();

protected:
	void mousePressEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void mouseReleaseEvent( QMouseEvent * );
};

