/* fontdemo - taken from my g3vga - a simple g3 FAX fiewer -
   Mitch 30th May 1994 (m.dsouza@mrc-apu.cam.ac.uk) */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <vga.h>
#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>
#include "fontdemo.h"
#include "fontutils.h"
#include "vgaget.h"
#include "miscutils.h"
#include "loadim.h"
/*
   Mode    1: 320x200, 16 colors (4 bitplanes)
   Mode    2: 640x200, 16 colors (4 bitplanes)
   Mode    3: 640x350, 16 colors (4 bitplanes)
   Mode    4: 640x480, 16 colors (4 bitplanes)
   Mode    5: 320x200, 256 colors (linear)
   Mode    6: 320x240, 256 colors (Mode X)
   Mode    7: 320x400, 256 colors (Mode X)
   Mode    8: 360x480, 256 colors (Mode X)

 */

/* Everyone should have this one at least these days */
#define DEFAULTMODE 3;

void
main (int argc, char **argv)
{
  int MODE;
  vga_modeinfo *modeinfo;
  int i,
    j;

  int xmax,
    ymax;
  int bw = BORDER_WIDTH;

  font_t *pfont,
   *tfont;
#if STANDARD_FONTS
  char *testfonts[] =
  {
    "",				/* this empty string selects the default font default8x16 */
    "880.cp",
    "972.cp",
    "Cyr_a8x16",
    "aply16.psf",
    "def2_8x16",
    "gr.f16",
    "iso01.f16",
    "koi8-14.psf",
    "lat1-16.psf",
    NULL,
  };
#else
  char *testfonts[] =
  {
    "",				/* this empty string selects the default font default8x16 */
    "ibm-16",
    "thin-14",
    "antique-16",
    "greek-16",
    "squashed-14",
    "medieval-16",
    "roman-16",
    "Cyr_a8x8",
    "hisquash-8",
    "koi8-14.psf",
    "courier-16",
    "broadway-16",
    NULL,
  };
#endif
  vga_bitmap bitmap;

  vga_init ();
  MODE = vga_getdefaultmode ();
  if (MODE == -1)
    MODE = 3;
  vga_setmode (MODE);

  modeinfo = vga_getmodeinfo (MODE);

  xmax = vga_getxdim () - 1;
  ymax = vga_getydim () - 1;

#ifdef XPM

	/* Tile the whole screen with the requested image */
	if (argv[1])
		loadxpm(argv[1],&bitmap);
	else
		loadxpm("leaves.xpm", &bitmap);

    #if 0
	/* By specifying negative values for wid or ht we don't tile but just
	load exact size pixmap with the top left at the requested x, y */
	vga_tile(&bitmap, 20, 30, -1, -1);
    #else
	vga_tile(&bitmap, 0, 0, xmax+1, ymax+1); 
    #endif

#else
	/* Since XBM bitmaps are 2 bit deep only, we use auxilrary functions
	   to set the background and foreground. These are in effect until
	   you explicitly change it */

	vga_xbmsetbg(DARKGRAY);
	vga_xbmsetfg(LIGHTRED);

	if (argv[1])
		loadxbm(argv[1],&bitmap);
	else
		loadxbm("root.xbm",&bitmap);

	vga_tile(&bitmap, 0,0, xmax+1,ymax+1);
#endif

#if 1
{
/* This is a demo of how to include a static bitmap in your program */
/* this can't be done for a XPM color pixmap at the moment :-( */

#include "root.xbm"
vga_bitmap bm;

	vga_xbmsetbg(RED);
	vga_xbmsetfg(LIGHTGRAY);

	loadxbmfromdata(logo_bits, logo_width, logo_height, &bm);
	vga_tile(&bm, 20,20, xmax+1-40, ymax+1-40);
	free(bm.data);
}
#endif

  pfont = malloc (sizeof (font_t));
  tfont = malloc (sizeof (font_t));
#if STANDARD_FONTS
  vga_initfont ("", pfont, 2, 1);
  vga_initfont ("koi8-14.psf", tfont, 1, 1);
#else
  vga_initfont ("roman-16", pfont, 1, 1);
  vga_initfont ("m", tfont, 1, 1);
#endif
  vga_setfont_xor(pfont);
  vga_write ("Font Demo Test with center alignment", xmax >> 1, bw + 30,
	     pfont, YELLOW, BLUE, ALIGN_CENTER);

  for (i = bw + 60, j = 0; testfonts[j] && i < ymax; i += 20, j++) {
    char message[1024];

    sprintf (message, "This font is %s", testfonts[j]);
    vga_initfont (testfonts[j], pfont, 1, 1);
    vga_write (message, xmax >> 1, i,
	       pfont, GREEN, BLACK, ALIGN_CENTER);
  }
#if STANDARD_FONTS
  vga_initfont ("972", pfont, 1, 1);
#else
  vga_initfont ("roman-16", pfont, 1, 1);
#endif

#define prompt_wid	220
#define prompt_ht	88
#define prompt_x	((xmax+1 - prompt_wid)>>1)
#define prompt_y	((ymax+1 - prompt_ht)>>1)

  {
    char *prompts[2] =
    {"Login:   ",
     "Password:"
    };
    char opts[2] =
    {PROMPT_SCROLLABLE,
     PROMPT_FIXED | PROMPT_NOECHO
    };
    char *replys[2];
    font_t titlefont;
    char hostname[64];
    extern int callback ();

    gethostname (hostname, 64);
    vga_initfont ("", &titlefont, 3, 1);

    vga_form (prompt_x, prompt_y, prompt_wid, prompt_ht,
	      prompts, replys, 2,
	      hostname, &titlefont,
	      pfont, tfont,
	      LIGHTGREEN, GREEN, YELLOW, BLUE,
	      callback, opts);

    printf ("%s returned (%s)\n", prompts[0], replys[0]);
    printf ("%s returned (%s)\n", prompts[1], replys[1]);

  }
  free (tfont);
  free (pfont);
  getchar ();
  vga_setmode (TEXT);
}

int 
callback (int cbnum, char *arg)
{
  static struct passwd *pwd = NULL;

  switch (cbnum) {
  case 0:
    fprintf (stderr, "Callback check for user got (%s)\n", arg);
    if (pwd = getpwnam (arg))
      return FIELD_OK;
    else {
      char message[] = "No such user";
      int message_len = strlen (message);
      font_t fnt;

      vga_initfont ("", &fnt, 1, 1);
      vga_message ((vga_getxdim () - message_len * 8) / 2,
		   (vga_getydim ()) / 2,
		   16 + message_len * 8,
		   8 + fnt.font_height,
		   message, &fnt, YELLOW, RED, 1);
      return FIELD_CLEAR;
    }
  case 1:
    fprintf (stderr, "Callback check for pass got (%s)\n", arg);
    if (pwd && strncmp (pwd->pw_passwd, crypt (arg, pwd->pw_passwd), 13)) {
      char message[] = "Invalid Password doode";
      int message_len = strlen (message);
      font_t fnt;

      vga_initfont ("", &fnt, 1, 1);
      vga_message ((vga_getxdim () - message_len * 8) / 2,
		   (vga_getydim ()) / 2,
		   16 + message_len * 8,
		   8 + fnt.font_height,
		   message, &fnt, YELLOW, RED, 1);
      return FIELD_CLEAR;
    } else
      return FIELD_OK;
  }
  return FIELD_OK;
}
