#ifndef _VGA_FONTUTILS_H
#define _VGA_FONTUTILS_H 1
/*
 * All data is in subdirectories of DATADIR, by default /usr/lib/kbd
 * The following three subdirectories are defined:
 */
#define KEYMAPDIR "keytables"
#define FONTDIR "consolefonts"
#define TRANSDIR "consoletrans"

/*
 * Default keymap, and where the kernel copy of it lives.
 */
#define DEFMAP "defkeymap.map"
#define KERNDIR "/usr/src/linux/drivers/char"

#define DATADIR "/usr/lib/kbd"

#define ALIGN_RIGHT	1
#define ALIGN_LEFT	2
#define ALIGN_CENTER	3

#define FONT_COPY	0
#define FONT_XOR	1

typedef struct {
	char font [8192];	/* 8K of font info */
	char font_height;	/* The font height */
	char xscale;		/* The x scaling factor */
	char yscale;		/* The y scaling factor */
	char misc;		/* For miscellaneous use */
} font_t;

/* Args to vga_initfont()

	1 - Font name - Any name from /usr/lib/kbd/consolefonts
	2 - A user preallocated pointer to return the font struct data in
	3 - The x scaling factor
	4 - The y scaling factor

   Note: The fontname may be "" (i.e. an empty string) if the default font
	 is required.

   Returns 1 on success or 0 if font not found or corrupt

 */

int vga_initfont (char *, font_t *, char, char);

#define vga_setfont_xor(x) (x)->misc=FONT_XOR
#define vga_setfont_copy(x) (x)->misc=FONT_COPY

/* Args to vga_write()

	1 - The text message
	2 - The x position of placement (top left)
	3 - The y position of placement (top left)
	4 - The filled in font struct pointer returned from the vga_initfont()
	5 - The foreground drawing color
	6 - The background drawing color
	7 - Text alignment with respect to the (x,y) posn. Must be one of

		    o	ALIGN_CENTER	(text centered about x posn.)
		    o	ALIGN_RIGHT	(text end adjusted at x posn.)
		    o	ALIGN_LEFT	(text starts at x posn. - default)

   Note: The background color is ignored if the font is xor'ed with
	 the background by calling vga_setfont_xor() before calling this
	 routine.

   Returns 1 if write succeeded 0 if it failed.

 */
int vga_write(char *, short, short, font_t *, short, short, char);

/* Args to vga_putc()

	1 - The character to be placed
	2 - The x position of placement (top left)
	3 - The y position of placement (top left)
	4 - The filled in font struct pointer returned from the vga_initfont()
	5 - The foreground drawing color
	6 - The background drawing color

   Note: The background color is ignored if the font is xor'ed with
	 the background by calling vga_setfont_xor() before calling this
	 routine.

   Returns 1 if write succeeded 0 if it failed.

 */
int vga_putc(char, short, short, font_t *, short, short);

#endif /* _VGA_FONTUTILS_H */
