/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.5                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 02/29/95                                             */
/* Description  : various defines ans typdefs                          */
/*                                                                     */
/***********************************************************************/

/*
 * first of all, own types
 */

typedef struct
        {
        char filename[256];
        int  width;
        int  height;
        int  bpp;
        int  filetype;
        int  gfx_type;
        int  tagged;
        } DIRTAB;
        
typedef struct
        {
        char name[25];
        int  width;
        int  height;
        int  colors;
        int  index;
        int  supported;
        } GMODE;
        


/*
 * and from here we set some own defines
 */

#define BLANK60             "                                                         "

#define MAX_DIRTAB        256     /* maximum of files in directory    */
#define MAX_TYPES           5     /* max filetypes not in gbm         */
#define MAX_MODES          29     /* max count of graphic-modes       */

#define MSG_WINDOW          1     /* Error-Message to Window          */
#define MSG_CONSOLE         2     /* Error-Message to Console         */

#define IS_NOT_FOUND        0     /* file is not found or stat-error  */
#define IS_DIRECTORY        1     /* file is a directory              */
#define IS_FILE             2     /* file is a normal file            */

#define READ_HEADER_ONLY      1   /* read only header of file         */
#define READ_ENTIRE_FILE      2   /* get all data of file             */

#define POS_RIGHT            29   /* right position in dir-box        */
#define POS_LEFT              6   /* left position in dir-box         */

#define VIEW_NEXT            -1   /* view next tagged graphic         */
#define VIEW_ABORT           -2   /* abort viewing tagged graphics    */

#define DO_CHDIR              1   /* change directory                 */
#define DO_QUIT               2   /* quit GRAV                        */
#define DO_VIEW               3   /* view file(s)                     */
#define DO_CONVERT            4   /* convert file                     */
#define DO_INFO               5   /* get file-info                    */
#define DO_INC_MODE           7   /* increment graphic-mode           */
#define DO_DEC_MODE           8   /* decrement graphic-mode           */
#define DO_HELP               9   /* display help-window              */
#define DO_INPUT             10   /* input filename                   */

#define CURSOR_INVISIBLE      0   /* set cursor to invisible          */
#define CURSOR_NORMAL         1   /* set normal cursor                */
#define CURSOR_BOLD           2   /* set bold cursor                  */

#define COLOR_REVERSE        -1   /* set reserve color                */
#define COLOR_NORMAL          0   /* set normal color                 */
#define WHITE_ON_BLUE         1   /* white on blue                    */
#define YELLOW_ON_RED         3   /* yellow on red                    */
#define BLACK_ON_CYAN         4   /* black on cyan                    */
#define WHITE_ON_BLACK        5   /* white on black                   */
#define YELLOW_ON_CYAN        6   /* yellow on cyan                   */
#define YELLOW_ON_BLACK       7   /* yellow on black                  */
#define YELLOW_ON_BLUE        8   /* yellow on blue                   */

#define GRAV_NO_ERROR         0   /* no error                         */
#define GRAV_ERROR_TYPE       1   /* can't detect internal file-type  */
#define GRAV_ERROR_OPEN       2   /* can't open file                  */
#define GRAV_ERROR_HEADER     3   /* can't read file-header           */
#define GRAV_ERROR_PALETTE    5   /* can't read palette               */
#define GRAV_ERROR_ALLOC      6   /* can't malloc memory for bitmap   */
#define GRAV_ERROR_READ       7   /* can't read data                  */
#define GRAV_ERROR_SUPPORT    8   /* graphicmode not supported        */
#define GRAV_ERROR_CREATE     9   /* can't create file                */
#define GRAV_ERROR_FORMAT    10   /* output-format not supported      */
#define GRAV_ERROR_WRITE     11   /* can't write output-file          */
#define GRAV_ERROR_MAXCOLOR  12   /* can only print up to 256 colors  */
#define GRAV_ERROR_COLORS    13   /* too much colors to display       */
#define GRAV_ERROR_CHDIR     14   /* can't change directory           */
#define GRAV_ERROR_JPEGLIB   15   /* JPEGLIB signaled an error        */
#define GRAV_ERROR_EXIST     16   /* file does not exist              */
#define GRAV_ERROR_DIRECTORY 17   /* filename is a directory          */
#define GRAV_ERROR_SCALE     18   /* Error scaling bitmap             */
#define GRAV_ERROR_PNGLIB    19   /* PNGLIB signaled an error         */
#define GRAV_ERROR_FLIP      20   /* An error occured while flipping  */
#define GRAV_ERROR_MIRROR    21   /* An orror occured while mirroring */
