/* $Id$
 * hash.h: hashing functions for images
 * Copyright (c) 1995, Joe Traister
 *
 * $Log$
 *
 */

#define HASH_SIZE 32768
#define hash(r, g, b) (((r)^((g)<<3)^((b)<<7))&0x7fff)

typedef struct colorhist_tag {
  int count;
  UCHAR r, g, b;
} COLORHIST;

typedef struct colorhistlist_tag {
  int count;
  UCHAR r, g, b;
  struct colorhistlist_tag *next;
} COLORHISTLIST;

void freehash(COLORHISTLIST*);
int lookuphash(int r, int g, int b, COLORHISTLIST *hashtable);
int addtohash(int r, int g, int b, int value, COLORHISTLIST *hashtable);
