/*
 * $Id$
 * njpeg.c
 *
 * (formerly example.c from JPEG software v5)
 *
 * $Log$
 *
 */

#include <stdio.h>
#include <jpeglib.h>
#include <jerror.h>
#include <setjmp.h>
#include <malloc.h>
#include <errno.h>
#include "vimage.h"

struct error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct error_mgr *error_ptr;

METHODDEF void error_exit(j_common_ptr cinfo)
{
  error_ptr err = (error_ptr)cinfo->err;
  (*cinfo->err->format_message)(cinfo, errmsg);
  longjmp(err->setjmp_buffer, 1);
}

int ReadJPEGHead(FILE *infile, IMAGE *image)
{
  struct jpeg_decompress_struct cinfo;
  struct error_mgr jerr;

  cinfo.err = jpeg_std_error(&jerr.pub);
  jerr.pub.error_exit = error_exit;
  if (setjmp(jerr.setjmp_buffer)) {
    jpeg_destroy_decompress(&cinfo);
    if (cinfo.err->msg_code == JERR_NO_SOI)
      return 0;
    return -1;
  }
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, infile);
  jpeg_read_header(&cinfo, TRUE);
  image->width = cinfo.image_width;
  image->height = cinfo.image_height;
  if (cinfo.num_components == 3)
    image->palsize = -24;
  else
    image->palsize = -8;
  jpeg_destroy_decompress(&cinfo);
  return 1;
}

int ReadJPEG(FILE *infile, IMAGE *image)
{
  struct jpeg_decompress_struct cinfo;
  int row_size, curr_r=0;
  JSAMPARRAY buffer;
  struct error_mgr jerr;

  rewind(infile);
  cinfo.err = jpeg_std_error(&jerr.pub);
  jerr.pub.error_exit = error_exit;
  if (setjmp(jerr.setjmp_buffer)) {
    jpeg_destroy_decompress(&cinfo);
    if (image->bits)
      free(image->bits);
    return -1;
  }
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, infile);
  jpeg_read_header(&cinfo, TRUE);
  jpeg_start_decompress(&cinfo);
  row_size = cinfo.output_width * cinfo.output_components;
  buffer = (*cinfo.mem->alloc_sarray)
    ((j_common_ptr)&cinfo, JPOOL_IMAGE, row_size, 1);
  if (!(image->bits = (UCHAR *)malloc(row_size*image->height))) {
    jpeg_destroy_decompress(&cinfo);
    strcpy(errmsg, strerror(errno));
    return -1;
  }
  while (cinfo.output_scanline < cinfo.output_height) {
    jpeg_read_scanlines(&cinfo, buffer, 1);
    memcpy(image->bits+curr_r*row_size, buffer[0], row_size);
    curr_r = cinfo.output_scanline;
  }
  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);

  /* At this point you may want to check to see whether any corrupt-data
   * warnings occurred (test whether jerr.pub.num_warnings is nonzero).
   */

  return 0;
}
