/*
 * $Id: pbm.c,v 1.3 1995/09/16 14:01:57 traister Exp traister $
 * pnm.c: a function for reading files in pbm, pgm & ppm formats
 *        At present, only raw format files are supported
 * Copyright (c) 1995, Joe Traister
 * 
 * $Log: pbm.c,v $
 * Revision 1.3  1995/09/16  14:01:57  traister
 * Rewrote error reporting throughout.
 * Added file type table to facilitate adding new image types.
 *
 * Revision 1.2  1995/07/30  19:20:47  traister
 * Updated copyright prior to first public release
 *
 * Revision 1.1  1995/05/13  01:39:13  traister
 * Initial revision
 *
*/
/*   This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */
     
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include "vimage.h"

int type;

/*
  ReadPNM: reads a raw ppm file to an IMAGE struct
*/
int ReadPNMHead(FILE *fpIn, IMAGE *image)
{
  int nColormax, c;

  if (getc(fpIn) == 'P' && (type = getc(fpIn)-'0') > 3 && type < 7 ) {
    do {
      c = getc(fpIn);
      if (c == '#')
        while ((c = getc(fpIn)) != '\n')
          ;
    } while (isspace(c));
    ungetc(c, fpIn);
    if (fscanf(fpIn, "%i", &image->width) != 1)
      return 0;
    do {
      c = getc(fpIn);
      if (c == '#')
        while ((c = getc(fpIn)) != '\n')
          ;
    } while (isspace(c));
    ungetc(c, fpIn);
    if (fscanf(fpIn, "%i", &image->height) != 1)
      return 0;
    do {
      c = getc(fpIn);
      if (c == '#')
        while ((c = getc(fpIn)) != '\n')
          ;
    } while (isspace(c));
    ungetc(c, fpIn);
    if (type > 4 && fscanf(fpIn, "%i", &nColormax) != 1)
      return 0;
    c = getc(fpIn);
    if (!isspace(c))
      ungetc(c, fpIn);
  } else
    return 0;
  switch (type) {
    case 4:
      image->palsize = -1;
      break;

    case 5:
      image->palsize = -8;
      break;
      
    case 6:
      image->palsize = -24;
      break;
  }
  return 1;
}

int ReadPNM(FILE *fpIn, IMAGE *image)
{
  int i, width;

  switch (type) {
  case 4:
    width = (image->width>>3)+(image->width&0x07 ? 1 : 0);
    image->bits = (UCHAR *)malloc(width*image->height);
    for (i=0; i < width*image->height; i++)
      image->bits[i] = getc(fpIn);
    break;

  case 5:
    image->bits = (UCHAR*)malloc(image->width*image->height);
    fread(image->bits, image->width*image->height, 1, fpIn);
    break;

  case 6:
    image->bits = (UCHAR *)malloc(image->width*image->height*3);
    fread(image->bits, image->width*image->height*3, 1, fpIn);
    break;
  }
  return 0;
}
