/*
 * $Id: vimage.h,v 1.5 1995/09/16 14:01:57 traister Exp traister $
 * vimage.h: typdefs & prototypes for vimage.c, an SVGA picture viewer
 *           for Linux
 * Copyright (c) 1995, Joe Traister
 * 
 * $Log: vimage.h,v $
 * Revision 1.5  1995/09/16  14:01:57  traister
 * Rewrote error reporting throughout.
 * Added file type table to facilitate adding new image types.
 *
 * Revision 1.4  1995/09/03  02:14:54  traister
 * Eliminated some globals that were no longer necessary.
 *
 * Revision 1.3  1995/07/30  19:20:47  traister
 * Updated copyright prior to first public release
 *
 * Revision 1.2  1995/05/13  22:40:17  traister
 * Added "break" in slide show when ESC hit.
 *
 * Revision 1.1  1995/05/13  01:41:04  traister
 * Initial revision
 *
*/
/*   This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdio.h>
#include <unistd.h>
#include <vga.h>

#define UCHAR		unsigned char
#define USHORT		unsigned short

typedef struct image_tag {
  int width, height, palsize;
  UCHAR *bits;
  int palette[768];
} IMAGE;

typedef struct ftypes_tag {
  char *name;
  int (*rhead)(FILE*, IMAGE*);
  int (*rfile)(FILE*, IMAGE*);
} FTYPE;

extern int quiet, automode, twopass, floyd, notruecolor;
extern char modename[], errmsg[];
extern vga_modeinfo *modeinfo;
extern FTYPE ftypes[];

int GetFileHead(FILE*, IMAGE*);
int ReadFile(char*, IMAGE*);
int ReadPNMHead(FILE*, IMAGE*);
int ReadPNM(FILE*, IMAGE*);
int ReadGIFHead(FILE*, IMAGE*);
int ReadGIF(FILE*, IMAGE*);
int ReadRasterfileHead(FILE*, IMAGE*);
int ReadRasterfile(FILE*, IMAGE*);
int ReadTargaHead(FILE*, IMAGE*);
int ReadTarga(FILE*, IMAGE*);
int ReadTIFFHead(FILE*, IMAGE*);
int ReadTIFF(FILE*, IMAGE*);
int InitVGA(char*);
void VGAShutdown(void);
void SetModeInfo(IMAGE*);
void SetVideoMode(void);
int Slideshow(char**, int);
int DisplayImage(IMAGE*);
void SetID(void);
int MapToCube(IMAGE*, IMAGE*);
int HeckbertMedianCut(IMAGE*, IMAGE*);
int Scale(IMAGE*, IMAGE*, int, int);

#ifdef JPEG_SUPPORT
int ReadJPEGHead(FILE*, IMAGE*);
int ReadJPEG(FILE*, IMAGE*);
#endif

#ifdef NCURSES_SUPPORT
int fileSelector(char**, int);
#endif
