.TH VIMAGE 1 "17 Jul 1994" "vimage"
.SH NAME
.B vimage 
\- a bitmap viewer for Linux
.SH SYNOPSIS
.B vimage
[
.B \-R
]
[
.B \-a
]
[
.B \-c
]
[
.B \-f
]
[
.B \-q
]
[
.B \-r
]
[
.B \-t
]
[
.B \-x
]
[
.B \-v
]
[
.B \-2
]
[
.B \-d n
]
[
.B \-l n
]
[
.B \-m mode
]
[
.B \-s slide
]
[filename...]
.SH DESCRIPTION
.I Vimage
displays a variety of bitmap formats (GIF, Targa, Sun Rasterfile, PPM,
PGM, PBM, JPEG and TIFF at the moment) on a Linux terminal using
SVGAlib. If the
.B \-m
switch is not given,
.I vimage
uses the environment variable
.B GSVGAMODE
to determine the video mode desired. If
.B GSVGAMODE
is not present or is not valid, and the
.B \-m
switch is not given,
.I vimage
defaults to G320x200x256. If the
.B \-a
switch is given,
.I vimage
ignores any
.B GSVGAMODE
setting and chooses the video mode for each picture based on height, size
and colors in the picture, and available video modes. In any case, if the
size of the picture to be viewed is larger than the video mode, the picture
will be scaled to fit the screen.

.I Vimage
currently supports viewing 24- and 15-bit files on 24-, 16-, 15- and
8-bit displays.  It uses a 6x7x6 RGB color cube with Floyd-Steinberg
dithering to display truecolor images on 8-bit paletted displays, or,
with the
.B \-2
option, uses a Heckbert median cut to compute the best palette. This option
can be combined with the
.B \-f
option to apply a Floyd-Steinberg dither to the image as well.

Files to be displayed may either be specified on the command line or in a
slide file (with the
.B \-s
option).

The slide file contains the names of the files to be displayed, one per
line. It may also contain blank lines. A comment may be placed on a line
by itself or after a filename by preceeding it with a pound sign (#).
.I Vimage
ignores leading and trailing whitespace on a line in the slide file.

If filenames are not provided by either
.B \-s
or on the command line,
and the standard input is not a terminal,
.I vimage
will read one file from standard input and display it.

If the
.B \-c
option is given, the filenames from the command line or from the slide file
will be shown on the terminal using ncurses. The arrow keys may be used to
move the highlight cursor left, right, up or down. If you have specified more
filenames than can fit on the screen, the list will scroll left and right.
Pressing enter causes the file whose name is in the highlight cursor to be
displayed. Pressing any key will return the file selector to the screen.
To exit, press 'q' or ESC. The spacebar is used to mark and unmark files.
Use 's' to display a slide show of the marked files. 'S' saves a list of
the file names to be used with the -s command line option. 'D' deletes the
file the cursor is on. 'x' displays file statistics. 'H' to 'h' displays
a help screen.
.SH OPTIONS
.TP 10
.B \-R
display pictures in a random order.
.TP 10
.B \-a
automatically choose the best video mode available.
.TP 10
.B \-c
use full-screen file selector. (Ignores -R, -q, -r, -x, -d, -l)
.TP 10
.B \-f
adds Floyd-Steinberg dithering when using the Heckbert median cut option (-2).
.TP 10
.B \-q
do not break on or display error messages.
.TP 10
.B \-r
reverse the order that the images are show in.
.TP 10
.B \-t
Do not use 24-bit modes (for Cirrus Logic 5426/28 cards).
.TP 10
.B \-x
do not display pictures, display image statistics instead.
.TP 10
.B \-v
print version and quit.
.TP 10
.B \-2
use Heckbert median cut to compute color palette.
.TP 10
.B \-d n
pause between each picture {n} seconds.
.TP 10
.B \-l n
loop through the pictures {n} times.
.TP 10
.B \-m mode
set video mode to {mode} (overrides
.B GSVGAMODE
variable).
.TP 10
.B \-s slide
read file names to display from file {slide}.
.SH BUGS
Heckbert median cut is slow.

A bug in the SVGA driver causes Cirrus Logic CLDG-5426/28 cards to lock up
during an "automode" slide show if 24-bit modes are used. Use the -t option
with these cards to circumvent this problem.
.SH SEE ALSO
SVGAlib documentation.
.SH AUTHOR
Joseph J. Traister (traister@gate.net)
.SH COPYRIGHT
Copyright (c) 1995 by Joseph J. Traister.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program, in a file named COPYING; if not, write to the
Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
USA.
