#!/usr/bin/wish
# GLOBAL VARIABLES
global res3;
global dimm;
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global formula; 
global graucho; 
global message1; 
global nunt; 
global precs; 
global res1; 
global units; 
global widget; 
global linn; 
# USER DEFINED PROCEDURES
proc init {argc argv} {
global linn; 
global sc1; 
global fnt1
global fnt2
global fnt3
global res3;
set units "mks.units"
set formula "general.formula"
set precs 12
set graucho "-ce"
set sc1 "-S1"
set fnt1 -*-*-*-*-*-*-9-*-*-*-*-*-*-*
set fnt2  -*-*-*-*-*-*-12-*-*-*-*-*-*-*
set fnt3  -*-*-*-*-*-*-15-*-*-*-*-*-*-*
set res3 ""
set linn ""
}

init $argc $argv


proc main {argc argv} {
global linn; 
global sc1; 
global fnt1
global fnt2
global fnt3
global res3;
    set precs 12
    set graucho "-ce"
        wm withdraw .top18
        wm withdraw .top20
        wm withdraw .top56
        wm withdraw .top79
        wm withdraw .top106        
        wm withdraw .top19
 catch {exec ./check1 } ret122  
if { $ret122 != "OK"} {
        wm deiconify .top19
}
}

proc Window {args} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global vTcl
global res3;
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

proc vTclWindow. {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .
    }
    wm focusmodel $base passive
    wm geometry $base 1x1+0+0
    wm maxsize $base 1137 860
    wm minsize $base 1137 834
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm withdraw $base
    wm title $base "t.tcl"
}

proc vTclWindow.top106 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top106
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 512x150+387+54
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Define a new Unit"
    label $base.lab107 \
        -borderwidth 1 -font $fnt1 \
        -text {New unit name:} 
    entry $base.ent108 \
        -font $fnt1 
    bind $base.ent108 <KeyRelease><Key-Return> {
        set nunt [.top106.ent108 get]
    }
    label $base.lab109 \
        -borderwidth 1 -font $fnt1 \
        -text {(Must start with a Capital letter)} 
    label $base.lab110 \
        -borderwidth 1 -font $fnt1 \
        -text X 
    label $base.lab111 \
        -borderwidth 1 -font $fnt1 \
        -text NewU -textvariable nunt 
    label $base.lab112 \
        -borderwidth 1 -font $fnt1 \
        -text {=  X } 
    label $base.lab114 \
        -borderwidth 1 -font $fnt1 \
        -text {using dimentions:} 
    entry $base.ent115 \
        -font $fnt1 
    bind $base.ent115 <KeyRelease><Key-Return> {
        set dimm [.top106.ent115 get]
    }
    label $base.lab117 \
        -borderwidth 1 -font $fnt1 \
        -text OldU -textvariable dimm 
    label $base.lab121 \
        -borderwidth 1 -font $fnt1 \
        -text * 
    entry $base.ent122
    label $base.lab123 \
        -borderwidth 1 -font $fnt1 \
        -text + 
    entry $base.ent124
    label $base.lab125 \
        -borderwidth 1 -font $fnt1 \
        -text OldU -textvariable dimm 
    button $base.but126 \
        -font $fnt1 -padx 9 -pady 3 \
        -text add 
    bind $base.but126 <ButtonRelease-1> {
        exec ./addnewunit -u $units -add2 [.top106.ent124 get] -mult [.top106.ent122 get] -unit [.top106.ent115 get] -name [.top106.ent108 get]
    }
    label $base.lab131 \
        -borderwidth 1 -font $fnt1 \
        -text {this unit to} 
    label $base.lab132 \
        -background #f8eadf -borderwidth 1 \
        -font $fnt1 -text mks.units \
        -textvariable units 
    label $base.lab133 \
        -borderwidth 1 -font $fnt1 \
        -text NewU -textvariable nunt 
    label $base.lab135 \
        -borderwidth 1 -font $fnt1 \
        -text / 
    label $base.lab136 \
        -borderwidth 1 -font $fnt1 \
        -text NewU -textvariable nunt 
    label $base.lab138 \
        -borderwidth 1 -font $fnt1 \
        -relief groove -text {example:  X f =Xf * 0.55555 c/f -17.7 c} 
    button $base.but17 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Ok 
    bind $base.but17 <ButtonRelease-1> {
        exec ./addnewunit -u $units -add2 [.top106.ent124 get] -mult [.top106.ent122 get] -unit [.top106.ent115 get] -name [.top106.ent108 get]
wm withdraw .top106
    }
    button $base.but18 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Close 
    bind $base.but18 <ButtonRelease-1> {
        wm withdraw .top106
    }
    button $base.but19 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Cancel 
    bind $base.but19 <ButtonRelease-1> {
        wm withdraw .top106
    }
    place $base.lab107 \
        -x 5 -y 5 -width 86 -height 18 -anchor nw -bordermode ignore 
    place $base.ent108 \
        -x 95 -y 5 -width 93 -height 22 -anchor nw -bordermode ignore 
    place $base.lab109 \
        -x 195 -y 5 -width 171 -height 18 -anchor nw -bordermode ignore 
    place $base.lab110 \
        -x 25 -y 55 -width 16 -height 18 -anchor nw -bordermode ignore 
    place $base.lab111 \
        -x 55 -y 55 -width 36 -height 18 -anchor nw -bordermode ignore 
    place $base.lab112 \
        -x 100 -y 55 -width 36 -height 18 -anchor nw -bordermode ignore 
    place $base.lab114 \
        -x 10 -y 30 -width 101 -height 18 -anchor nw -bordermode ignore 
    place $base.ent115 \
        -x 105 -y 30 -width 178 -height 22 -anchor nw -bordermode ignore 
    place $base.lab117 \
        -x 250 -y 55 -width 61 -height 18 -anchor nw -bordermode ignore 
    place $base.lab121 \
        -x 180 -y 55 -width 16 -height 18 -anchor nw -bordermode ignore 
    place $base.ent122 \
        -x 195 -y 55 -width 53 -height 22 -anchor nw -bordermode ignore 
    place $base.lab123 \
        -x 375 -y 55 -width 16 -height 18 -anchor nw -bordermode ignore 
    place $base.ent124 \
        -x 395 -y 55 -width 53 -height 22 -anchor nw -bordermode ignore 
    place $base.lab125 \
        -x 450 -y 55 -width 61 -height 18 -anchor nw -bordermode ignore 
    place $base.but126 \
        -x 10 -y 90 -anchor nw -bordermode ignore 
    place $base.lab131 \
        -x 60 -y 90 -width 71 -height 18 -anchor nw -bordermode ignore 
    place $base.lab132 \
        -x 135 -y 90 -width 71 -height 18 -anchor nw -bordermode ignore 
    place $base.lab133 \
        -x 335 -y 55 -width 36 -height 18 -anchor nw -bordermode ignore 
    place $base.lab135 \
        -x 315 -y 55 -width 16 -height 18 -anchor nw -bordermode ignore 
    place $base.lab136 \
        -x 140 -y 55 -width 36 -height 18 -anchor nw -bordermode ignore 
    place $base.lab138 \
        -x 210 -y 90 -width 276 -height 18 -anchor nw -bordermode ignore 
    place $base.but17 \
        -x 10 -y 120 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 60 -y 120 -anchor nw -bordermode ignore 
    place $base.but19 \
        -x 125 -y 120 -anchor nw -bordermode ignore 
}

proc vTclWindow.top17 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -borderwidth 4 -relief groove 
    wm focusmodel $base passive
    wm geometry $base 302x225+7+7
    wm maxsize $base 1137 860
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "UCalc"
    entry $base.ent18 \
        -background #008404 -borderwidth 5 \
        -font $fnt2 \
        -foreground #000000 
    bind $base.ent18 <Enter> {
        place .top17.lab66 -in .top17.ent18 -relx 0.3 -rely -1.0
    }
    bind $base.ent18 <Key><Key-Return> {
        set linn [.top17.ent18 get]
        set res3 $linn
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs } res1
    }
    bind $base.ent18 <Leave> {
        place forget .top17.lab66
    }
    label $base.lab20 \
        -background #dfdb46 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text Question 
    label $base.lab21 \
        -background #dfdb46 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text Answer 
    label $base.lab69 \
        -background #dfdb34 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {you type here the name of your own unit file} 
    label $base.lab66 \
        -background #dfdb22 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {Write your question here} 
    entry $base.ent22 \
        -background #fe002a -borderwidth 4 -justify center -relief raised 
    bind $base.ent22 <ButtonRelease-1> {
        set units [.top17.ent22 get]
    }
    bind $base.ent22 <Enter> {
        place .top17.lab69 -in .top17.ent22 -relx -2.5 -rely 1.0
    }
    bind $base.ent22 <KeyRelease><Key-Return> {
        set units [.top17.ent22 get]
    }
    bind $base.ent22 <Leave> {
        place forget .top17.lab69
    }
    button $base.but32 \
        -font $fnt1 \
        -foreground #00002a -padx 9 -pady 3 -text MKS 
    bind $base.but32 <ButtonRelease-1> {
        set linn [.top17.ent18 get]
        set res3 $linn
set units mks.units
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u mks.units -q \"$linn\" -p $precs} res1
    }
    button $base.but33 \
        -font $fnt1 \
        -foreground #000000 -padx 9 -pady 3 -text CGS 
    bind $base.but33 <ButtonRelease-1> {
        set linn [.top17.ent18 get]
        set res3 $linn
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u cgs.units -q \"$linn\" -p $precs} res1
    }
    button $base.but36 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Quit 
    bind $base.but36 <Button-1> {
        exit
    }
    label $base.lab38 \
        -background #f4f4f6 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text mks.units -textvariable units 
    button $base.but17 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Clear 
    bind $base.but17 <ButtonRelease-1> {
        .top17.ent18 delete 0 [string length [.top17.ent18 get]]
    }
    label $base.cpd21 \
        -background #dfdb46 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {Units File} 
    entry $base.ent65 \
        -background #4668df -borderwidth 5 \
        -font $fnt2 \
        -textvariable res1 
    button $base.but75 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Controls 
    bind $base.but75 <ButtonRelease-1> {
        wm deiconify .top18
       wm deiconify .top20
       wm deiconify .top56
       wm deiconify .top79
       wm deiconify .top106
    }
    button $base.but18 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {Hide Controls} 
    bind $base.but18 <ButtonRelease-1> {
        wm withdraw .top18
        wm withdraw .top20
        wm withdraw .top56
        wm withdraw .top79
        wm withdraw .top106
    }
    button $base.but21 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Defs 
    bind $base.but21 <ButtonRelease-1> {
        wm deiconify .top56
    }
    button $base.but22 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Define 
    bind $base.but22 <ButtonRelease-1> {
        wm deiconify .top106
    }
    button $base.but23 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Units 
    bind $base.but23 <ButtonRelease-1> {
        wm deiconify .top20
    }
    button $base.but24 \
        -font $fnt1 -padx 9 -pady 3 \
        -text UControl 
    bind $base.but24 <ButtonRelease-1> {
        wm deiconify .top18
    }
    button $base.but25 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Prefixes 
    bind $base.but25 <ButtonRelease-1> {
        wm deiconify .top79
    }
    button $base.but20 \
        -font $fnt1 \
        -foreground #000000 -padx 9 -pady 3 -text a+i*b 
    bind $base.but20 <ButtonRelease-1> {
        set graucho "-cr"
set linn [.top17.ent18 get]
        set res3 $linn
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs } res1
    }
    button $base.but26 \
        -font $fnt1 \
        -foreground #000000 -padx 9 -pady 3 -text R*exp(i*x) 
    bind $base.but26 <ButtonRelease-1> {
        set graucho "-ce"
set linn [.top17.ent18 get]
        set res3 $linn
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs } res1
    }
    label $base.lab17 \
        -borderwidth 1 -font $fnt1 \
        -foreground #d9d9d9 -text -ce -textvariable graucho 
    button $base.but19 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Fix
    bind $base.but19 <ButtonRelease-1> {
        set sc1 -S3
        set linn [.top17.ent18 get]
        set res3 $linn
        catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs} res1
    }
    button $base.butnorm \
        -font $fnt1 -padx 9 -pady 3 \
        -text Norm
    bind $base.butnorm <ButtonRelease-1> {
        set sc1 -S1
        set linn [.top17.ent18 get]
        set res3 $linn
        catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs} res1
    }
    button $base.butres \
        -font $fnt1 -padx 9 -pady 3 \
        -text Res
    bind $base.butres <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " "
        .top17.ent18 insert [string length [.top17.ent18 get]] $res1
        .top17.ent18 insert [string length [.top17.ent18 get]] " "
    }
    button $base.butundo \
        -font $fnt1 -padx 9 -pady 3 \
        -text Undo
    bind $base.butundo <ButtonRelease-1> {
        .top17.ent18 delete 0 [string length [.top17.ent18 get]]
        .top17.ent18 insert [string length [.top17.ent18 get]] $res3
    }
    button $base.but27 \
        -font $fnt1 -padx 9 -pady 3 \
        -text  Sci
    bind $base.but27 <ButtonRelease-1> {
        set sc1 -S2
        set linn [.top17.ent18 get]
        set res3 $linn
        catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs} res1
    }
    button $base.but28 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Clear 
    bind $base.but28 <ButtonRelease-1> {
        .top17.ent18 delete 0 [string length [.top17.ent18 get]]
    }
    place $base.ent18 \
        -x 5 -y 20 -width 224 -height 43 -anchor nw -bordermode ignore 
    place $base.lab20 \
        -x 20 -y 5 -width 101 -height 18 -anchor nw -bordermode ignore 
    place $base.lab21 \
        -x 15 -y 90 -width 96 -height 18 -anchor nw -bordermode ignore 
    place $base.ent22 \
        -x 155 -y 60 -width 73 -height 32 -anchor nw -bordermode ignore 
    place $base.but32 \
        -x 85 -y 60 -width 73 -height 26 -anchor nw -bordermode ignore 
    place $base.but33 \
        -x 10 -y 60 -width 73 -height 26 -anchor nw -bordermode ignore 
    place $base.but36 \
        -x 200 -y 195 -width 94 -height 26 -anchor nw -bordermode ignore 
    place $base.lab38 \
        -x 100 -y 140 -width 101 -height 18 -anchor nw -bordermode ignore 
    place $base.but17 \
        -x 170 -y 165 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd21 \
        -x 20 -y 140 -width 84 -height 18 -anchor nw -bordermode ignore 
    place $base.ent65 \
        -x 5 -y 105 -width 288 -height 32 -anchor nw -bordermode ignore 
    place $base.but75 \
        -x 5 -y 155 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 65 -y 155 -width 105 -height 26 -anchor nw -bordermode ignore 
    place $base.but21 \
        -x 230 -y 5 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but22 \
        -x 235 -y 165 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but23 \
        -x 230 -y 30 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but24 \
        -x 230 -y 80 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 230 -y 55 -width 62 -height 26 -anchor nw -bordermode ignore 
    place $base.but20 \
        -x 3 -y 185 -width 70 -height 26 -anchor nw -bordermode ignore 
    place $base.but26 \
        -x 72 -y 185 -width 70 -height 26 -anchor nw -bordermode ignore 
    place $base.lab17 \
        -x 170 -y 200 -width 26 -height 18 -anchor nw -bordermode ignore 
    place $base.but19 \
        -x 200 -y 140 -width 32 -height 26 -anchor nw -bordermode ignore 
    place $base.but27 \
        -x 230 -y 140 -width 32 -height 26 -anchor nw -bordermode ignore 
    place $base.butnorm \
        -x 260 -y 140 -width 32 -height 26 -anchor nw -bordermode ignore 
    place $base.butres \
        -x 170 -y 190 -width 32 -height 32 -anchor nw -bordermode ignore 
    place $base.butundo \
        -x 140 -y 190 -width 32 -height 32 -anchor nw -bordermode ignore 
    place $base.but28 \
        -x 125 -y 5 -width 97 -height 16 -anchor nw -bordermode ignore 
}

proc vTclWindow.top18 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top18
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -background #0000f8 -borderwidth 4 -relief sunken 
    wm focusmodel $base passive
    wm geometry $base 440x393+396+49
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm deiconify $base
    wm title $base "UControl"
    canvas $base.can21 \
        -background #009000 -borderwidth 4 -height 207 -relief sunken \
        -width 295 
    bind $base.can21 <Enter> {
        set message1 "You can also use the keyboard"
    }
    button $base.but22 \
        -borderwidth 4 -font $fnt1 \
        -padx 9 -pady 3 -text {Calculate MKS} 
    bind $base.but22 <ButtonRelease-1> {
        set linn [.top17.ent18 get]
        set res3 $linn
set units mks.units
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u mks.units -q \"$linn\" -p $precs } res1
    }
    button $base.but23 \
        -borderwidth 4 -font $fnt1 \
        -padx 9 -pady 3 -text {Calculate CGS} 
    bind $base.but23 <ButtonRelease-1> {
        set linn [.top17.ent18 get]
        set res3 $linn
set units mks.units
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u cgs.units -q \"$linn\" -p $precs } res1
    }
    entry $base.ent79 \
        -background #df0c06 -borderwidth 4 -relief raised 
    bind $base.ent79 <ButtonRelease-1> {
        set units [.top18.ent79 get]
    }
    bind $base.ent79 <Enter> {
        set message1 "You can use your own units file"
    }
    bind $base.ent79 <KeyRelease><Key-Return> {
        set units [.top18.ent79 get]
    }
    button $base.but82 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 7 
    bind $base.but82 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 7
    }
    button $base.but83 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 8 
    bind $base.but83 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 8
    }
    button $base.but84 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 9 
    bind $base.but84 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 9
    }
    button $base.but85 \
        -font $fnt1 -padx 9 -pady 3 \
        -text * 
    bind $base.but85 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] *
    }
    button $base.but86 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 4 
    bind $base.but86 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 4
    }
    button $base.but87 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 5 
    bind $base.but87 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 5
    }
    button $base.but88 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 6 
    bind $base.but88 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 6
    }
    button $base.but89 \
        -font $fnt1 -padx 9 -pady 3 \
        -text / 
    bind $base.but89 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] /
    }
    button $base.but90 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 1 
    bind $base.but90 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 1
    }
    button $base.but91 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 2 
    bind $base.but91 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 2
    }
    button $base.but92 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 3 
    bind $base.but92 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 3
    }
    button $base.but94 \
        -font $fnt1 -padx 8 -pady 3 \
        -text - 
    bind $base.but94 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] -
    }
    button $base.but95 \
        -font $fnt1 -padx 9 -pady 3 \
        -text . 
    bind $base.but95 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] .
    }
    button $base.but96 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 0 
    bind $base.but96 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] 0
    }
    button $base.but97 \
        -font $fnt1 -padx 9 -pady 3 \
        -text = 
    bind $base.but97 <ButtonRelease-1> {
        set linn [.top17.ent18 get]
        set res3 $linn
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs} res1
    }
    button $base.but98 \
        -font $fnt1 -padx 9 -pady 3 \
        -text + 
    bind $base.but98 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] +
    }
    button $base.but17 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Meter 
    bind $base.but17 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Meter "
    }
    button $base.but19 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Second 
    bind $base.but19 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Sec "
    }
    button $base.but20 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text mol 
    bind $base.but20 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Mol "
    }
    button $base.but21 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Coulomb 
    bind $base.but21 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Coulomb "
    }
    button $base.but24 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text k 
    bind $base.but24 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Deg "
    }
    button $base.but28 \
        -background #929292 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Kg 
    bind $base.but28 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Kg "
    }
    button $base.but31 \
        -background #36ac1a \
        -font $fnt1 -padx 9 -pady 3 \
        -text c 
    bind $base.but31 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Dc "
    }
    button $base.butcomm \
        -font $fnt1 -padx 9 -pady 3 \
        -text ","
    bind $base.butcomm <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " , "
    }
    button $base.but18 \
        -font $fnt1 -padx 9 -pady 3 \
        -text ( 
    bind $base.but18 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] (
    }
    button $base.but25 \
        -font $fnt1 -padx 9 -pady 3 \
        -text ) 
    bind $base.but25 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] )
    }
    canvas $base.can54 \
        -background #00ac00 -borderwidth 4 -height 207 -relief sunken \
        -width 295 
    bind $base.can54 <Enter> {
        set message1 "4 memory cells you can use"
    }
    button $base.but61 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Clear 
    bind $base.but61 <ButtonRelease-1> {
        .top17.ent18 delete 0 [string length [.top17.ent18 get]]
    }
    button $base.but62 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M1-in 
    bind $base.but62 <ButtonRelease-1> {
        set mem1 [.top17.ent18 get]
    }
    button $base.but63 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M1-out 
    bind $base.but63 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] (
.top17.ent18 insert [string length [.top17.ent18 get]] $mem1
.top17.ent18 insert [string length [.top17.ent18 get]] )
    }
    button $base.but64 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M3-in 
    bind $base.but64 <ButtonRelease-1> {
        set mem3 [.top17.ent18 get]
    }
    button $base.but65 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M3-out 
    bind $base.but65 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] (
.top17.ent18 insert [string length [.top17.ent18 get]] $mem3
.top17.ent18 insert [string length [.top17.ent18 get]] )
    }
    button $base.but66 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M2-in 
    bind $base.but66 <ButtonRelease-1> {
        set mem2 [.top17.ent18 get]
    }
    button $base.but67 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M2-out 
    bind $base.but67 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] (
.top17.ent18 insert [string length [.top17.ent18 get]] $mem2
.top17.ent18 insert [string length [.top17.ent18 get]] )
    }
    button $base.but68 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M4-in 
    bind $base.but68 <ButtonRelease-1> {
        set mem4 [.top17.ent18 get]
    }
    button $base.but69 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M4-out 
    bind $base.but69 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] (
.top17.ent18 insert [string length [.top17.ent18 get]] $mem4
.top17.ent18 insert [string length [.top17.ent18 get]] )
    }
    button $base.but70 \
        -font $fnt1 -padx 9 -pady 3 \
        -text PI=3.14... 
    bind $base.but70 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 3.14159265359 "
    }
    button $base.but71 \
        -font $fnt1 -padx 9 -pady 3 \
        -text e=2.71... 
    bind $base.but71 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 2.71828182846 "
    }
    label $base.lab72 \
        -background #dfdb46 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {Formula file} 
    entry $base.ent73 \
        -background #8edbdf -borderwidth 4 -highlightbackground #8cdbdf 
    bind $base.ent73 <Enter> {
        set message1 "You can use your own formula file"
    }
    bind $base.ent73 <KeyRelease><Key-Return> {
        set formula
    }
    label $base.lab74 \
        -background #f0eef4 -borderwidth 1 \
        -font $fnt1 -relief sunken \
        -text general.formula -textvariable formula 
    button $base.but76 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hide 
    bind $base.but76 <ButtonRelease-1> {
        wm withdraw .top18
    }
    bind $base.but76 <Enter> {
        set message1 "Hide this control panel"
    }
    canvas $base.can77 \
        -background #785418 -borderwidth 2 -height 207 -relief sunken \
        -width 355 
    button $base.but78 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {log10 x} 
    bind $base.but78 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " lg10 "
    }
    bind $base.but78 <Enter> {
        set message1 "lg10 100 =2"
    }
    button $base.butabs \
        -font $fnt1 -padx 9 -pady 3 \
        -text {abs x} 
    bind $base.butabs <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " abs "
    }
    bind $base.butabs <Enter> {
        set message1 "Absolute value"
    }
    button $base.butre \
        -font $fnt1 -padx 9 -pady 3 \
        -text {Re x} 
    bind $base.butre <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Re "
    }
    bind $base.butre <Enter> {
        set message1 "Real part of x"
    }
    button $base.butim \
        -font $fnt1 -padx 9 -pady 3 \
        -text {Im x} 
    bind $base.butim <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Im "
    }
    bind $base.butim <Enter> {
        set message1 "Imaginary part of x"
    }
    button $base.butconj \
        -font $fnt1 -padx 9 -pady 3 \
        -text {conj x} 
    bind $base.butconj <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " conj "
    }
    bind $base.butconj <Enter> {
        set message1 "Complex conjegated of x"
    }
    button $base.butphs \
        -font $fnt1 -padx 9 -pady 3 \
        -text {phase x} 
    bind $base.butphs <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " phase "
    }
    bind $base.butphs <Enter> {
        set message1 "Phase of x"
    }
    button $base.but79 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {cos x} 
    bind $base.but79 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " cos "
    }
    bind $base.but79 <Enter> {
        set message1 "cos x"
    }
    button $base.but80 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {tan x} 
    bind $base.but80 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " tan "
    }
    bind $base.but80 <Enter> {
        set message1 "tangent of x"
    }
    button $base.but81 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {asin x} 
    bind $base.but81 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " asin "
    }
    bind $base.but81 <Enter> {
        set message1 "arcsin x"
    }
    button $base.but93 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {acos x} 
    bind $base.but93 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " acos "
    }
    bind $base.but93 <Enter> {
        set message1 "arccos x"
    }
    button $base.but99 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {atan x} 
    bind $base.but99 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " atan "
    }
    bind $base.but99 <Enter> {
        set message1 "atan x = arctan x"
    }
    button $base.but100 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {sqrt x} 
    bind $base.but100 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " sqrt "
    }
    bind $base.but100 <Enter> {
        set message1 "sqrt 9 =3"
    }
    button $base.but101 \
        -font $fnt1 -padx 9 -pady 3 \
        -text x^Y 
    bind $base.but101 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " ^ "
    }
    bind $base.but101 <Enter> {
        set message1 "2^4=16"
    }
    button $base.but102 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {exp x} 
    bind $base.but102 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " exp "
    }
    bind $base.but102 <Enter> {
        set message1 "exp 3 =2.71...^3"
    }
    button $base.but103 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {log x Y} 
    bind $base.but103 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " log "
    }
    bind $base.but103 <Enter> {
        set message1 "log 4 16 =2"
    }
    button $base.but104 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {ln x} 
    bind $base.but104 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " ln "
    }
    bind $base.but104 <Enter> {
        set message1 "ln (e^3) =3"
    }
    button $base.but110 \
        -font $fnt1 -padx 9 -pady 3 \
        -text x! 
    bind $base.but110 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " ! "
    }
    bind $base.but110 <Enter> {
        set message1 "5!=1*2*3*4*5=120"
    }
    button $base.but111 \
        -font $fnt1 -padx 9 -pady 3 \
        -text "x Root of y "
    bind $base.but111 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " root "
    }
    bind $base.but111 <Enter> {
        set message1 "3 root 8 =2"
    }
    button $base.but112 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {sin x} 
    bind $base.but112 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " sin "
    }
    bind $base.but112 <Enter> {
        set message1 "sin x"
    }
    canvas $base.can113 \
        -background #3adbdf -borderwidth 3 -height 207 -relief sunken \
        -width 295 
    bind $base.can113 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " R "
    }
    label $base.lab129 \
        -background #dff020 -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {You can use your own formula file} -textvariable message1 
    button $base.but137 \
        -font $fnt1 -padx 9 -pady 3 \
        -text R 
    bind $base.but137 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " R "
    }
    bind $base.but137 <Enter> {
        set message1 "Gas Constant"
    }
    button $base.but140 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Kb 
    bind $base.but140 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Kb "
    }
    bind $base.but140 <Enter> {
        set message1 "Bolzman's constant"
    }
    button $base.but141 \
        -font $fnt1 -padx 9 -pady 3 \
        -text h 
    bind $base.but141 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " H "
    }
    bind $base.but141 <Enter> {
        set message1 "Planck's constant"
    }
    button $base.but142 \
        -font $fnt1 -padx 9 -pady 3 \
        -text e 
    bind $base.but142 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 1.602307e-19 Coulomb "
    }
    bind $base.but142 <Enter> {
        set message1 "Elementry Charge (absolute value)"
    }
    button $base.but143 \
        -font $fnt1 -padx 9 -pady 3 \
        -text g 
    bind $base.but143 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 9.807 M * (1 Sec^-2) "
    }
    bind $base.but143 <Enter> {
        set message1 "Standard acceleration of gravity"
    }
    button $base.but144 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Na 
    bind $base.but144 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Na "
    }
    bind $base.but144 <Enter> {
        set message1 "Avogadro's constant"
    }
    button $base.but145 \
        -font $fnt1 -padx 9 -pady 3 \
        -text C 
    bind $base.but145 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cl "
    }
    bind $base.but145 <Enter> {
        set message1 "Speed of light in vacuum"
    }
    button $base.but146 \
        -font $fnt1 -padx 9 -pady 3 \
        -text E0 
    bind $base.but146 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 8.854*(1 M^-3)*(1 Kg^-1)*(1 Sec^2)*(1 Coulomb^2) "
    }
    bind $base.but146 <Enter> {
        set message1 "Epsillon 0 - permittivity of vacuum"
    }
    button $base.but147 \
        -font $fnt1 -padx 9 -pady 3 \
        -text F 
    bind $base.but147 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 9.648E4 Coulomb * (1 Mol^-1) "
    }
    bind $base.but147 <Enter> {
        set message1 "Farraday's constant"
    }
    button $base.but148 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 2P 
    bind $base.but148 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 6.28318530718 "
    }
    bind $base.but148 <Enter> {
        set message1 "2Pi"
    }
    button $base.but149 \
        -font $fnt1 -padx 9 -pady 3 \
        -text me 
    bind $base.but149 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 9.107468e-31 Kg "
    }
    bind $base.but149 <Enter> {
        set message1 "Rest mass of an electron"
    }
    button $base.but150 \
        -font $fnt1 -padx 9 -pady 3 \
        -text a0 
    bind $base.but150 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " 5.292e-11 Meter "
    }
    bind $base.but150 <Enter> {
        set message1 "Bohr's Radius"
    }
    label $base.lab19 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text Precsision 
    button $base.but45 \
        -font $fnt1 -padx 9 -pady 3 \
        -text units 
    bind $base.but45 <ButtonRelease-1> {
        wm deiconify .top20
    }
    button $base.but72 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Conf 
    bind $base.but72 <ButtonRelease-1> {
        wm deiconify .top56
    }
    button $base.but26 \
        -font $fnt1 -padx 9 -pady 3 \
        -text  
    bind $base.but26 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Dg "
    }
    bind $base.but26 <Enter> {
        set message1 "Converts to Degrees Radians are default "
    }
    button $base.but36 \
        -font $fnt1 -padx 9 -pady 3 \
        -text 1/x 
    bind $base.but36 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " ^-1 "
    }
    bind $base.but36 <Enter> {
        set message1 "2 (1/x) = 0.5"
    }
    button $base.but27 \
        -font $fnt1 -padx 9 -pady 3 \
        -text E 
    bind $base.but27 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] "e"
    }
    button $base.but105 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Prefixes 
    bind $base.but105 <ButtonRelease-1> {
        wm deiconify .top79
    }
    button $base.but29 \
        -font $fnt1 -padx 9 -pady 3 \
        -text i 
    bind $base.but29 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] i
    }
    bind $base.but29 <Enter> {
        set message1 "i = (-1)^0.5 "
    }
    label $base.lab17 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text 9 -textvariable precs 
    button $base.but30 \
        -font $fnt1 -padx 9 -pady 3 \
        -text > 
    bind $base.but30 <ButtonRelease-1> {
        set precs [expr $precs + 1]
    }
    button $base.but32 \
        -font $fnt1 -padx 9 -pady 3 \
        -text < 
    bind $base.but32 <ButtonRelease-1> {
        set precs [expr $precs - 1]
    }
    place $base.can21 \
        -x 15 -y 0 -width 106 -height 168 -anchor nw -bordermode ignore 
    place $base.but22 \
        -x 120 -y 145 -width 112 -height 32 -anchor nw -bordermode ignore 
    place $base.but23 \
        -x 120 -y 175 -width 112 -height 32 -anchor nw -bordermode ignore 
    place $base.ent79 \
        -x 120 -y 205 -width 112 -height 32 -anchor nw -bordermode ignore 
    place $base.but82 \
        -x 30 -y 10 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but83 \
        -x 50 -y 10 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but84 \
        -x 70 -y 10 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but85 \
        -x 90 -y 10 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but86 \
        -x 30 -y 40 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but87 \
        -x 50 -y 40 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but88 \
        -x 70 -y 40 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but89 \
        -x 90 -y 40 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but90 \
        -x 30 -y 70 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but91 \
        -x 50 -y 70 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but92 \
        -x 70 -y 70 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but94 \
        -x 90 -y 70 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but95 \
        -x 30 -y 100 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but96 \
        -x 50 -y 100 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but97 \
        -x 70 -y 100 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but98 \
        -x 90 -y 100 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but17 \
        -x 125 -y 10 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but19 \
        -x 125 -y 70 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but20 \
        -x 180 -y 70 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but21 \
        -x 180 -y 10 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but24 \
        -x 180 -y 40 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but28 \
        -x 125 -y 40 -width 50 -height 30 -anchor nw -bordermode ignore 
    place $base.but31 \
        -x 145 -y 110 -width 25 -height 30 -anchor nw -bordermode ignore 
    place $base.butcomm \
        -x 120 -y 110 -width 25 -height 30 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 30 -y 130 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 50 -y 130 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.can54 \
        -x 6 -y 170 -width 106 -height 138 -anchor nw -bordermode ignore 
    place $base.but61 \
        -x 190 -y 110 -width 37 -height 30 -anchor nw -bordermode ignore 
    place $base.but62 \
        -x 11 -y 180 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but63 \
        -x 60 -y 180 -width 46 -height 30 -anchor nw -bordermode ignore 
    place $base.but64 \
        -x 11 -y 240 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but65 \
        -x 59 -y 240 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but66 \
        -x 11 -y 210 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but67 \
        -x 59 -y 210 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but68 \
        -x 11 -y 270 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but69 \
        -x 59 -y 270 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but70 \
        -x 170 -y 240 -width 60 -height 30 -anchor nw -bordermode ignore 
    place $base.but71 \
        -x 170 -y 270 -width 60 -height 30 -anchor nw -bordermode ignore 
    place $base.lab72 \
        -x 10 -y 320 -anchor nw -bordermode ignore 
    place $base.ent73 \
        -x 10 -y 335 -width 148 -height 27 -anchor nw -bordermode ignore 
    place $base.lab74 \
        -x 10 -y 360 -width 146 -height 18 -anchor nw -bordermode ignore 
    place $base.but76 \
        -x 175 -y 305 -width 47 -height 38 -anchor nw -bordermode ignore 
    place $base.can77 \
        -x 237 -y 150 -width 200 -height 171 -anchor nw -bordermode ignore 
    place $base.but78 \
        -x 290 -y 190 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but79 \
        -x 245 -y 280 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but80 \
        -x 290 -y 280 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but81 \
        -x 245 -y 250 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but93 \
        -x 335 -y 250 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.butabs \
        -x 382 -y 160 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.butre \
        -x 382 -y 190 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.butim \
        -x 382 -y 220 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.butphs \
        -x 382 -y 250 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.butconj \
        -x 382 -y 280 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but99 \
        -x 290 -y 250 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but100 \
        -x 290 -y 220 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but101 \
        -x 245 -y 220 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but102 \
        -x 245 -y 160 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but103 \
        -x 335 -y 190 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but104 \
        -x 245 -y 190 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but110 \
        -x 290 -y 160 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but111 \
        -x 335 -y 220 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but112 \
        -x 335 -y 280 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.can113 \
        -x 240 -y 5 -width 157 -height 136 -anchor nw -bordermode ignore 
    place $base.lab129 \
        -x 160 -y 350 -width 237 -height 30 -anchor nw -bordermode ignore 
    place $base.but137 \
        -x 295 -y 70 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but140 \
        -x 295 -y 40 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but141 \
        -x 250 -y 40 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but142 \
        -x 340 -y 70 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but143 \
        -x 295 -y 10 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but144 \
        -x 295 -y 100 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but145 \
        -x 250 -y 100 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but146 \
        -x 250 -y 70 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but147 \
        -x 340 -y 100 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but148 \
        -x 340 -y 40 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but149 \
        -x 250 -y 10 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but150 \
        -x 340 -y 10 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.lab19 \
        -x 235 -y 325 -width 61 -height 20 -anchor nw -bordermode ignore 
    place $base.but45 \
        -x 120 -y 270 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but72 \
        -x 120 -y 240 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but26 \
        -x 170 -y 110 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but36 \
        -x 335 -y 160 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but27 \
        -x 70 -y 130 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.but105 \
        -x 120 -y 300 -width 47 -height 30 -anchor nw -bordermode ignore 
    place $base.but29 \
        -x 90 -y 130 -width 22 -height 30 -anchor nw -bordermode ignore 
    place $base.lab17 \
        -x 315 -y 325 -width 61 -height 20 -anchor nw -bordermode ignore 
    place $base.but30 \
        -x 375 -y 325 -width 22 -height 20 -anchor nw -bordermode ignore 
    place $base.but32 \
        -x 295 -y 325 -width 22 -height 20 -anchor nw -bordermode ignore 
}

proc vTclWindow.top19 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top19
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -background #dfdb22 
    wm focusmodel $base active
    wm geometry $base 436x456+0+264
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Message"
    label $base.lab21 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {and program updates} 
    label $base.lab22 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {You will get an improved set of units} 
    label $base.lab23 \
        -background #df22df -borderwidth 1 \
        -font $fnt2 -relief raised \
        -text {2 Giv'at beit hakerem st. Jerusalem ISRAEL} 
    label $base.lab24 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {Ortal Alpert} 
    label $base.lab25 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {and another utility} 
    label $base.lab26 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {If you want to use it after this time} 
    label $base.lab27 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {Usage licence} 
    label $base.lab28 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {This program comes with 45 Days} 
    label $base.lab29 \
        -background #df22df -borderwidth 1 \
        -font $fnt2 -relief raised \
        -text {Bug reports -> ortal@batata.fh.huji.ac.il} 
    label $base.lab20 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {that will help you define more units} 
    label $base.lab30 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {To register you have to send 10US$ to:} 
    label $base.lab31 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {You have to be a registered user} 
    label $base.lab17 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {and get your copy for free} 
    label $base.lab18 \
        -background #df22df -borderwidth 1 \
        -font $fnt3 -relief raised \
        -text {Or , have 3 other people register} 
    place $base.lab21 \
        -x 30 -y 255 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab22 \
        -x 30 -y 225 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab23 \
        -x 30 -y 195 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab24 \
        -x 30 -y 165 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab25 \
        -x 30 -y 285 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab26 \
        -x 30 -y 75 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab27 \
        -x 30 -y 45 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab28 \
        -x 30 -y 15 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab29 \
        -x 30 -y 405 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab20 \
        -x 30 -y 315 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab30 \
        -x 30 -y 135 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab31 \
        -x 30 -y 105 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab17 \
        -x 30 -y 375 -width 376 -height 28 -anchor nw -bordermode ignore 
    place $base.lab18 \
        -x 30 -y 345 -width 376 -height 28 -anchor nw -bordermode ignore 
}

proc vTclWindow.top20 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top20
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -background #383cdf -borderwidth 3 -relief groove 
    wm focusmodel $base passive
    wm geometry $base 236x416+412+16
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "More Units"
    button $base.but23 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Horsepower 
    bind $base.but23 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Horsepower "
    }
    button $base.but24 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Kcal 
    bind $base.but24 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Kcal "
    }
    button $base.but25 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Cm^-1 
    bind $base.but25 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cm1 "
    }
    button $base.but26 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Calorie 
    bind $base.but26 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cal "
    }
    button $base.but27 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Ev 
    bind $base.but27 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Ev "
    }
    button $base.but28 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hartree 
    bind $base.but28 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Hartree "
    }
    button $base.but29 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Erg 
    bind $base.but29 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Erg "
    }
    button $base.but30 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Liter 
    bind $base.but30 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Liter "
    }
    button $base.but31 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Angstrom 
    bind $base.but31 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " A0 "
    }
    button $base.but32 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Inch 
    bind $base.but32 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Inch "
    }
    button $base.but33 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Ohm 
    bind $base.but33 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Ohm "
    }
    button $base.but34 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Volt 
    bind $base.but34 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Volt "
    }
    button $base.but35 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Amper 
    bind $base.but35 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Amper "
    }
    button $base.butob \
        -font $fnt1 -padx 9 -pady 3 \
        -text \173
    bind $base.butob <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " \173 "
    }
    button $base.butcb \
        -font $fnt1 -padx 9 -pady 3 \
        -text \175
    bind $base.butcb <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " \175 "
    }
    button $base.but36 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Watt 
    bind $base.but36 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Watt "
    }
    button $base.but37 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Joule 
    bind $base.but37 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Joule "
    }
    button $base.but38 \
        -font $fnt1 -padx 9 -pady 3 \
        -text {M Cube} 
    bind $base.but38 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] "*1M^3 "
    }
    button $base.but39 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Newton 
    bind $base.but39 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " *((1 Meter Kg)*(1 Sec^-2)) "
    }
    button $base.but40 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Torr 
    bind $base.but40 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Torr "
    }
    button $base.but41 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Bar 
    bind $base.but41 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Bar "
    }
    button $base.but42 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Dyn 
    bind $base.but42 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Dyn "
    }
    button $base.but43 \
        -font $fnt1 -padx 9 -pady 3 \
        -text CC 
    bind $base.but43 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cc "
    }
    button $base.but44 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hide 
    bind $base.but44 <ButtonRelease-1> {
        wm withdraw .top20
    }
    button $base.but47 \
        -background #020202 \
        -font $fnt1 \
        -foreground #ec0000 -padx 9 -pady 3 -text {Convert to ...} 
    bind $base.but47 <ButtonRelease-1> {
        set conv1 [.top17.ent18 get]
.top17.ent18 delete 0 [string length [.top17.ent18 get]]
    place .top20.but48 \
        -x 10 -y 380 -width 112 -height 32 -anchor nw -bordermode ignore 
        .top20.but48 flash
    }
    button $base.but48 \
        -background #020202 \
        -font $fnt1 \
        -foreground #ec0000 -padx 9 -pady 3 -relief sunken -text Calculate 
    bind $base.but48 <ButtonRelease-1> {
place forget .top20.but48
        set conv2 [.top17.ent18 get]
.top17.ent18 delete 0 [string length [.top17.ent18 get]]
.top17.ent18 insert [string length [.top17.ent18 get]] " ("
.top17.ent18 insert [string length [.top17.ent18 get]] $conv1
.top17.ent18 insert [string length [.top17.ent18 get]] " - 0 "
.top17.ent18 insert [string length [.top17.ent18 get]] $conv2
.top17.ent18 insert [string length [.top17.ent18 get]] " )/(1  "
.top17.ent18 insert [string length [.top17.ent18 get]] $conv2

.top17.ent18 insert [string length [.top17.ent18 get]] " -0 "
.top17.ent18 insert [string length [.top17.ent18 get]] $conv2
.top17.ent18 insert [string length [.top17.ent18 get]] ") "
set linn [.top17.ent18 get]
catch {eval exec ./mc66 $sc1 $graucho -f $formula -u $units -q \"$linn\" -p $precs } res1
.top17.ent65 insert [string length [.top17.ent65 get]] $conv2
.top17.ent18 delete 0 [string length [.top17.ent18 get]]
.top17.ent18 insert [string length [.top17.ent18 get]] $conv1
    }
    label $base.lab52 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text {To conver units} 
    label $base.lab53 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text {press "Convert to ..."} 
    label $base.lab54 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text {Choose your unit} 
    label $base.lab55 \
        -borderwidth 1 -font $fnt1 \
        -relief raised -text {and press Calculate} 
    button $base.but17 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Degree 
    bind $base.but17 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Dg "
    }
    button $base.but18 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Grad 
    bind $base.but18 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Grad "
    }
    button $base.but49 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Degree 
    button $base.but50 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Cm 
    bind $base.but50 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cm "
    }
    frame $base.cpd32 \
        -borderwidth 1 -height 30 -relief raised -width 30 
    button $base.cpd32.but34 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hour 
    bind $base.cpd32.but34 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Hour "
    }
    button $base.cpd32.but38 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Micron 
    bind $base.cpd32.but38 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Micron "
    }
    button $base.cpd32.but39 \
        -font $fnt1 -padx 9 -pady 3 \
        -text KJ 
    bind $base.cpd32.but39 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " KJoule "
    }
    button $base.cpd32.but40 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Psec 
    bind $base.cpd32.but40 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Ps "
    }
    button $base.cpd32.but41 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Year 
    bind $base.cpd32.but41 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Year "
    }
    button $base.cpd32.but42 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Week 
    bind $base.cpd32.but42 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Week "
    }
    button $base.cpd32.but43 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Day 
    bind $base.cpd32.but43 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Day "
    }
    button $base.cpd32.but44 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Amu 
    bind $base.cpd32.but44 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Amu "
    }
    button $base.cpd32.but45 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Pound 
    bind $base.cpd32.but45 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Pound "
    }
    button $base.cpd32.but46 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Pascal 
    bind $base.cpd32.but46 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Pascal "
    }
    button $base.cpd32.but47 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Minute 
    bind $base.cpd32.but47 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Minute "
    }
    button $base.cpd32.but48 \
        -font $fnt1 -padx 9 -pady 3 \
        -text M/Sec 
    bind $base.cpd32.but48 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Mps "
    }
    button $base.cpd32.but17 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Km/H 
    bind $base.cpd32.but17 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Kmph "
    }
    button $base.cpd32.but18 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Cm/s 
    bind $base.cpd32.but18 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Cmps "
    }
    button $base.cpd32.but19 \
        -font $fnt1 -padx 9 -pady 3 \
        -text f 
    bind $base.cpd32.but19 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Df "
    }
    button $base.but52 \
        -font $fnt1 -padx 9 -pady 3 \
        -text More 
    bind $base.but52 <ButtonRelease-1> {
        place .top20.cpd32  -x 40 -y 280 -width 163 -height 136 -anchor nw -bordermode ignore
    }
    button $base.but53 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Less 
    bind $base.but53 <ButtonRelease-1> {
        place forget .top20.cpd32
    }
    place $base.but23 \
        -x 85 -y 10 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but24 \
        -x 10 -y 70 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 10 -y 190 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but26 \
        -x 10 -y 100 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but27 \
        -x 10 -y 160 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but28 \
        -x 10 -y 130 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but29 \
        -x 10 -y 40 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but30 \
        -x 160 -y 170 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but31 \
        -x 85 -y 105 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but32 \
        -x 85 -y 75 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but33 \
        -x 160 -y 295 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but34 \
        -x 160 -y 265 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but35 \
        -x 160 -y 235 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.butob \
        -x 110 -y 235 -width 26 -height 30 -anchor nw -bordermode ignore 
    place $base.butcb \
        -x 136 -y 235 -width 26 -height 30 -anchor nw -bordermode ignore 
    place $base.but36 \
        -x 85 -y 40 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but37 \
        -x 10 -y 10 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but38 \
        -x 160 -y 140 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but39 \
        -x 160 -y 10 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but40 \
        -x 85 -y 170 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but41 \
        -x 85 -y 200 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but42 \
        -x 160 -y 40 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but43 \
        -x 160 -y 200 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but44 \
        -x 180 -y 360 -width 49 -height 38 -anchor nw -bordermode ignore 
    place $base.but47 \
        -x 10 -y 345 -width 112 -height 32 -anchor nw -bordermode ignore 
    place $base.lab52 \
        -x 10 -y 265 -width 136 -height 20 -anchor nw -bordermode ignore 
    place $base.lab53 \
        -x 10 -y 285 -width 136 -height 20 -anchor nw -bordermode ignore 
    place $base.lab54 \
        -x 10 -y 305 -width 136 -height 20 -anchor nw -bordermode ignore 
    place $base.lab55 \
        -x 10 -y 325 -width 136 -height 20 -anchor nw -bordermode ignore 
    place $base.but17 \
        -x 160 -y 75 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 160 -y 105 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but49 \
        -x 160 -y 75 -width 62 -height 30 -anchor nw -bordermode ignore 
    place $base.but50 \
        -x 85 -y 135 -width 62 -height 31 -anchor nw -bordermode ignore 
    place $base.cpd32.but34 \
        -x 5 -y 5 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but38 \
        -x 55 -y 80 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but39 \
        -x 5 -y 80 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but40 \
        -x 55 -y 30 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but41 \
        -x 55 -y 5 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but42 \
        -x 105 -y 5 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but43 \
        -x 105 -y 30 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but44 \
        -x 55 -y 55 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but45 \
        -x 5 -y 55 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but46 \
        -x 105 -y 55 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but47 \
        -x 5 -y 30 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but48 \
        -x 105 -y 80 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but17 \
        -x 5 -y 105 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but18 \
        -x 55 -y 105 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.cpd32.but19 \
        -x 105 -y 105 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.but52 \
        -x 3 -y 235 -width 52 -height 26 -anchor nw -bordermode ignore 
    place $base.but53 \
        -x 55 -y 235 -width 52 -height 26 -anchor nw -bordermode ignore 
}

proc vTclWindow.top56 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top56
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -background #261e76 
    wm focusmodel $base passive
    wm geometry $base 178x282+429+79
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Your defs"
    canvas $base.can57 \
        -background #7a363a -borderwidth 4 -height 207 -relief raised \
        -width 295 
    entry $base.ent58 \
        -background #2ed21c 
    bind $base.ent58 <ButtonRelease-3> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent58 get]
    }
    bind $base.ent58 <KeyRelease><Key-Return> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent58 get]
    }
    entry $base.ent59 \
        -background #2ed21c 
    bind $base.ent59 <ButtonRelease-3> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent59 get]
    }
    bind $base.ent59 <KeyRelease><Key-Return> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent59 get]
    }
    entry $base.ent60 \
        -background #2ed21c 
    bind $base.ent60 <ButtonRelease-3> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent60 get]
    }
    bind $base.ent60 <KeyRelease><Key-Return> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent60 get]
    }
    entry $base.ent61 \
        -background #2ed21c 
    bind $base.ent61 <ButtonRelease-3> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent61 get]
    }
    bind $base.ent61 <KeyRelease><Key-Return> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent61 get]
    }
    entry $base.ent62 \
        -background #2ed21c 
    bind $base.ent62 <ButtonRelease-3> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent62 get]
    }
    bind $base.ent62 <KeyRelease><Key-Return> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent62 get]
    }
    label $base.lab63 \
        -background #dfdb3e -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {Configureable buttons} 
    button $base.but64 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hide 
    bind $base.but64 <ButtonRelease-1> {
        wm withdraw .top56
    }
    label $base.lab65 \
        -background #b41c1c -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {Press Enter or R mouse} 
    label $base.lab66 \
        -background #b41c1c -borderwidth 1 \
        -font $fnt1 -relief raised \
        -text {to use.} 
    button $base.but52 \
        -font $fnt1 -padx 9 -pady 3 \
        -text --> 
    bind $base.but52 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent58 get]
    }
    button $base.but53 \
        -font $fnt1 -padx 9 -pady 3 \
        -text --> 
    bind $base.but53 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent59 get]
    }
    button $base.but54 \
        -font $fnt1 -padx 9 -pady 3 \
        -text --> 
    bind $base.but54 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent60 get]
    }
    button $base.but55 \
        -font $fnt1 -padx 9 -pady 3 \
        -text --> 
    bind $base.but55 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent61 get]
    }
    button $base.but56 \
        -font $fnt1 -padx 9 -pady 3 \
        -text --> 
    bind $base.but56 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] [.top56.ent62 get]
    }
    place $base.can57 \
        -x 10 -y 35 -width 161 -height 168 -anchor nw -bordermode ignore 
    place $base.ent58 \
        -x 20 -y 45 -width 98 -height 30 -anchor nw -bordermode ignore 
    place $base.ent59 \
        -x 20 -y 165 -width 98 -height 30 -anchor nw -bordermode ignore 
    place $base.ent60 \
        -x 20 -y 135 -width 98 -height 30 -anchor nw -bordermode ignore 
    place $base.ent61 \
        -x 20 -y 105 -width 98 -height 30 -anchor nw -bordermode ignore 
    place $base.ent62 \
        -x 20 -y 75 -width 98 -height 30 -anchor nw -bordermode ignore 
    place $base.lab63 \
        -x 10 -y 5 -width 161 -height 30 -anchor nw -bordermode ignore 
    place $base.but64 \
        -x 10 -y 245 -width 56 -height 30 -anchor nw -bordermode ignore 
    place $base.lab65 \
        -x 10 -y 210 -width 146 -height 30 -anchor nw -bordermode ignore 
    place $base.lab66 \
        -x 80 -y 245 -width 81 -height 30 -anchor nw -bordermode ignore 
    place $base.but52 \
        -x 125 -y 45 -width 37 -height 26 -anchor nw -bordermode ignore 
    place $base.but53 \
        -x 125 -y 170 -width 37 -height 26 -anchor nw -bordermode ignore 
    place $base.but54 \
        -x 125 -y 138 -width 37 -height 26 -anchor nw -bordermode ignore 
    place $base.but55 \
        -x 125 -y 107 -width 37 -height 26 -anchor nw -bordermode ignore 
    place $base.but56 \
        -x 125 -y 75 -width 37 -height 26 -anchor nw -bordermode ignore 
}

proc vTclWindow.top79 {base} {
global linn; 
global sc1; 
global fnt1; 
global fnt2; 
global fnt3; 
global res3;
    if {$base == ""} {
        set base .top79
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    toplevel $base -class Toplevel \
        -background #df1612 
    wm focusmodel $base passive
    wm geometry $base 135x268+437+106
    wm maxsize $base 1137 834
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Prefixes"
    frame $base.fra80 \
        -background #3a24df -borderwidth 2 -height 75 -relief groove \
        -width 125 
    button $base.fra80.but81 \
        -font $fnt1 -padx 9 -pady 3 \
        -text button 
    button $base.fra80.but82 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Deci 
    bind $base.fra80.but82 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Deci "
    }
    button $base.fra80.but83 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Deca 
    bind $base.fra80.but83 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Deca "
    }
    button $base.fra80.but84 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hecto 
    bind $base.fra80.but84 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Hecto "
    }
    button $base.fra80.but85 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Kilo 
    bind $base.fra80.but85 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Kilo "
    }
    button $base.fra80.but86 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Mega 
    bind $base.fra80.but86 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Mega "
    }
    button $base.fra80.but87 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Giga 
    bind $base.fra80.but87 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Giga "
    }
    button $base.fra80.but88 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Tera 
    bind $base.fra80.but88 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Tera "
    }
    button $base.fra80.but89 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Peta 
    bind $base.fra80.but89 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Peta "
    }
    button $base.fra80.but90 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Exa 
    bind $base.fra80.but90 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Exa "
    }
    button $base.fra80.but91 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Atto 
    bind $base.fra80.but91 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Atto "
    }
    button $base.fra80.but92 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Femto 
    bind $base.fra80.but92 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Femto "
    }
    button $base.fra80.but93 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Pico 
    bind $base.fra80.but93 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Pico "
    }
    button $base.fra80.but94 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Nano 
    bind $base.fra80.but94 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Nano "
    }
    button $base.fra80.but95 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Micro 
    bind $base.fra80.but95 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Micro "
    }
    button $base.fra80.but96 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Milli 
    bind $base.fra80.but96 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Milli "
    }
    button $base.fra80.but97 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Centi 
    bind $base.fra80.but97 <ButtonRelease-1> {
        .top17.ent18 insert [string length [.top17.ent18 get]] " Centi "
    }
    button $base.but99 \
        -font $fnt1 -padx 9 -pady 3 \
        -text Hide 
    bind $base.but99 <ButtonRelease-1> {
        wm withdraw .top79
    }
    place $base.fra80 \
        -x 5 -y 5 -width 120 -height 215 -anchor nw -bordermode ignore 
    place $base.fra80.but81 \
        -x 5 -y 5 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but82 \
        -x 5 -y 5 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but83 \
        -x 60 -y 5 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but84 \
        -x 60 -y 30 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but85 \
        -x 60 -y 55 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but86 \
        -x 60 -y 80 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but87 \
        -x 60 -y 105 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but88 \
        -x 60 -y 130 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but89 \
        -x 60 -y 155 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but90 \
        -x 60 -y 180 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but91 \
        -x 5 -y 180 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but92 \
        -x 5 -y 155 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but93 \
        -x 5 -y 130 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but94 \
        -x 5 -y 105 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but95 \
        -x 5 -y 80 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but96 \
        -x 5 -y 55 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.fra80.but97 \
        -x 5 -y 30 -width 50 -height 26 -anchor nw -bordermode ignore 
    place $base.but99 \
        -x 30 -y 230 -anchor nw -bordermode ignore 
}

Window show .
Window show .top106
Window show .top17
Window show .top18
Window show .top19
Window show .top20
Window show .top56
Window show .top79

main $argc $argv
