/* command.c */

#define RCFILE "acalcrc"

#include <unistd.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "calc.h"

/* Command-line options and the rc file */

void get_options(int argc, char **argv);
void exec_option(int oc, char *optarg);

void get_options(int argc, char **argv)
{
	FILE *f;
	char buf[256];
	char rcfile[256];
	char *sp;
	int i;


	static struct option o[] = {
		{ "radians", no_argument, NULL, 'r' },
		{ "degrees", no_argument, NULL, 'd' },
		{ "numbers", no_argument, NULL, 'n' },
		{ "fix", required_argument, NULL, 'f' },
		{ "toolbar", required_argument, NULL, 't' },
		{ "shortcut", required_argument, NULL, 's' },
		{ 0, 0, 0, 0 } };
	int oc;
	
#ifdef SYS_LINUX
	strcpy(rcfile, getenv("HOME"));
	strcat(rcfile, "/.");
	strcat(rcfile, RCFILE);
#endif
#ifdef SYS_DOS
	strcpy(rcfile, RCFILE);
#endif

	while((oc = getopt_long(argc, argv, "rdnf:t:s:", o, NULL)) != -1)
		exec_option(oc, optarg);
	
	if((f = fopen(rcfile, "r"))) {
		while(fgets(buf, 255, f)) {
			if(buf[strlen(buf) - 1] == '\n')
				buf[strlen(buf) - 1] = '\0';

			for(sp = buf; *sp && *sp != '='; sp++);

			if(!(*sp) || !(*(sp + 1))) {
				*sp = '\0';
				sp = NULL;
			} else {
				*sp = '\0';
				sp++;
			}
			
			for(i = 0; o[i].name; i++) {
				if(!strcmp(o[i].name, buf)) {
					exec_option(o[i].val, sp);
					break;
				}
			}

			if(!o[i].name)
				fprintf(stderr, "Option not recognized: %s\n", buf);
		}
	}
		
}
		
		
void exec_option(int oc, char *optarg)
{
	int arg;
	
		switch(oc) {
			case 'r':
				opt.deg = FALSE;
				break;
			case 'd':
				opt.deg = TRUE;
				break;
			case 'n':
				opt.num = TRUE;
				break;
			case 'f':
				arg = atoi(optarg);
				if(arg < 0 || arg > 12) 
					fprintf(stderr, "Invalid fix value -- must be between 0 and 12.\n");
				else
					opt.fix = arg;
				break;
			case 't':
				/* Free any earlier defined toolbar */
				free_toolbar();

				new_toolbar(optarg);
				break;
			case 's':
			{
				char *sp;
				for(sp = optarg; *sp && *sp != ':'; sp++);
				if(!(*sp) || !(*(sp + 1))) {
					fprintf(stderr, "Invalid argument to -s.\n");
					break;
				}
				*sp = '\0';
				sp++;
				add_shortcut(atoi(optarg), sp);
			}
				break;
		}
	
}
