/* data.c */

#include <stdlib.h>

#include "error.h"
#include "data.h"
#include "llist.h"

llist stacks;
llist regs;

void datalist_init( void )
{
	stacks = llist_new(sizeof(stack_node));
	regs = llist_new(sizeof(reg_node));

	return;
}

void datalist_free( void )
{ 
	free_stacklist();
	free_reglist();
}

stack *get_stack( ac_int_t id )
{
	llist_node *n;
	stack_node *stkn;

	/* Search the list for a stack with the given id */
	for(n = stacks.h; n && id != ((stack_node *)(n->data))->id; n = n->next);

	if(!n) {
		/* Allocate new */
		aotf_assertk(stkn = malloc(sizeof(stack_node)),
						"Allocation of new stack node failed");
		stkn->stk = stack_new(sizeof(token));
		stkn->id = id;
		llist_prepend_p(&stacks, stkn);
		return &(stkn->stk);
	} else {
		return &(((stack_node *)(n->data))->stk);
	}
}

void free_stacklist( void )
{
	llist_node *n, *m;
	stack_node *stkn;

	for(n = stacks.h; n; n = n->next) {
		stkn = n->data;
		for(m = stkn->stk.h; m; m = m->next) {
			free_tok(m->data);
		}
		
		stack_free(&(stkn->stk));
	}

	llist_free(&stacks);
	stacks.h = 0;

	return;
}

token *get_reg( ac_int_t id )
{
	llist_node *n;

	/* Search the list for a stack with the given id */
	for(n = regs.h; n && id != ((reg_node *)(n->data))->id; n = n->next);
	
	if(!n) {
		return NULL;
	} else {
		return &(((reg_node *)(n->data))->tok);
	}
}

void set_reg( ac_int_t id, token tok )
{
	llist_node *n;
	reg_node *regn;

	for(n = regs.h; n && id != ((reg_node *)(n->data))->id; n = n->next);

	if(!n) {
		/* New register node */
		aotf_assertk(regn = malloc(sizeof(reg_node)),
						"Allocation of new register node failed");
		regn->tok = tok;
		regn->id = id;
		llist_prepend_p(&regs, regn);
	} else {	
		/* Overwrite this node */
		regn = n->data;
		free_tok(&(regn->tok));
		regn->tok = tok;
	}

	return;
}

void del_reg( ac_int_t id )
{
	llist_node *n;
	reg_node *regn;

	for(n = regs.h; n && id != ((reg_node *)(n->data))->id; n = n->next);
	
	if(!n) {
		return;
	} else {	
		regn = n->data;
		free_tok(&(regn->tok));
		llist_remove(&regs, n);
	}
}

void free_reglist( void )
{
	llist_node *n;
	reg_node *regn;

	for(n = regs.h; n; n = n->next) {
		regn = n->data;
		free_tok(&(regn->tok));
	}

	llist_free(&regs);
	regs.h = 0;

	return;
}

void free_tok( token *tok )
{
	if(tok->typ == TTYP_STR) {
		free(tok->dat.str);
	}

	return;
}
