/* error.c */

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/times.h>
#include <errno.h>

#include "error.h"

void aotf_assert_fn( int err_level, int p, const char *file, int line, 
				char *cond, char *fmt, ... )
{
	va_list args;

	//if(p || err_level > ERR_LOG) return;
	if(p) return;
	
	va_start(args, fmt);
	
//	if(err_level <= ERR_FATAL) {  /* Seperate out FATAL and PANIC later */
		/* Log in log file, print to screen, and abort */
		fprintf(stderr, "Fatal error: Error level %d, file %s:%d\n", 
						err_level, file, line);
		fprintf(stderr, "Failed conditional: %s\n", cond);
		vfprintf(stderr, fmt, args);
		fprintf(stderr, "\nError code %d: %s\n", errno, strerror(errno));
		#if 0
		fprintf(aotf_err_file, "Fatal error: Error level %d, file %s:%d\n",
						err_level, file, line);
		fprintf(aotf_err_file, "Failed conditional: %s\n", cond);
		vfprintf(aotf_err_file, fmt, args);
		fprintf(aotf_err_file, "\nError code %d: %s\n", errno, strerror(errno));
		if(!gopt.continue_on_error) abort();
	} else if(err_level <= ERR_CHECK) {
		/* Print to log file and screen */
		fprintf(stderr, "Nonfatal error: Error level %d, file %s:%d\n",
						err_level, file, line);
		fprintf(stderr, "Failed conditional: %s\n", cond);
		vfprintf(stderr, fmt, args);
		fprintf(stderr, "\nError code %d: %s\n", errno, strerror(errno));
		fprintf(aotf_err_file, "Nonfatal error: Error level %d, file %s:%d\n",
						err_level, file, line);
		fprintf(aotf_err_file, "Failed conditional: %s\n", cond);
		vfprintf(aotf_err_file, fmt, args);
		fprintf(aotf_err_file, "\nError code %d: %s\n", errno, strerror(errno));
	} else if(err_level <= ERR_LOG) {
		/* Print to logfile only */
		fprintf(aotf_err_file, "Logging error: Error level %d, file %s:%d\n",
						err_level, file, line);
		fprintf(aotf_err_file, "Failed conditional: %s\n", cond);
		vfprintf(aotf_err_file, fmt, args);
		fprintf(aotf_err_file, "\nError code %d: %s\n", errno, strerror(errno));
	}
	#endif

	va_end(args);

	return;
}
