/* function.h 
 *
 * math functions called by the calculator
 * also, a table of functions */

#ifndef _function_h
#define _function_h

#include "data.h"

struct functable {
	char *str; /* Function name (for comparing to input) */
	int (*fn)(void);
	short args; /* Number of arguments needed */
	tok_type argtype; /* Type of arguments to accept (TTYP_* flags) */
};

struct keymap {
	int key;	/* shortcut key */
	char *cmd;	/* command to execute */
	char flags;	/* various flags */
		#define IMMED 0x01	/* Command is executed immediately when pressed */
};

#if 0
#define FUNC_ADD 0
#define FUNC_SUB 1
#define FUNC_MULT 2
#define FUNC_DIV 3
#define FUNC_POW 4
#define FUNC_LOG 5
#define FUNC_LN 6
#define FUNC_SQR 7
#define FUNC_SQRT 8
#define FUNC_INV 9
#define FUNC_EXP 10
#define FUNC_SIN 11
#define FUNC_COS 12
#define FUNC_TAN 13
#define FUNC_DEG 14
#define FUNC_RAD 15
#define FUNC_TODEG 16
#define FUNC_TORAD 17
#define FUNC_IPART 18
#define FUNC_FPART 19
#define FUNC_TOHEX 20
#define FUNC_TODEC 21
#define FUNC_SWAP 22
#define FUNC_DROP 23
#define FUNC_ROT 24
#define FUNC_ROLL 25
#define FUNC_CLR 26
#define FUNC_DROPN 27
#define FUNC_DUP 28
#define FUNC_QUIT 29
#define FUNC_NONE 30
#endif
#define FUNC_QUIT 666

#endif
