/* get_str.c */

#include <curses.h>
#include <string.h>
#include "calc.h"

#ifdef SYS_DOS
#ifdef KEY_BACKSPACE
#undef KEY_BACKSPACE
#endif
#define KEY_BACKSPACE 8
#endif

void get_str(char *buf, int n, int boxlen);
/* Reads a string from the keyboard, starting at the current
	cursor position, to a maximum of n characters.  If the length
	goes outside of boxlen characters, the input will scroll
	to keep the displayed portion to that length. If the character is in the
	keys[] array and it's an IMMED shortcut, or no other characters have been
	input, a space is appended to the string, followed by the associated 
	function, and the function is terminated. */
/* If a double quote is pressed, reads in the characters in
 * the keys[] array as if they were normal. */

#define SCR_LIMIT 4

void get_str(char *buf, int n, int boxlen)
{
	int i, c, keyin = 0;
	int y, x, sy, sx;
	int first = 0;
	char quoteflag = FALSE;

	getyx(stdscr, sy, sx);
	move(sy, sx);
	y = sy; x = sx;
	c = 0;

	while(keyin != '\r' 
#ifdef SYS_DOS
	        && keyin != PADENTER
#endif
#ifdef SYS_LINUX
          && keyin != KEY_ENTER
#endif
	      ) {
		
		if(c - first < SCR_LIMIT && first > 0) {
			first -= SCR_LIMIT;
			if(first < 0) first = 0;
			move(sy, sx);
			for(i = first; i < first + boxlen; i++) 
				echochar((i < c) ? buf[i] : ' ');
			move(sy, c - first + 2);
		} else if ((first + boxlen) - c < SCR_LIMIT && first + boxlen != n) {
			first += SCR_LIMIT;
			if(first + boxlen > n) first = n - boxlen;
			move(sy, sx);
			for(i = first; i < first + boxlen; i++) 
				echochar((i < c) ? buf[i] : ' ');
			move(sy, c - first + 2);
		}
		
		refresh();
		keyin = getch();
		
		if(!quoteflag) {
			/* If last character is 'e' and the keypress was a '-', ignore */
			if(c && (buf[c - 1] == 'e' || buf[c - 1] == 'E') && keyin == '-') {

			} else {
			for(i = 0; keys[i].key; i++) 
				if(( !c ? TRUE : (keys[i].flags & IMMED)) && keyin == keys[i].key) {
					/* Need to null-terminate string first */
					buf[c] = '\0';
					strcat(buf, " ");
					strcat(buf, keys[i].cmd);
					c += strlen(keys[i].cmd) + 1;
					keyin = '\r';
					break;
				}
			}
		}
		if(quoteflag && (keyin == '\r'
#ifdef SYS_DOS
								|| keyin == PADENTER
#endif
								)) {
			ungetch('\r');
			ungetch('\"');
			keyin = '\0';
		}
		if(keyin == KEY_LEFT || keyin == KEY_BACKSPACE) {
			if(c) {
				c--;
				getyx(stdscr, y, x);
				move(y, x-1);
				echochar(' ');
				move(y, x-1);
				if(buf[c] == '\"')
					quoteflag = !quoteflag;
			}
			else beep();
		}
		else if(keyin >= 32 && keyin <= 127) {
			if(c < n) {
				buf[c] = keyin;
				c++;
				echochar(keyin);
			}	
			else beep();
		}

		if(keyin == '\"') quoteflag = !quoteflag;
	}
	buf[c] = '\0';
}	
