/* keys_c.c */

#include <curses.h>
#include "function.h"

struct keymap keys[] = {
	{ '+', "+", IMMED },
	{ '-', "-", IMMED },
	{ '*', "*", IMMED },
	{ '/', "/", IMMED },
	{ '^', "^", IMMED },
	{ '_', "neg", IMMED },
	{ '!', "inv", IMMED },
	{ KEY_DC, "drop", IMMED },
	{ KEY_BACKSPACE, "drop", 0 },
	{ KEY_IC, "swap", IMMED },
	{ KEY_PPAGE, "rot", IMMED },
	{ KEY_NPAGE, "roll", IMMED },
	{ '\r', "dup", 0 },
	{ '@', "sqr", IMMED },
	{ '#', "sqrt", IMMED },
	{ 'S', "sin", 0 },
	{ 'C', "cos", 0 },
	{ 'T', "tan", 0 },
	{ 'Q', "quit", 0 },
	{ 'R', "rad", 0 },
	{ 'D', "deg", 0 },
	{ 'E', "exp", 0 },
	{ '<', "sl", IMMED },
	{ '>', "sr", IMMED },
	{ '&', "and", IMMED },
	{ '|', "or", IMMED },
#ifdef SYS_DOS
	{ PADPLUS, "+", IMMED },
	{ PADMINUS, "-", IMMED },
	{ PADSTAR, "*", IMMED },
	{ PADSLASH, "/", IMMED },
	{ PADENTER, "dup", 0 },
#endif /* SYS_DOS */
	{ KEY_F(1), "1 sc", IMMED },
	{ KEY_F(2), "2 sc", IMMED },
	{ KEY_F(3), "3 sc", IMMED },
	{ KEY_F(4), "4 sc", IMMED },
	{ KEY_F(5), "5 sc", IMMED },
	{ KEY_F(6), "6 sc", IMMED },
	{ KEY_F(7), "7 sc", IMMED },
	{ KEY_F(8), "8 sc", IMMED },
	{ KEY_F(9), "9 sc", IMMED },
	{ KEY_F(10), "10 sc", IMMED },
	{ KEY_F(11), "11 sc", IMMED },
	{ KEY_F(12), "12 sc", IMMED },
	{ '?', "help", IMMED },
	{ '\0', (char *)0, 0 } };
