/* queue.h */

#ifndef _queue_h
#define _queue_h

#include "llist.h"

typedef llist queue;

queue queue_new( int db );
	/* Create a new queue (which is, of course, actually a llist) */

void *enqueue( queue *q, void *data );
	/* Enqueue the given data */

void *enqueue_p( queue *q, void *data );
	/* Enqueue, copying the pointer rather than the data.  See comment for
	 * llist_prepend_p */

void dequeue( queue *q, void *data );
	/* Dequeue a data node and store to data */

void *dequeue_p( queue *q );
	/* Dequeue a data node; return a pointer to dynamically allocated memory
	 * containing the data.  (Involves no copying, but you need to free the
	 * returned memory yourself. */

void queue_free( queue *q );
	/* Frees the queue (just calls llist_free) */

#endif
