/* shortcut.c */

#include <stdlib.h>
#include <error.h>
#include <string.h>
#include <stdio.h>
// #include <dmalloc.h>
#include "shortcut.h"

#define DEFAULT_LIST_LEN 10
#define LIST_LEN_STEP 5

#define TRUE -1
#define FALSE 0

struct shortcutlist {
	int *idlist;
	char **cmdlist;
	int listlen, maxlen;
} sclist;

void shortcut_init(void)
{
	sclist.listlen = 0;
	sclist.maxlen = DEFAULT_LIST_LEN;
	if(!(sclist.idlist = malloc(sclist.maxlen * sizeof(int)))) {
		perror("Couldn't allocate memory for shortcut list");
		exit(1);
	}
	if(!(sclist.cmdlist = malloc(sclist.maxlen * sizeof(char *)))) {
		perror("Couldn't allocate memory for shortcut list");
		exit(1);
	}
}

char add_shortcut(short id, char *cmd)
{
	int i;
	/* Search through to see if this is replacing an existing shortcut */
	for(i = 0; i < sclist.listlen; i++) {
		if(sclist.idlist[i] == id) { /* Bingo */
			free(sclist.cmdlist[i]);
			sclist.cmdlist[i] = malloc((strlen(cmd) + 1) * sizeof(char));
			strcpy(sclist.cmdlist[i], cmd);
			return TRUE;
		}
	}

	/* Check to see if we need to allocate more memory for the lists */
	if(sclist.listlen == sclist.maxlen) {
		if(!(sclist.idlist = realloc(sclist.idlist, 
						(sclist.maxlen + LIST_LEN_STEP) * sizeof(int)))) {
			perror("Couldn't allocate memory for shortcut list");
			exit(1);
		}
		if(!(sclist.cmdlist = realloc(sclist.cmdlist, 
						(sclist.maxlen + LIST_LEN_STEP) * sizeof(char *)))) {
			perror("Couldn't allocate memory for shortcut list");
			exit(1);
		}
		sclist.maxlen += LIST_LEN_STEP;
	}

	/* Add the given data to the end */
	sclist.idlist[sclist.listlen] = id;
	sclist.cmdlist[sclist.listlen]
					= malloc((strlen(cmd) + 1) * sizeof(char));
	strcpy(sclist.cmdlist[sclist.listlen], cmd);
	sclist.listlen++;

	return TRUE;
}	

char *get_shortcut(short id)
{
	int i;

	for(i = 0; i < sclist.listlen; i++) {
		if(sclist.idlist[i] == id) 
			return sclist.cmdlist[i];
	}

	return NULL;
}

void del_shortcut(short id)
{
	int i;
				
	for(i = 0; i < sclist.listlen; i++) {
		if(sclist.idlist[i] == id) {
			sclist.listlen--;
			sclist.idlist[i] = sclist.idlist[sclist.listlen];
			free(sclist.cmdlist[i]);
			sclist.cmdlist[i] = sclist.cmdlist[sclist.listlen];
			return;
		}
	}

	/* Not found */
}
