/* stack.c */

#include <stdlib.h>
#include <string.h>

#include "stack.h"

#ifndef NULL
#define NULL 0
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

stack stack_new( int db )
{
	stack s;
	
	s = llist_new(db);
	return s;
}

void stack_free( stack *s )
{
	llist_free(s);
}

void *push( stack *s, void *data )
{
	return llist_prepend(s, data);
}

void *push_p( stack *s, void *data )
{
	return llist_prepend_p(s, data);
}

void pop( stack *s, void *data )
{
	if(!(s->h)) {
		/* Nothing in stack; set data to all 0s */
		memset(data, 0, s->db);
		return;
	}
	
	memcpy(data, s->h->data, s->db);
	llist_remove(s, s->h);
}

void *pop_p( stack *s )
{
	void *data;

	if(!(s->h)) {
		/* Nothing in stack; return NULL */
		return NULL;
	}

	data = s->h->data;
	llist_shallow_remove(s, s->h);
	
	return data;
}
