/* stack.h */

#ifndef _stack_h
#define _stack_h

#include "llist.h"

typedef llist stack;

stack stack_new( int db );
	/* Create a new stack (which is, of course, actually a llist) */

void *push( stack *s, void *data );
	/* Pushes the given data onto the stack */

void *push_p( stack *s, void *data );
	/* Pushes the data onto the stack, only copying the pointer rather than
	 * the data.  (Uses llist_prepend_p; see comment there.) */

void pop( stack *s, void *data );
	/* Pop the stack and copy the contents of the node into data */

void *pop_p( stack *s );
	/* Pop the stack; return a pointer to dynamically allocated memory
	 * containing the data.  (Involves no copying, but you need to free the
	 * returned memory yourself.) */

void stack_free( stack *s );
	/* Frees the stack (just calls llist_free) */

#endif
