/* toolbar.c */

#include <stdlib.h>
// #include <dmalloc.h>

char *tbtext = NULL, **tbbuttons = NULL;
int tbnum;

void free_toolbar(void);
void new_toolbar(char *s);

void free_toolbar(void)
{
	if(tbtext) free(tbtext);
	if(tbbuttons) free(tbbuttons);
	tbtext = NULL; 
	tbbuttons = NULL;
	tbnum = 0;
}

void new_toolbar(char *s)
{
	int i;
	char *sp;
	
	if(strlen(s) == 0) return;

	tbtext = malloc(sizeof(char) * strlen(s) + 1);
	strcpy(tbtext, s);
	
	for(tbnum = 1, sp = tbtext; *sp; tbnum++, sp++) {
		while(*sp && *sp != ',')
			sp++;
		if(!(*sp)) break;
	}

	tbbuttons = malloc(sizeof(char *) * tbnum);

	for(i = 0, sp = tbtext; i < tbnum; i++, sp++) {
		tbbuttons[i] = sp;
		while(*sp && *sp != ',')
			sp++;

		*sp = '\0';
	}
}
