#include <math.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#ifdef C_DEBUG
#include "debug.h"
#endif
#include "calc_str.h"
#include "error.h"
#include "text.h"
#include "qc.h"

/* This function does a factorial. */

double factorial( long f )
{
	if( f>1 )
	{
		return f * factorial( (f-1) );
	}
	return f;
}

int getflo( char *p, signed int d, int *size )
{
	char temp[5];
	int i=0;
	int co;
	extern int GRESULT;
	
	if( GRESULT != SUCCESS )
		return ERCALC;
	if( d == -1 )
	{
		while( *p > 47 && *p < 58 )
			p--;
		p++;
	}
	while( *p > 47 && *p < 58 )
	{
		temp[i] = *p;
		i++;p++;
	}
	temp[i] = '\0';
	if( temp[0] < 48 || temp[0] > 57 )
	{
		Error( ERCALC );
		return ERCALC;
	}
	*size = 0;
	i = 0;
	co = atoi( temp );
	while( i < co )
	{
		i = (i+1) * 10;
		(*size)++;
		i--;
	}
	return co;
}

/* Goes through the cs and calculates the result */

double calc_str( char *cs )
{
	extern char unit;
	extern double constant[99];
	extern int GRESULT;
	double result = 0.0;
	int index = 0;
	int size;
	int co_index = 0;
	char *find;
	#ifdef C_DEBUG
	extern int DEBUG;
	#endif	

	#ifdef C_DEBUG
	if( DEBUG )
		fprintf( stderr, "cs: %s\n", cs );
	#endif
	while( (find = strrchr( cs, '(')) != NULL )
	{
		char *end_p, *start_p;
		int co_index;
		int length_p1;
		char p_string[CMD_LENGTH];
				
		if( *(find+1) == ')' )
		{
			Error( EREMPTYPAREN );
			return EREMPTYPAREN;
		}
		if( GRESULT != SUCCESS )
			return ERCALC;
		start_p = find;
		end_p = strchr( find, ')');
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "*end_p: %c, end_p--: %c, *find: %c\n", *end_p, *(end_p-1), *find );
		#endif
		if( find > end_p )
		{
			Error( ERPARENTHESIS );
			return ERPARENTHESIS;
		}
		while( *find < 48 || *find > 57 )
			find++;
		co_index = getflo( find, 1, &size );
		end_p--;
		length_p1 = end_p - (start_p+1);
		strncpy( p_string, (start_p+1), ++length_p1 );
		p_string[length_p1] = '\0';
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "p_string: %s\n", p_string );
		#endif
		constant[co_index] = calc_str( p_string );
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "new_const: %f\n", constant[co_index]);
		#endif
		find = start_p;
		strshort( start_p, 1);
		while( *find < 48 || *find > 57 )
		{
			strshort( find, 1);
			end_p--;
			if( find > end_p )
			{
				return ERCALC;
			}
		}
		find += size;
		end_p++;
		length_p1 = end_p - find;
		strshort( find, length_p1 );
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "cmd_str after ()'s: %s\n", cs );
		#endif
	}	
	index=0;
	while( (find = strchr( &cs[index], '-')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		index = find - cs;
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "neg_index: %d\n", cs[index] );
		#endif
		if( ((cs[--index]<48) || (cs[index]>57) || (index == -1)) && (cs[index] != '!') )
		{
			#ifdef C_DEBUG
			if( DEBUG )
				fputs( "Neg handling reached\n", stderr );
			#endif
			find++;
			co_index = getflo( find, 1, &size );
			constant[co_index] = 0 - constant[co_index];
			#ifdef C_DEBUG
			if( DEBUG )
				fprintf( stderr, "constant[co]: %f\n", constant[co_index] );
			#endif
			strshort( --find, 1 );
			index -= 2;
		}
		index += 2;
	}
	while( (find = strchr( cs, 'a')) != NULL )
	{
		char type;
		
		if( GRESULT != SUCCESS )
			return ERCALC;		type = *(++find);
		co_index = getflo( ++find, 1, &size );
		find-=2;
  		switch( type )
		{
			case 's':
			{
				constant[co_index] = asin( constant[co_index] );
				break;
			}
			case 'c':
			{
				constant[co_index] = acos( constant[co_index] );
				break;
			}
			case 't':
			{
				constant[co_index] = atan( constant[co_index] );
				break;
			}
		}
		if( unit == 'd' )
   			constant[co_index] = constant[co_index] * 180 / M_PI;
		strshort( find, 2 );
	}
	while( (find = strchr( cs, 'l')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--; 
		constant[co_index] = log10( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, 'A')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--;
		constant[co_index] = fabs( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, 'n')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--;
		constant[co_index] = log( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, 's')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--;
		if( unit == 'd' )
			constant[co_index] = constant[co_index] * M_PI / 180;
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "sin_co_index: %d\n", co_index );
		#endif		
		constant[co_index] = sin( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, 't')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--;
		if( unit == 'd' )
			constant[co_index] = constant[co_index] * M_PI / 180;
		constant[co_index] = tan( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, 'c')) != NULL )
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( ++find, 1, &size );
		find--;
		if( unit == 'd' )
			constant[co_index] = constant[co_index] * M_PI / 180;
		constant[co_index] = cos( constant[co_index] );
		strshort( find, 1 );
	}
	while( (find = strchr( cs, '!')) != NULL )
	{
		double part1;
	
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( --find, -1, &size );
		part1 = constant[co_index];
		if( part1 > 300 )
		{
			Error( EDOM );
			strshort(++find, 1);
			break;
		}
		
		constant[co_index] = factorial( (long)part1 );
		strshort( ++find, 1 );
	}
	while( (find = strchr( cs, '^')) != NULL )
	{
		double part1, part2;
		int new_place;
		
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( --find, -1, &size );
		new_place = co_index;
		part1 = constant[co_index];
		
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( find+=2, 1, &size );
		part2 = constant[co_index];
		
		constant[new_place] = (pow( part1, part2 ));
		strshort( --find, size+1 );
		if (errno == EDOM)
		{
			Error( EDOM );
			errno = 0;
		}
	}	
	while( (index = strcspn(cs, "*/") ) != (strlen(cs)) )
	{
		double part1, part2;
		int new_place=0;
		char m_or_d='\0';
		
		if( GRESULT != SUCCESS )
			return ERCALC;
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf(stderr, "cs[index] after strcspn(): %c\n", cs[index]);
		#endif 
		find = &cs[(index-1)];
		switch( cs[index] )
		{
			case '*':
			{
				m_or_d = 'm';
				break;
			}
			case '/':
			{
				m_or_d = 'd';
				break;
			}
		}
		co_index = getflo( find, -1, &size );
		new_place = co_index;
		part1 = constant[co_index];
		
		find+=2; 
		if( GRESULT != SUCCESS )
			return ERCALC;
		co_index = getflo( find, 1, &size );
		part2 = constant[co_index];
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "part1: %f, part2 %f\n", part1, part2 );
		#endif
		switch( m_or_d )
		{
			case 'm':
			{
				constant[new_place] = (part1 * part2);
				break;
			}
			case 'd':
			{
				constant[new_place] = (part1 / part2);
				break;
			}
		}
		strshort( --find, size+1 );
	}	
	#ifdef C_DEBUG
	if (DEBUG)
		fprintf(stderr, "cs after mult: %s\n", cs);
	#endif
	co_index = getflo( &cs[0], 1, &size );
	if( GRESULT != SUCCESS )
		return ERCALC;
	result = constant[co_index];
	index = 0;
	index += (--size); 
	while( cs[++index] != '\0')
	{
		if( GRESULT != SUCCESS )
			return ERCALC;
		switch( cs[index] )
		{
			case '+':
			{
				co_index = getflo( &cs[++index], 1, &size );
				index += --size;
				result = result + constant[co_index];
				break;
			}
			case '-':
			{
				co_index = getflo( &cs[++index], 1, &size );
				index += --size;
				result = result - constant[co_index];
				break;
			}
			default:
			{
				#ifdef C_DEBUG
				if( DEBUG )
					fprintf( stderr, "cs: '%s' cs[index]: '%c'\n", cs, cs[index] );
				#endif
				Error( ERCALC );
				return (double)0;
				break;
			}
		}
	}
	return result;
}
