#include <stdio.h>
#include <math.h>
#include <string.h>
#include "disp_ans.h"
#include "text.h"

/* This function displays the previously calculated result in proper form */
/* BUG:  This will sometimes print out to many zeros at the end, though I'm */
/* guessing it's because of .2 * .2 equaling .02000000000000000001 etc.    */

void disp_ans( double output )
{
	extern int precision;
	char format_str[8];
	char buffer[4];
	double divi=0.0;
	double orig=0.0;
	int sig_fig=0;
	#ifdef C_DEBUG
	extern int DEBUG;
	#endif
	
	orig = output;
	if( precision == 0 )
	{
		do
		{
			output = orig;
			sig_fig++;
			output *= ( pow( (double)10, (double)(sig_fig-1) ) );
			divi = ceil( output );
			#ifdef C_DEBUG
			if( DEBUG )
				fprintf( stderr, "sig_fig: %d output: %f divi: %f\n", sig_fig, output, divi );
			#endif
		}while(((divi < output-TOLERANCE) || (divi > output+TOLERANCE)) && (sig_fig < 12) );
		sig_fig--;
	}
	else
		sig_fig = precision;
	if( (orig > SCI_SIZE) || (orig < -SCI_SIZE) )
	{
		sig_fig+=2;
		strcpy( format_str, "%" );
		sprintf( buffer, "%d", sig_fig );
		strcat( format_str, buffer );
		strcat( format_str, "g" );
		printf( format_str, orig );
	}
	else
	{
		strcpy( format_str, "%." );
		sprintf( buffer, "%d", sig_fig );
		strcat( format_str, buffer );
		strcat( format_str, "f" );
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "format_str: %s\n", format_str );
		#endif
		printf( format_str, orig );
	}
	puts("");
}
