#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include "error.h"

void Error( int error_no )
{
	extern int GRESULT;

	if( GRESULT != SUCCESS )
		return;  /* Don't want more than on error message printed, for xqc */
	switch( error_no )
	{
		case ERLENGTH:
		{
			fprintf( stdout, "Input to long\n" );
			break;
		}
		case ERCALC: 
		{
			fprintf( stdout, "Error calculating\n" );
			GRESULT = ERCALC;
			break;
		}
		case ERSYNTAX: 
		{ 
			fprintf( stdout, "Syntax error\n" );
			GRESULT = ERSYNTAX; 
			break;
		}
		case ERPARENTHESIS:
		{
			fprintf( stdout, "Parentheses do not match\n" );
			GRESULT = ERPARENTHESIS;
			break;
		}
		case EREMPTYPAREN:
		{
			fprintf( stdout, "Empty Parentheses\n" );
			GRESULT = EREMPTYPAREN;
			break;
		}
		case ERFPE:
		{
			fprintf( stdout, "Overflow Error\n" );
			GRESULT = ERFPE;
			break;
		}
		case EDOM:
		{
			fprintf( stdout, "Domain Error\n" );
			GRESULT = EDOM;
			break;
		}
		default:
		{
			fprintf( stdout, "Unknown error %d\n", error_no );
			break;
		}
	}
}

/* This used to be called when we have a floating point overflow or whatnot.  */
/* It started not working one day and I haven't figured out why. */
/* The signal handling works but SIGFPE isn't generated when we do something */
/* like 1/0, but it used to.  What happened? */
void calc_error( int sig )
{
	extern int GRESULT;
	
	signal( SIGFPE, calc_error );
	if( GRESULT == SUCCESS )
		Error( ERFPE );
}
