%array

%{
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "error.h"
#include "qc.h"
%}

DIGIT		[0-9]
VAR		[a-z]
OP			"+"|"-"|"*"|"/"|"^"|"!"
OPN		"+"|"*"|"/"|"^"|"!"
OPF		"+"|"-"|"*"|"/"|"^"

%{
extern double constant[99], presult, user_var[26];
extern char command_str[CMD_LENGTH];
extern char *c_prev;
char buffer[15], next;
signed int p_count=0;
int co_index=0;
%}

%%

("-"{3,})							|
{OPF}[ \t]*$						|
^[ \t]*({OPN}|"--")				|
{OPF}[ \t]*")"						|
"("[ \t]*{OPN}						|
{OPF}[ \t]*{OPN}+					|
[0-9.e]+(([ \t])+)[0-9a-z]+	|
"!"([ \t])*[0-9a-z"("]+			{
											Error( ERSYNTAX );
											return 1;
										}

(E|\"|PI)(E|\"|PI)					{
											Error( ERSYNTAX );
											return 1;
										}

{DIGIT}+"."?{DIGIT}*("e"[-+]?)?{DIGIT}*	{
											sprintf( buffer, "%d", ++co_index );
											strcat( command_str, buffer );
											constant[co_index] = atof( yytext );
											next = input();
											if( (next > 96 && next < 123) || next == '(' )
												strcat( command_str, "*" );
											unput(next);
											}

{OP}				{
					strcat( command_str, yytext );
					}

sin|cos|tan|log		{
							buffer[0] = yytext[0];
							buffer[1] = '\0';
							strcat( command_str, buffer );
							}
a(sin|cos|tan)	{
					buffer[0] = 'a';
					buffer[1] = yytext[1];
					buffer[2] = '\0';
					strcat( command_str, buffer );
					}

ln	{
	strcat( command_str, "n" );
	}

abs	{
		strcat( command_str, "A" );
		}

E	{
	sprintf( buffer, "%d", ++co_index );
	strcat( command_str, buffer );
	constant[co_index] = M_E;
	}

PI	{
	sprintf( buffer, "%d", ++co_index );
	strcat( command_str, buffer );
	constant[co_index] = M_PI;
	}

"\""	{
		sprintf( buffer, "%d", ++co_index );
		strcat( command_str, buffer );
		constant[co_index] = presult;
		}

"("	{
		p_count++;
		strcat( command_str, "(" );
		}

")"	{
		p_count--;
		strcat( command_str, ")" );
		next = input();
		if( (next > 96 && next < 123) || next == '(' || (next > 47 && next < 58) )
			strcat( command_str, "*" );
		unput(next);
		}

{VAR}	{
		sprintf( buffer, "%d", ++co_index );
		strcat( command_str, buffer );
		constant[co_index] = user_var[(yytext[0]-97)];
		next = input();
		if( (next > 96 && next < 123) || next == '(' )
			strcat( command_str, "*" );
		if( next > 47 && next < 58 )
		{
			Error( ERSYNTAX );
			return 1;
		}
		unput(next);
		}

[ \t]


[;\n\0]	return 0;

. { Error( ERSYNTAX ); break; }

%%

extern char *user_input;
YY_BUFFER_STATE buf;

int parseinput( void )
{
	int result;
	
	p_count = 0;
	buf = yy_scan_string( user_input );
	result = yylex();
	yy_delete_buffer( buf );
	if( p_count != 0 )
		Error( ERPARENTHESIS );
	if( result != 100 )
		co_index = 0;
	return result;
}

int yywrap(void)
{
	return 1;
}