/*  
    Quick Calc: A calculator that takes long commands, ex: 5+5*6/32
    Copyright (C) 1996 Robert Palmbos

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    I can be reached at: 
    
    robertp@macatawa.org

*/

/* Includes */

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <readline/readline.h>
#include <readline/history.h>
#ifdef __linux__
#include <getopt.h> /* unistd.h defines getopt() under djgpp, other unixes? */
#endif
#include "text.h"
#include "disp_ans.h"
#include "error.h"
#include "qc.h"
#include "version.h"
#include "calc_str.h"

/* Global Variables */

#ifdef C_DEBUG
int DEBUG=0;
#endif
int GRESULT=SUCCESS;
double presult=0.0;
double user_var[26];
int noninter=0;
int precision=0;
char unit='r';
char *user_input=NULL, command_str[CMD_LENGTH]="";
char *ui;
double constant[999];
char *c_prev=NULL;


/* Program Start */

int main( int argc, char *argv[] )
{
	char *pos, temp[15];
	double result=0.0;
	extern int GRESULT;
	#ifdef C_DEBUG
	extern int DEBUG;
	#endif
	extern double presult;
	int c, sel_var,redo=0;
	int prompt=0, more=0;
	char *ptr;
		
	signal( SIGFPE, calc_error );
	c_prev = calloc( 10, 1 );
	if( c_prev == NULL )
	{
		puts( "Out of Memory" );
		exit(1);
	}
	rl_bind_key( '\t', rl_insert );  /*Tell readline not to complete filenames*/
	while( 1 )
	{
		c = getopt( argc, argv, "hdve:f:u:p" );
		if( c == EOF )
			break;
		switch( c )
		{
			case 'h':
			{
				usage();
				exit(1);
				break;
			}
			case 'd':
			{
				#ifndef C_DEBUG
				puts("Debugging suport not compiled into executable!");
				#endif
				#ifdef C_DEBUG
				DEBUG = 1;
				#endif
				break;
			}
			case 'v':
			{
				puts( VERSION ); /* Defined in "version.h" */
				printf( "Compiled on: " );
				puts( __DATE__ );
				exit(1);
				break;
			}
			case 'e':
			{
				user_input = strdup( optarg );
				user_input = realloc( user_input, (strlen(user_input)+10) );
				strcat( user_input, "\n" );
				noninter = 1;
				break;
			}
			case 'u':
			{
				unit = optarg[0];
				if( unit != 'd' )
					unit = 'r';
				break;
			}
			case 'f':
			{
				precision = atoi( optarg );
				if( precision > 16 )
					precision = 16;
				if( precision < 0 )
					precision = 0;
				break;
			}
			case 'p':
			{
				prompt = 1;
				break;
			}
			default:
			{
				usage();
				exit(1);
			}
		}
	}
	c = 0;
	while( c<26 )
	{
		user_var[c] = (double)0;
		c++;
	}
	while(1)
	{
		GRESULT = SUCCESS;
		/* Get user inputed commands, to use a better function later */
		if( !noninter && !more )
		{
			if( feof( stdin ) )
				exit(0);
			do{
				redo = 0;
				if( !prompt )
				{
					do 
					{
						if( user_input )
						{
							free( (char *)user_input );
							user_input = NULL;
						}
						ui = readline( "qc> " );
						if( ui == NULL )
							exit(0);
					}while( !strlen(ui) );
					add_history( ui );

					user_input = strdup( ui );
					user_input = realloc( user_input, strlen(user_input)+10 );
					strcat( user_input, "\n" );
					free( ui );
	
					/* user_input = realloc( user_input, strlen(user_input+2) ); */
					/* strcat( user_input, "\n" ); */
				}else
				{
					user_input = realloc( user_input, CMD_LENGTH );
					if( user_input == NULL ){
						puts( "Out of Memory" );exit(1);}
					fgets( user_input, CMD_LENGTH, stdin );
				}
				if( user_input[(strlen(user_input)-2)] == '\\' )
				{
					c_prev = realloc( c_prev, (strlen(c_prev)+strlen(user_input)+5) );
					if( c_prev == NULL ){
						puts( "Out of Memory" );exit(1);}
					strcat( c_prev, user_input );
					c_prev[(strlen(c_prev)-2)] = '\0';
					redo = 1;
				}
				if( !redo && c_prev[0] != '\0' )
				{
					user_input = realloc( user_input, (strlen(c_prev)+strlen(user_input)+5) );
					if( user_input == NULL ){
						puts( "Out of Memory" );exit(1);}
					c_prev = realloc( c_prev, (strlen(c_prev)+strlen(user_input)+5) );
					if( c_prev == NULL ){
						puts( "Out of Memory" );exit(1);}
					strcat( c_prev, user_input );
					strcpy( user_input, c_prev );
					c_prev[0] = '\0';
					redo = 0;
				}
			}while( redo );
		}
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "input: %s\n", user_input );
		#endif
		if( strlen(user_input) >(CMD_LENGTH-2) )
		{
			Error( ERLENGTH );
			user_input[0] = '\0';
		}
		strncpy( temp, user_input, 4 );
		temp[4] = '\0';
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "temp_set: %s\n", temp );
		#endif
		if( strstr( temp, "set " ) )
		{
			GRESULT = 1000;
			strshort( user_input, 4 );
			strncpy( temp, user_input, 10 );
			temp[10] = '\0';
			#ifdef C_DEBUG
			if( DEBUG )
				fprintf( stderr, "temp_set: %s\n", temp );
			#endif                  
			if( strstr( temp, "precision " ) )
			{
				strshort( user_input, 10 );
				precision = atoi( user_input );
				if( precision > 16 )
					precision = 16;
				if( precision < 0 )
					precision = 0;
				printf( "Precision set to %d\n", precision );
			}else{
				strncpy( temp, user_input, 5 );
				temp[5] = '\0';
				if( strstr( temp, "unit " ) )
				{
					strshort( user_input, 5 );
					unit = user_input[0];
					if( unit != 'd' )
						unit = 'r';
					printf( "Unit set to %c\n", unit );
				}else{
					GRESULT = SUCCESS;
					Error( ERSYNTAX );
				}
			}
		}
		#ifdef C_DEBUG
		if( DEBUG )
			fprintf( stderr, "input_b: %s\n", user_input );
		#endif
		/* Have they typed 'exit' to exit? */
		if( strstr( user_input, "exit" ) || strstr(user_input, "quit") )
			exit(0);
		
		/* Tell the user how to operate program */
		if( strstr( user_input, "help" ) )
		{
			help();
			GRESULT = 1000;
		}
		sel_var = -1;
		if( (pos = strchr( user_input, '=' )) != NULL )
		{
			int num_rem=2;
			
			while( *(--pos) == ' ' )
				num_rem++;
			sel_var = *pos - 97;
			strshort( pos, num_rem );

			if( sel_var < -1 || sel_var > 25 || pos != user_input )
			{
				if( GRESULT == SUCCESS )
					Error( ERSYNTAX );
			}
		}
		/* Call parseinput to place constants in array and setup string of
		commands. */
	
		if ( strlen(user_input) > 0 )
		{
			int p_suc;
			
			p_suc = parseinput();

			/* Call calc_str to produce result */
			if( strlen(command_str) > 0 )
				result = calc_str( command_str );
			else
				GRESULT = ERLENGTH;
			if( GRESULT == SUCCESS )
				disp_ans( result );
			presult = result;
			if( sel_var != -1 )
				user_var[sel_var] = result;

		}
		command_str[0] = '\0';
		if( (ptr = strchr( user_input, ';' )) != NULL )
		{
			strcpy( user_input, ++ptr );
			more=1;
		}else{
			user_input[0] = '\0';
			more=0;
		}
		fflush( stdout );
		if( noninter && !more )
			break;
	}
	exit(0);
}

/* Prints out the command line arguments supported */
void usage( void )
{
	fputs( "Usage: qc [-dhpv] [-e calculation] [-f precision] [-u unit] \n", stderr );
	fputs( "\t-h = print this message\n", stderr );
	fputs( "\t-d = print meaningless debugging messages\n", stderr );
	fputs( "\t-v = print out version and exit\n", stderr );
	fputs( "\t-e = perform 'calculation' and exit\n", stderr );
	fputs( "\t-f = display results with precision decimal places\n", stderr );
	fputs( "\t-u = do trig functions with unit, either r or d\n", stderr );
	fputs( "\t-p = disable the qc> prompt\n", stderr );
}

void help( void )
{
	char choice[25];
	int len;
	
	puts("***********This help is very brief!**************");
	puts("These topics are available:                      ");
	puts("      operators : +,-,/,* etc.                   ");
	puts("      trig      : trig functions                 ");
	puts("      other     : other functions                ");
	puts("      variables : how to use variables...        ");
	puts("      constants : built in constants             ");
	puts("      set       : setting operating parameters   ");
	puts("      edit      : command line editing           ");
	puts("Typing quit or exit will leave the program.      ");
	fputs( "help topic: ", stdout );
	fgets( choice, 25, stdin );
	len = strlen( choice );
	choice[--len] = '\0';
	if( strstr( choice, "operators" ) )
	{
		puts(" k1 + k2 : add two numbers!        ");
		puts(" k1 - k2 : subtract two numbers    ");
		puts(" k1 * k2 : multiply two numbers    ");
		puts(" k1 / k2 : divide two numbers      ");
		puts(" k1 ^ k2 : take k1 to the k2 power ");
		puts(" k1 !    : find the factorial      ");
		puts(" Parentheses may be inserted as needed.");
	}
	if( strstr( choice, "trig" ) )
	{
		puts(" sin( a1 )  : calculate sine of a1      ");
		puts(" cos( a1 )  : calculate cosine of a1    ");
		puts(" tan( a1 )  : calcuate tangent of a1    ");
		puts(" asin( a1 ) : arcsine of a1             ");
		puts(" acos( a1 ) : arccosine of a1           ");
		puts(" atan( a1 ) : arctangent of a1          ");
		puts("Parentheses are not needed but recommened.");
	}
	if( strstr( choice, "other" ) )
	{
		puts(" ln( k1 )  : natural log of k1       ");
		puts(" log( k1 ) : the log (base 10) of k1 ");
		puts(" abs( k1 ) : the absolute value of k1");
	}
	if( strstr( choice, "variables" ) )
	{
		puts(" Only single letter variable names a-z are allowed.     ");
		puts(" A value is assigned to a variable with a simple        ");
		puts(" statment: a=5*5/5  In this case a would then equal     ");
		puts(" 5.  The letter a can then be used any place you        ");
		puts(" would normally use a number.  Something such as 5x     ");
		puts(" is interpreted to mean 5*x where as x5 should generate ");
		puts(" an error.  This is not true for e, as it is used to    ");
		puts(" represent scientific notation, such as 6.022e23.       ");
		puts(" Instead, you must explicitly type e*5 or 2*e.          ");
	}
	if( strstr( choice, "constants" ) )
	{
		puts(" There are only currently two builtin constants, email ");
		puts(" me if you have other suggestions.                     ");
		puts(" PI : 3.131...                                         ");
		puts(" E  : 2.718...                                         ");
		puts(" \"  : This always equals the previous result.          ");
	}
	if( strstr( choice, "set" ) )
	{
		puts(" To set an operating parameter type set followed by the  ");
		puts(" parameter you wish to change and the new value.         ");
		puts(" ex: 'set precision 12' or 'set unit d'                  ");
		puts(" precision : set to 0 for floating or 1-16               ");
		puts(" unit      : can be set to 'r' (radians) or 'd' (degrees)");
	}
	if( strstr( choice, "edit" ) )
	{
		puts(" Command editing functions similar to a shell.  Press up ");
		puts(" arrow for the previous command and down arrow for the   ");
		puts(" next.  Multiple commands can be separated with a ';' and");
		puts(" lines can be continued with an '\\'.                    ");
	}
}
