#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>

#include "forms.h"
#include "xqc.h"
#include "fqcm.h"

states data;
states *mods=&data;

int main( int argc, char *argv[] )
{
	int qc_start;
	FD_xqc *fdqc;
	FL_IOPT cntl;
	char shared_colors[]="-shared";
	
	mods->hist = calloc( 10, 1 );
	mods->is2nd=0;
	mods->txt[0]='\0';
	mods->firstop=1;
	
	cntl.borderWidth = -2;
	fl_set_defaults( FL_PDBorderWidth, &cntl );

	argv[argc]=shared_colors;
	argc++;
	fl_initialize( &argc, argv, "Xqc", 0, 0);
	fdqc = create_form_xqc();
	fl_set_menu( mods->mw, "Precision%l|Radians%r1|Degrees%r1%l|Exit" );
		fl_set_object_color( mods->mw, FL_GRAY75, FL_GRAY75 );
		fl_setpup_color( FL_GRAY75, FL_BLACK );
		fl_setpup_fontstyle( FL_NORMAL_STYLE );
	fl_set_browser_fontsize( mods->tw, FL_NORMAL_SIZE );
	fl_set_browser_fontstyle( mods->tw, FL_FIXED_STYLE );
	fl_set_input_return( mods->fi, FL_RETURN_ALWAYS ); 
	fl_set_input( mods->fi, " " );

	fl_show_form( fdqc->xqc, FL_PLACE_FREE, FL_FULLBORDER, "Xqc" );

	mods->form = fdqc->xqc;

	qc_start = init_qc();
	if( qc_start == -1 )
	{
		puts( "Unable to load qc\n" );
		exit(1);
	}	
	
	fl_do_forms();
	exit(0);
}

int init_qc( void )
{
	int fd[2][2];
	pid_t pid;
	int check;
	
	check = pipe( fd[0] );
	if( check == -1 )
		return -1;
	check = pipe( fd[1] );
	if( check == -1 )
		return -1;
	pid = fork();
	if( pid == -1 )
		return -1;
	else if( pid == 0 )  /* Child */
	{
		close( fd[0][1] );
		close( fd[1][0] );
		dup2( fd[0][0], 0 );
		dup2( fd[1][1], 1 );
		check = execlp( "qc", "qc", "-p", NULL );
		if( check == -1 )
			_exit(1);
 	}
	else	/* Parent */
	{
		close( fd[1][1] );
		close( fd[0][0] );
		dup2( fd[0][1], 1 );
		dup2( fd[1][0], 0 );
	}
	return 0;
}


void addtext( char *text  )  /* Adds text to the text edit window */
{
	char *start, *end;
	int len;
	
	if( strlen(mods->txt)+strlen(text) > CMD_LENGTH-3 )
		return;
	strcat( mods->txt, text );
	mods->hist = realloc( mods->hist, (strlen(text)+strlen(mods->hist)+5) );
	if( mods->hist == NULL )
	{
		fputs( "Out of memory\n", stderr );
		exit(0);
	}
	start = strrchr( mods->hist, '\n' );
	if( start == NULL )
		start = mods->hist;
	else
		start++;
	end = strchr( start, '\0' );
	len = end - start;
	len += strlen( text );
	if( len > 30 )
		strcat( mods->hist, "\n" );
	strcat( mods->hist, text );
	fl_freeze_form( mods->form );
	fl_clear_browser( mods->tw );
	fl_addto_browser( mods->tw, mods->hist );
	fl_addto_browser( mods->tw, "\n" );
	fl_unfreeze_form( mods->form );
	mods->firstop=0;
}

void fi_get( FL_OBJECT *w, long n )
{
	const char *inp;
	static long inpc=1;
	char disp[2];
	static int prev_len=0;

	inp = fl_get_input( mods->fi );

	if( inp[inpc] == '\0' )
	{
		if( strlen(inp) < prev_len )
		{
			inpc--;
			if( inpc == 0 ){
				fl_set_input( mods->fi, " " );
				inpc=1;
			}
				b_back( w, n );
		}
		else
		{
			inpc=1;
			b_enter( w, n );
		}
	}
	else
	{
		disp[0] = inp[inpc];
		disp[1] = '\0';
		addtext( disp );
		inpc++;
	}
	prev_len = strlen(inp);
}

void m_file( FL_OBJECT *w, long n )
{
	int m_item;
	char null[80];

	m_item = fl_get_menu( w );
	switch( m_item )
	{
		case 1:
		{
			FL_OBJECT *d;
			FL_OBJECT *obj;
			FL_FORM *df;
			const char *ui;
			int prec;
			
			df = fl_bgn_form(FL_NO_BOX, 340, 110);
			obj = fl_add_box(FL_UP_BOX,0,0,340,110,"");
				fl_set_object_color( obj, FL_GRAY75, FL_GRAY75 );
			d = fl_add_input(FL_INT_INPUT,140,60,80,30,"Value");
				fl_set_object_color( d, FL_WHITE, FL_WHITE );
				fl_set_object_lsize(d,FL_NORMAL_SIZE);
			obj = fl_add_text(FL_NORMAL_TEXT,30,20,280,30,"Enter answer precision (1-16) or 0 for variable.");
				fl_set_object_color( obj, FL_GRAY75, FL_GRAY75 );
				fl_set_object_lsize(obj,FL_NORMAL_SIZE);
				fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
			fl_end_form();
			fl_set_input_maxchars( d, 2 );
			fl_deactivate_form( mods->form );
			fl_show_form( df, FL_PLACE_MOUSE, FL_TRANSIENT, "Enter Precision" );
			fl_do_forms();
			ui = fl_get_input( d );
			prec = atoi( ui );
			printf( "set precision %d\n", prec );
			fflush(stdout);
			gets( null );
			fl_hide_form( df );
			fl_activate_form( mods->form );
			break;
		}
		case 2:
		{
			puts( "set unit r" );
			fflush(stdout);
			gets( null );
			break;
		}
		case 3:
		{
			puts( "set unit d" );
			fflush(stdout);
			gets( null );
			break;
		}
		case 4:
		{
			b_off( w, n );
			break;
		}
	}
}

void b_back( FL_OBJECT *w, long n )
{
	if( strlen(mods->txt) > 0 )
	{
		if( mods->hist[(strlen(mods->hist)-1)] == '\n' )
		{
			mods->hist[(strlen(mods->hist)-1)] = '\0';
		}
		mods->hist[(strlen(mods->hist)-1)] = '\0';
		mods->txt[(strlen(mods->txt)-1)] = '\0';
		fl_freeze_form( mods->form );
		fl_clear_browser( mods->tw );
		fl_addto_browser( mods->tw, mods->hist );
		fl_addto_browser( mods->tw, "\n" );
		fl_unfreeze_form( mods->form );	
	}
}

void b_2nd( FL_OBJECT *w, long n )
{
	mods->is2nd = mods->is2nd^1;	/* Toggle 2nd */
}

void b_fact( FL_OBJECT *w, long n )
{
	if( mods->firstop )
	{
		b_prev( w, n );
	}
	addtext( "!" );
}

void b_log( FL_OBJECT *w, long n )
{
	addtext( "log(" );
}

void b_ln( FL_OBJECT *w, long n )
{
	addtext( "ln(" );
}

void b_eq( FL_OBJECT *w, long n )
{
	if( !mods->is2nd )
	{
		addtext( "x=\"" );
		b_enter( w, n );	/* What w is should make no difference anyway */
	}
	else
		addtext( "x" );
	mods->is2nd &= 0;
}

void b_off( FL_OBJECT *w, long n )
{
	free( mods->hist );	/* Free the display history */
	puts( "exit" );		/* Tell qc to die */
	exit(0);
}

void b_pi( FL_OBJECT *w, long n )
{
	addtext( "PI" );
}

void b_sin( FL_OBJECT *w, long n )
{
	if( mods->is2nd )
		addtext( "asin(" );
	else
		addtext( "sin(" );
	mods->is2nd = mods->is2nd&0;
}

void b_exp( FL_OBJECT *w, long n )
{
	addtext( "e" );
}

void b_seven( FL_OBJECT *w, long n )
{
	addtext( "7" );
}

void b_four( FL_OBJECT *w, long n )
{
	addtext( "4" );
}

void b_one( FL_OBJECT *w, long n )
{
	addtext( "1" );
}

void b_zero( FL_OBJECT *w, long n )
{
	addtext( "0" );
}

void b_e( FL_OBJECT *w, long n )
{
	addtext( "E" );
}

void b_cos( FL_OBJECT *w, long n )
{
	if( mods->is2nd )
		addtext( "acos(" );
	else
		addtext( "cos(" );
	mods->is2nd = mods->is2nd&0;
}

void b_lp( FL_OBJECT *w, long n )
{
	addtext( "(" );
}

void b_eight( FL_OBJECT *w, long n )
{
	addtext( "8" );
}

void b_five( FL_OBJECT *w, long n )
{
	addtext( "5" );
}

void b_two( FL_OBJECT *w, long n )
{
	addtext( "2" );
}

void b_point( FL_OBJECT *w, long n )
{
	addtext( "." );
}

void b_prev( FL_OBJECT *w, long n )
{
	addtext( "\"" );
}

void b_tan( FL_OBJECT *w, long n )
{
	if( mods->is2nd )
		addtext( "atan(" );
	else
		addtext( "tan(" );
	mods->is2nd = mods->is2nd&0;
}

void b_rp( FL_OBJECT *w, long n )
{
	addtext( ")" );
}

void b_nine( FL_OBJECT *w, long n )
{
	addtext( "9" );
}

void b_six( FL_OBJECT *w, long n )
{
	addtext( "6" );
}

void b_three( FL_OBJECT *w, long n )
{
	addtext( "3" );
}

void b_neg( FL_OBJECT *w, long n )
{
	addtext( "-" );
}

void b_clear( FL_OBJECT *w, long n )
{
	mods->hist[0] = '\0';
	mods->txt[0] = '\0';
	fl_clear_browser( mods->tw );
	fl_set_input( mods->fi, " " );
}

void b_pow( FL_OBJECT *w, long n )
{
	if( mods->firstop )
	{
		b_prev( w, n );
	}
	addtext( "^" );
}

void b_div( FL_OBJECT *w, long n )
{
	if( mods->firstop )
	{
		b_prev( w, n );	
	}
	addtext( "/" );
}

void b_mult( FL_OBJECT *w, long n )
{
	if( mods->firstop )
	{
		b_prev( w, n );
	}
	addtext( "*" );
}

void b_plus( FL_OBJECT *w, long n )
{
	if( mods->firstop )
	{
		b_prev( w, n );
	}	
	addtext( "+" );
}

void b_enter( FL_OBJECT *w, long n )
{
	char ans[1024];

	if( strspn( mods->txt, " " ) == strlen(mods->txt) )
	{
		mods->txt[0] = '\0';
	}
	if( !strcmp( mods->txt, "help" ) )
	{
		mods->txt[0] = '\0';
		strcat( mods->hist, "\n" );
	}
	if( !strcmp( mods->txt, "exit" ) || !strcmp( mods->txt, "quit" ) )
		b_off( w, n );
	if( strlen(mods->txt) > 0 )
	{
		if( strcspn( mods->txt, "\\;" ) == strlen(mods->txt) )
		{
			puts( mods->txt );
			fflush( stdout );
			fgets( ans, 1024, stdin );
		}else{
			strcpy( ans, "Syntax Error\n" );
		}
		strcat( mods->hist, "\n=" );
		mods->hist = realloc( mods->hist, (strlen(ans)+strlen(mods->hist)+5) );
		if( mods->hist == NULL )
		{
			fputs( "Out of memory\n", stderr );
			exit(0);
		}
		strcat( mods->hist, ans );
	}
	fl_freeze_form( mods->form );
	fl_clear_browser( mods->tw );
	fl_addto_browser( mods->tw, mods->hist );
	fl_addto_browser( mods->tw, "\n" );
	fl_unfreeze_form( mods->form );
	mods->txt[0] = '\0';
	mods->firstop=1;
	fl_set_input( mods->fi, " " );
}
