/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*button_def.c  by Paul Wilkins 3/30/97 */

#include <stdio.h>
#include <stdlib.h>

#include "buttons.h"
#include "editor.h"
#include "lcd.h"
#include "funcs.h"


FuncInfo invisible1[] = {
   { "Cplx", "cplx", "Create a complex number.", 
      genericButtonCB, (void *)CplxStack },
   { "Cplx", "complex", "Create a complex number.",
      genericButtonCB, (void *)CplxStack },
   { "Mtrx", "mtrx", "Create or decompose a matrix.",
      genericButtonCB, (void *)MtrxStack },
   { "Mtrx", "matrix", "Create or decompose a matrix.", 
      genericButtonCB, (void *)MtrxStack },
   { "Quit", "quit", "Quit XRPN.", genericButtonCB, (void *)exit },
   { "Clear", "clear", "Resets and clears XRPN to it's initial state.",
      genericButtonCB, (void *)clearLCD }
};
FuncInfo row2[] = {
   { "Enter", "dup", "Copy the number on the top of the stack.",
      genericButtonCB, (void *)PushStack },
   { "+/-", "neg", "Change sign.", plusMinusCB, NULL },
   { "EEX", NULL, "Mouse input: enter an exponent.",
      enterNumCB, (void *)'e' },
   { "DEL", NULL, "Mouse input: backspace.",
      genericButtonCB, (void *)deleteEditor },
   { "Drop", "drop", "Delete the number on the top of the stack.",
      genericButtonCB, (void *)PopStack },
   { "Swap", "swap", "Swap 2 numbers on the top of the stack.",
      genericButtonCB, (void *)SwapStack }
};
FuncInfo num789[] = {
   { "7", NULL, NULL, enterNumCB, (void *)'7' },
   { "8", NULL, NULL, enterNumCB, (void *)'8' },
   { "9", NULL, NULL, enterNumCB, (void *)'9' },
   { "/", NULL, NULL, genericButtonCB, (void *)DivStack },
   { "Pi", "pi", "The constant PI.", genericButtonCB, (void *)PiStack },
   { "Sin", "sin", "Trigonometric function Sin.",
      genericButtonCB, (void *)SinStack },
   { "Cos", "cos", "Trigonometric function Cos.",
      genericButtonCB, (void *)CosStack },
   { "Tan", "tan", "Trigonometric function Tan.",
      genericButtonCB, (void *)TanStack }
};
FuncInfo num456[] = {
   { "4", NULL, NULL, enterNumCB, (void *)'4' },
   { "5", NULL, NULL, enterNumCB, (void *)'5' },
   { "6", NULL, NULL, enterNumCB, (void *)'6' },
   { "x", NULL, NULL, genericButtonCB, (void *)MulStack },
   { "1/x", "inv", "Inverse.", genericButtonCB, (void *)InvStack },
   { "Asin", "asin", "Trigonometric function Arc-sin.",
      genericButtonCB, (void *)AsinStack },
   { "Acos", "acos", "Trigonometric function Arc-cos.",
      genericButtonCB, (void *)AcosStack },
   { "Atan", "atan", "Trigonometric function Arc-tan.",
      genericButtonCB, (void *)AtanStack }
};
FuncInfo num123[] = {
   { "1", NULL, NULL, enterNumCB, (void *)'1' },
   { "2", NULL, NULL, enterNumCB, (void *)'2' },
   { "3", NULL, NULL, enterNumCB, (void *)'3' },
   { "-", NULL, NULL, genericButtonCB, (void *)SubStack },
   { "Sqrt", "sqrt", "Square root.",
      genericButtonCB, (void *)SqrtStack },
   { "Nroot", "nroot", "N-th root.",
      genericButtonCB, (void *)NrootStack },
   { "Log", "log", "Log base 10.",
      genericButtonCB, (void *)LogStack },
   { "ln", "ln", "Natural log (log base e).",
      genericButtonCB, (void *)LnStack }
};
FuncInfo num0[] = {
   { "0", NULL, NULL, enterNumCB, (void *)'0' },
   { ".", NULL, NULL, enterNumCB, (void *)'.' },
   { NULL, NULL, NULL, NULL, NULL },
   { "+", NULL, NULL, genericButtonCB, (void *)AddStack },
   { "  2\nx  ", "sqr", "Square.", genericButtonCB, (void *)SqrStack },
   { "  x\ny  ", "pow", "Power.", genericButtonCB, (void *)PowStack },
   { "  x\n10 ", "tenx", "Ten to the power.",
      genericButtonCB, (void *)TenxStack },
   { "  x\ne  ", "exp", "e to the power.",
      genericButtonCB, (void *)ExpStack }
};


int NumButtonRows = 5;
int NumFunctionRows = 6;

struct RowInfo rowinf[] = {
   { 6, 6, row2 },
   { 8, 8, num789 },
   { 8, 8, num456 },
   { 8, 8, num123 },
   { 8, 8, num0 },
   { 6, 7, invisible1 }
};



