/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* callback_menu.h  by Paul Wilkins 3/15/97 */

#include <stdio.h>
#include <Xm/Xm.h>

#include "menu.h"
#include "lcd.h"
#include "mode.h"
#include "help.h"
#include "complex.h"
#include "number.h"


/* quit the program */
void quitCB(Widget w, XtPointer clientData, XtPointer callData){
   exit(0);
}

/* clear the stack */
void clearCB(Widget w, XtPointer clientData, XtPointer callData){

   clearLCD();

   /* refresh the display */
   redrawLCD();

}

void licenseCB(Widget w, XtPointer clientData, XtPointer callData){
   license_popup();
}

void helpCB(Widget w, XtPointer clientData, XtPointer callData){
   help_popup();
}


/* change the base we use to display the numbers */
void baseCB(Widget w, XtPointer clientData, XtPointer callData){
   
   setBaseMode((int)clientData);

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}

/* change the radix mode we use to display the numbers */
void radixCB(Widget w, XtPointer clientData, XtPointer callData){
   
   setRadixMode((int)clientData);

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}

/* change the coordinate mode we use to display the numbers */
void cmodeCB(Widget w, XtPointer clientData, XtPointer callData){
   
   switch((int)clientData){
      case RECTANGULAR:
         setPolarMode(RECTANGULAR);
         break;
      case POLAR:
         setPolarMode(POLAR);
         break;
      default:
         fprintf(stderr, "Error: radixCB: i shouldn't get here\n");
         exit(0);
   }

   /* refresh the display */
   redrawLCD();
   refreshModeDisplay();
}


/* change the display mode we use to display the numbers */
void dmodeCB(Widget w, XtPointer clientData, XtPointer callData){
   
   setShortLCD((int)clientData);

   /* refresh the display */
   redrawLCD();
}
