/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/DialogS.h>

#include "help.h"
#include "funcs.h"
#include "buttons.h"
#include "license.h"

#define HELP_TXT \
"\n\
XRPN  v1.0\n\
\n\
By: Paul Wilkins\n\
    paul.wilkins@analog.com\n\
\n\
XRPN is a graphical reverse polish notation (RPN) calculator.\n\
\n\
XRPN works with real numbers, complex numbers, matrices, and\n\
complex matrices.  Numbers can be displayed in 4 different\n\
radix modes, and complex numbers can be displayed in either\n\
Cartesian or polar form.\n\
\n\
XRPN uses a stack and reverse polish notation to evaluate\n\
expressions.  The stack in XRPN is infinite and limited only\n\
by available memory.\n\
\n\
Expressions are evaluated in reverse polish notation.  Unlike\n\
conventional (prefix) notation, RPN requires that all arguments\n\
to a command are entered prior to execution of the command.  For\n\
example to add 6.7 to 3.2 you would push both numbers onto the\n\
stack, then press the add (+) button:\n\
\n\
3.2<enter>\n\
6.7<enter>\n\
+\n\
\n\
The result is left on the stack.\n\
\n\
Note that XRPN uses a shorthand for all commands that causes\n\
an automatic <enter> before executing a command.  The previous\n\
example could then be done as:\n\
\n\
3.2<enter>\n\
6.7+\n\
\n\
Input is accepted from both the keyboard and the mouse.  When\n\
entering a command from the keyboard, the command may be\n\
abbreviated to the shortest set of letters which uniquely\n\
identifies the command.  Mouse input simply requires pressing\n\
the button with the desired command.\n\
\n\
Available commands:\n\
\n\
+           Add.\n\
-           Subtract.\n\
*           Multiply.\n\
/           Divide.\n\
<enter>     Push a number onto the top of the stack.\n\
<space>     Push a number onto the top of the stack.\n\
"

extern Widget toplevel;

void help_popup(){
 
   int i, j, k;
   int cmds;
   int len;
   Arg args[20];
   static Widget dialog = NULL;
   static Widget form;
   static Widget text_w;
   char dummy[] = "Can't get help.";
   char *htxt;
   char *cmd;
   Widget w;
   void ok_button_cb(Widget, XtPointer, XtPointer);
 
   if(dialog == NULL){
      dialog = XtVaCreatePopupShell("Help",
         xmDialogShellWidgetClass, toplevel,
         NULL);

      
      cmds = 0;
      for(i=0; i<NumFunctionRows; i++){
         cmds += rowinf[i].numBtns;
      }
      if(NULL == (htxt = (char*)malloc((3000+cmds*60)*sizeof(char)))){
         perror("help_popup: malloc");
         htxt = dummy;
      } else {
         strcpy(htxt, HELP_TXT);
         /* append the list of commands to the help text */
	 for(i=0; i<NumFunctionRows; i++){
	    for(j=0; j<rowinf[i].numBtns; j++){
               cmd = rowinf[i].fi[j].cmd;
	       if(cmd != NULL){
                  strcat(htxt, cmd);
                  len = 12 - strlen(cmd);
                  for(k=0; k<len; k++) strcat(htxt, " ");
                  strcat(htxt, rowinf[i].fi[j].help);
                  strcat(htxt, "\n");
	       }
	    }
	 }
      }
 
      form = XtVaCreateWidget("helpform", xmFormWidgetClass, dialog, NULL);

      i = 0;
      XtSetArg(args[i], XmNscrollVertical,        True); i++;
      XtSetArg(args[i], XmNscrollHorizontal,      False); i++;
      XtSetArg(args[i], XmNeditMode,              XmMULTI_LINE_EDIT); i++;
      XtSetArg(args[i], XmNeditable,              False); i++;
      XtSetArg(args[i], XmNcursorPositionVisible, False); i++;
      XtSetArg(args[i], XmNvalue,                 htxt); i++;
      XtSetArg(args[i], XmNrows,                  30); i++;
      XtSetArg(args[i], XmNcolumns,               66); i++;

      text_w = XmCreateScrolledText(form, "help_text", args, i);

      if(htxt != dummy) free(htxt);
 
      w = XtVaCreateManagedWidget("Dismiss",
         xmPushButtonWidgetClass, form,
         XmNhighlight, None,
         XmNhighlightThickness, 0,
         XmNbottomAttachment, XmATTACH_FORM, XmNbottomOffset, 4,
         XmNleftAttachment, XmATTACH_FORM, XmNleftOffset, 4,
         NULL);
      XtAddCallback(w, XmNactivateCallback, ok_button_cb, dialog);
 
      XtVaSetValues(XtParent(text_w),
         XmNleftAttachment,   XmATTACH_FORM, XmNleftOffset, 4,
         XmNrightAttachment,  XmATTACH_FORM, XmNrightOffset, 4,
         XmNtopAttachment,    XmATTACH_FORM, XmNtopOffset, 4,
         XmNbottomAttachment, XmATTACH_WIDGET, 
         XmNbottomWidget, w, XmNbottomOffset, 4,
         NULL);
 
   }
   XtManageChild(text_w);
   XtManageChild(form);
   XtManageChild(dialog);
   XtPopup(dialog, XtGrabNone);
}
 

void license_popup(){
 
   int i;
   Arg args[20];
   static Widget dialog = NULL;
   static Widget form;
   static Widget text_w;
   Widget w;
   void ok_button_cb(Widget, XtPointer, XtPointer);
 
   if(dialog == NULL){
      dialog = XtVaCreatePopupShell("License",
         xmDialogShellWidgetClass, toplevel,
         NULL);

      
      form = XtVaCreateWidget("helpform", xmFormWidgetClass, dialog, NULL);

      i = 0;
      XtSetArg(args[i], XmNscrollVertical,        True); i++;
      XtSetArg(args[i], XmNscrollHorizontal,      False); i++;
      XtSetArg(args[i], XmNeditMode,              XmMULTI_LINE_EDIT); i++;
      XtSetArg(args[i], XmNeditable,              False); i++;
      XtSetArg(args[i], XmNcursorPositionVisible, False); i++;
      XtSetArg(args[i], XmNvalue,                 LICENSE_TXT); i++;
      XtSetArg(args[i], XmNrows,                  20); i++;
      XtSetArg(args[i], XmNcolumns,               70); i++;

      text_w = XmCreateScrolledText(form, "license_text", args, i);

      w = XtVaCreateManagedWidget("Dismiss",
         xmPushButtonWidgetClass, form,
         XmNhighlight, None,
         XmNhighlightThickness, 0,
         XmNbottomAttachment, XmATTACH_FORM, XmNbottomOffset, 4,
         XmNleftAttachment, XmATTACH_FORM, XmNleftOffset, 4,
         NULL);
      XtAddCallback(w, XmNactivateCallback, ok_button_cb, dialog);
 
      XtVaSetValues(XtParent(text_w),
         XmNleftAttachment,   XmATTACH_FORM, XmNleftOffset, 4,
         XmNrightAttachment,  XmATTACH_FORM, XmNrightOffset, 4,
         XmNtopAttachment,    XmATTACH_FORM, XmNtopOffset, 4,
         XmNbottomAttachment, XmATTACH_WIDGET, 
         XmNbottomWidget, w, XmNbottomOffset, 4,
         NULL);
 
   }
   XtManageChild(text_w);
   XtManageChild(form);
   XtManageChild(dialog);
   XtPopup(dialog, XtGrabNone);
}
 
 
void ok_button_cb(Widget w, XtPointer client_data, XtPointer call_data){
   XtUnmanageChild((Widget)client_data);
}


