/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/* main.c by Paul Wilkins.
 * This file contains the main program.
 */

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <X11/StringDefs.h>

#include "icon_bitmap"
#include "stack.h"
#include "menu.h"
#include "mode.h"
#include "lcd.h"
#include "buttons.h"
#include "constant.h"

Widget toplevel;

/* Fallback resources  */
char *fallback_resources[] = {
   /* "*XmForm*traversalOn: False",  */
   "*Background:   LightGrey",
   "*topShadowColor:       grey96",
   "*bottomShadowColor:    grey40",
    NULL
};

Widget setupModeDisplay(Widget);

main(int argc, char *argv[])
{
   int i;
   XtAppContext app;
   Widget main_w, form_w, mdisp, lcd, btns;
   Pixmap icon_pixmap;


   /* get toplevel widget */
   toplevel = XtVaAppInitialize(&app, "xrpn", NULL, 0,
      &argc, argv, fallback_resources,
      XtNinput, TRUE,        /* Some WM will not work without this! */
      NULL);

   /* any args left is an error */
   if(argc != 1){
      for(i=1; i<argc; i++){
         fprintf(stderr, "Unknown Argument '%s' Ignoring.\n", argv[i]);
      }
   }

   /* set up any constants we may use */
   setup_constant();

   /* setup the stack */
   if(0 == setup_stack()){
      fprintf(stderr, "Error: Could not initalize data structures.\n");
      exit(0);
   }

   /* the main window contains the work area and the menubar */
   main_w = XtVaCreateWidget("main_w",
      xmMainWindowWidgetClass, toplevel,
      XtNminWidth, 200, XtNminHeight, 200,
      NULL);

   /* set up the menu bar */
   setup_menu(main_w);

   /* create the form everyone goes into */
   form_w = XtVaCreateManagedWidget ("form",
      xmFormWidgetClass, main_w,
      XmNresizable, True,
      NULL);

   /* create the varrious subsystems */
   mdisp = setupModeDisplay(form_w);
   lcd = setupLCD(form_w);
   btns = setupButtons(form_w);

   /* set all of the geometry attachments */
   XtVaSetValues(mdisp,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_FORM,
      NULL);
   XtVaSetValues(lcd,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, mdisp,
      XmNbottomAttachment, XmATTACH_WIDGET, XmNbottomWidget, btns,
      NULL);
   XtVaSetValues(btns,
      /*
      XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 0,
      XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 60,
      */
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      /* XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, lcd, */
      XmNbottomAttachment, XmATTACH_FORM, 
      NULL);


   /* Create pixmap of depth 1 (bitmap) for icon */
   icon_pixmap = XCreateBitmapFromData(XtDisplay(toplevel),
      RootWindowOfScreen(XtScreen(toplevel)),
      icon_bitmap_bits, icon_bitmap_width, icon_bitmap_height);

   XtVaSetValues(toplevel,
      XtNiconName, "xrpn",         /* the name next to the icon */
      XtNiconPixmap, icon_pixmap,  /* the icon's pixmap */
      NULL);


   XtManageChild(main_w);
   XtRealizeWidget(toplevel);
   XtAppMainLoop(app);

}
