/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* process_input.c  by Paul Wilkins 3/21/97 */

#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/keysym.h>
#include <X11/StringDefs.h>

#include "process_input.h"
#include "funcs.h"
#include "lcd.h"
#include "editor.h"
#include "error.h"

#define INPUT_BUF_SIZE 32


void processInput(XKeyEvent *evnt, char chr){

   char c;
   char buf[INPUT_BUF_SIZE+1];
   int count;
   KeySym keysym;

   if(evnt){
      count = XLookupString(evnt, buf, INPUT_BUF_SIZE, &keysym, NULL);
   } else {
      buf[0] = chr;
      buf[1] = '\0';
      switch(chr){
         case ' ':
         case '\n':
         case '\t':
	    keysym = XK_space;
	    break;
         case '+':
	    keysym = XK_plus;
	    break;
         case '-':
	    keysym = XK_minus;
	    break;
         case '/':
	    keysym = XK_slash;
	    break;
         case '*':
	    keysym = XK_asterisk;
	    break;
         default:
            keysym = XK_4;  /* just pick one */
            break;
      }
   }

   /* this will clear any error string */
   resetError();

   /* process the line */
   switch(keysym){

      case XK_space:     /* if there is something in the buffer, then */
      case XK_KP_Space:  /* push it onto the stack, else duplicate the */
      case XK_Return:    /* element on the bottom of the stack */
      case XK_Tab:
      case XK_KP_Tab:
      case XK_KP_Enter:
      case XK_Linefeed:
         PushStack();
         break;

      case XK_Begin:      /* used when editing the entry buffer */
      case XK_Home:
      case XK_Up:
         homeEditor();
         break;

      case XK_End:      /* used when editing the entry buffer */
      case XK_Down:
         endEditor();
         break;

      case XK_Right:      /* used when editing the entry buffer */
         rightEditor();
         break;

      case XK_Left:      /* used when editing the entry buffer */
         leftEditor();
         break;

      case XK_BackSpace:  /* delete the last entry in the stack */
      case XK_Delete:     /* OR backspace over the last char typed */
         if(isEditingEditor()){
            deleteEditor();
         } else {
            PopStack();
         }
         break;

      case XK_Escape:  /* clear the entry buffer */
         cancelEditor();
         break;

      case XK_plus: 
      case XK_KP_Add:
         c = getPrevEditor();
         if(c == 'e' || c == 'E'){
            insertEditor(*buf);
         } else {
	    AddStack();
         }
         break;

      case XK_minus: 
      case XK_KP_Subtract:
         c = getPrevEditor();
         if(c == 'e' || c == 'E'){
            insertEditor(*buf);
         } else {
	    SubStack();
         }
         break;

      case XK_asterisk: 
      case XK_KP_Multiply:
         MulStack();
         break;

      case XK_slash: 
      case XK_KP_Divide:
         DivStack();
         break;

      default:  /* catch everything that's left over */

         /* ascii characters */
         if((keysym >= XK_KP_Space && keysym <= XK_KP_9) ||
            (keysym >= XK_space && keysym <= XK_asciitilde)){

            insertEditor(*buf);
         }

         
         break;
   }

   /* repaint the screen */
   redrawLCD();

}
