/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* setup_buttons.c  by Paul Wilkins */

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>

#include "buttons.h"
#include "funcs.h"
#include "editor.h"



/* create the button widgets */
Widget createButton(
   Widget parent, 
   int leftPos, int rightPos,
   int topPos, int bottomPos,
   FuncInfo *fi)
{

   Widget btn;
   XmString label;
   void (*callBack)(Widget, XtPointer, XtPointer);

   callBack = fi->CB;

   label = XmStringCreateLtoR(fi->name, XmSTRING_DEFAULT_CHARSET);

   btn = XtVaCreateManagedWidget(fi->name,
      xmPushButtonWidgetClass, parent,
      XmNheight, BUTTON_SIZE,
      XmNwidth, BUTTON_SIZE,
      XmNrecomputeSize, False,
      XmNtraversalOn, False,
      XmNhighlight, None,
      XmNhighlightThickness, 0,
      XmNmarginWidth, 0,
      XmNmarginHeight, 0,
      XmNalignment, XmALIGNMENT_CENTER,
      XmNlabelString, label,
      XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, leftPos,
      XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, rightPos,
      XmNtopAttachment, XmATTACH_POSITION, XmNtopPosition, topPos,
      XmNbottomAttachment, XmATTACH_POSITION, XmNbottomPosition, bottomPos,
      NULL);
   XtAddCallback(btn, XmNactivateCallback, callBack, (XtPointer)fi);


   XmStringFree(label);

   return btn;
}


/* setup the buttons */
Widget setupButtons(Widget parent){

   int i, j;
   int lPos, rPos;
   int numRows;
   Widget form;

#ifdef USE_ROWCOL
   rc = XtVaCreateManagedWidget("Buttons",
      xmRowColumnWidgetClass, parent,
      XmNorientation, XmHORIZONTAL,
      /* XmNpacking, XmPACK_COLUMN, */ /* use XmNnumColumns columns (or rows) */
      XmNpacking, XmPACK_TIGHT, /* wrap, if nessisary */
      XmNisAligned, True,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNmarginHeight, 0,
      XmNmarginWidth, 0,
      XmNspacing, 0,
      NULL);
#else
   form = XtVaCreateManagedWidget("Buttons",
      xmFormWidgetClass, parent,
      XmNtraversalOn, False,
      NULL);

#endif
   
   /* fill the form */
   numRows = NumButtonRows;
   for(i=0; i<numRows; i++){
      for(j=0; j<rowinf[i].numBtns; j++){
         if(rowinf[i].fi[j].name != NULL){
            lPos = (int)(100.0 * (double)j/(double)rowinf[i].sizeBtns);
            rPos = (int)(100.0 * (double)(j+1)/(double)rowinf[i].sizeBtns);
            createButton(form, 
               lPos, rPos,
               (int)(100.0 * (double)i / (double)numRows),
               (int)(100.0 * (double)(i+1) / (double)numRows),
               &(rowinf[i].fi[j])   );
         }
      }
   }

   return form;

}
