/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>

#include "menu.h"
#include "mode.h"


extern void quitCB(Widget, XtPointer, XtPointer);
extern void clearCB(Widget, XtPointer, XtPointer);
extern void licenseCB(Widget, XtPointer, XtPointer);
extern void helpCB(Widget, XtPointer, XtPointer);
extern void baseCB(Widget, XtPointer, XtPointer);
extern void radixCB(Widget, XtPointer, XtPointer);
extern void cmodeCB(Widget, XtPointer, XtPointer);
extern void dmodeCB(Widget, XtPointer, XtPointer);

Widget setup_menu(Widget parent)
{
   Widget menuWidget;
   Widget w;
   Widget FilePullDown, OptionsPullDown, HelpPullDown;
   Widget BasePullDown, RadixPullDown, CModePullDown, DModePullDown;
   XmString str1;

   /* create the menubar */
   menuWidget = XmCreateMenuBar(parent, "menu", NULL, 0);
   FilePullDown = XmCreatePulldownMenu(menuWidget, "FilePullDown", NULL, 0);
   OptionsPullDown = XmCreatePulldownMenu(menuWidget, "OptionsPullDown", NULL, 0);
   HelpPullDown = XmCreatePulldownMenu(menuWidget, "HelpPullDown", NULL, 0);

   /* create the "File" pulldown menu */
   str1 = XmStringCreateSimple("File");
   XtVaCreateManagedWidget("fileMenu",
      xmCascadeButtonWidgetClass, menuWidget,
      XmNlabelString, str1,
      XmNmnemonic, 'F',
      XmNsubMenuId, FilePullDown,
      NULL);
   XmStringFree(str1);

   /* create the "Options" pulldown menu */
   str1 = XmStringCreateSimple("Options");
   XtVaCreateManagedWidget("optionsMenu",
      xmCascadeButtonWidgetClass, menuWidget,
      XmNlabelString, str1,
      XmNmnemonic, 'O',
      XmNsubMenuId, OptionsPullDown,
      NULL);
   XmStringFree(str1);

   /* create the "Help" pulldown menu */
   str1 = XmStringCreateSimple("Help");
   w = XtVaCreateManagedWidget("helpMenu",
      xmCascadeButtonWidgetClass, menuWidget,
      XmNlabelString, str1,
      XmNmnemonic, 'H',
      XmNsubMenuId, HelpPullDown,
      NULL);
   XmStringFree(str1);

   /* tell the menubar who is the heplp widget */
   XtVaSetValues(menuWidget, XmNmenuHelpWidget, w, NULL);

   /* add the menu items for the File menu */
   str1 = XmStringCreateSimple("Ctrl+l");
   w = XtVaCreateManagedWidget("Clear",
      xmPushButtonGadgetClass, FilePullDown,
      XmNaccelerator, "Ctrl<Key>l",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, clearCB, NULL);
   str1 = XmStringCreateSimple("Ctrl+c");
   w = XtVaCreateManagedWidget("Quit",
      xmPushButtonGadgetClass, FilePullDown,
      XmNaccelerator, "Ctrl<Key>c",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, quitCB, NULL);

   /* create the "Options/Base" pulldown menu */
   BasePullDown = XmCreatePulldownMenu(OptionsPullDown,
      "BasePullDown", NULL, 0);

   str1 = XmStringCreateSimple("Base");
   XtVaCreateManagedWidget("basePulldown",
      xmCascadeButtonWidgetClass, OptionsPullDown,
      XmNlabelString, str1,
      XmNmnemonic, 'B',
      XmNsubMenuId, BasePullDown,
      NULL);
   XmStringFree (str1);


   /* add the menu items for the Base pulldown menu */
   str1 = XmStringCreateSimple("Ctrl+b");
   w = XtVaCreateManagedWidget("Binary",
      xmPushButtonGadgetClass, BasePullDown, 
      XmNaccelerator, "Ctrl<Key>b",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, baseCB, (XtPointer)BINARY);

   str1 = XmStringCreateSimple("Ctrl+o");
   w = XtVaCreateManagedWidget("Octal",
      xmPushButtonGadgetClass, BasePullDown, 
      XmNaccelerator, "Ctrl<Key>o",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, baseCB, (XtPointer)OCTAL);

   str1 = XmStringCreateSimple("Ctrl+d");
   w = XtVaCreateManagedWidget("Decimal",
      xmPushButtonGadgetClass, BasePullDown, 
      XmNaccelerator, "Ctrl<Key>d",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, baseCB, (XtPointer)DECIMAL);

   str1 = XmStringCreateSimple("Ctrl+x");
   w = XtVaCreateManagedWidget("Hex",
      xmPushButtonGadgetClass, BasePullDown, 
      XmNaccelerator, "Ctrl<Key>x",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, baseCB, (XtPointer)HEXIDECIMAL);



   /* create the "Options/Radix" pulldown menu */
   RadixPullDown = XmCreatePulldownMenu(OptionsPullDown,
      "RadixPullDown", NULL, 0);

   str1 = XmStringCreateSimple("Radix");
   XtVaCreateManagedWidget("radixPulldown",
      xmCascadeButtonWidgetClass, OptionsPullDown,
      XmNlabelString, str1,
      XmNmnemonic, 'R',
      XmNsubMenuId, RadixPullDown,
      NULL);
   XmStringFree(str1);

   /* add the menu items for the Radix pulldown menu */
   str1 = XmStringCreateSimple("Ctrl+g");
   w = XtVaCreateManagedWidget("Degrees",
      xmPushButtonGadgetClass, RadixPullDown,
      XmNaccelerator, "Ctrl<Key>g",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, radixCB, (XtPointer)DEGREES);
   str1 = XmStringCreateSimple("Ctrl+a");
   w = XtVaCreateManagedWidget("Radians",
      xmPushButtonGadgetClass, RadixPullDown, 
      XmNaccelerator, "Ctrl<Key>a",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, radixCB, (XtPointer)RADIANS);





   /* create the "Options/Coordinate Mode" pulldown menu */
   CModePullDown = XmCreatePulldownMenu(OptionsPullDown,
      "CModePullDown", NULL, 0);

   str1 = XmStringCreateSimple("Coordinate Mode");
   XtVaCreateManagedWidget("cmodePulldown",
      xmCascadeButtonWidgetClass, OptionsPullDown,
      XmNlabelString, str1,
      XmNmnemonic, 'C',
      XmNsubMenuId, CModePullDown,
      NULL);
   XmStringFree(str1);

   /* add the menu items for the Display Mode pulldown menu */
   str1 = XmStringCreateSimple("Ctrl+r");
   w = XtVaCreateManagedWidget("Rectangular",
      xmPushButtonGadgetClass, CModePullDown,
      XmNaccelerator, "Ctrl<Key>r",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, cmodeCB, (XtPointer)RECTANGULAR);
   str1 = XmStringCreateSimple("Ctrl+p");
   w = XtVaCreateManagedWidget("Polar",
      xmPushButtonGadgetClass, CModePullDown,
      XmNaccelerator, "Ctrl<Key>p",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, cmodeCB, (XtPointer)POLAR);



   /* create the "Options/Display Mode" pulldown menu */
   DModePullDown = XmCreatePulldownMenu(OptionsPullDown,
      "DModePullDown", NULL, 0);

   str1 = XmStringCreateSimple("Display Mode");
   XtVaCreateManagedWidget("dmodePulldown",
      xmCascadeButtonWidgetClass, OptionsPullDown,
      XmNlabelString, str1,
      XmNmnemonic, 'D',
      XmNsubMenuId, DModePullDown,
      NULL);
   XmStringFree (str1);

   /* add the menu items for the Display Mode pulldown menu */
   w = XtVaCreateManagedWidget("Short",
      xmPushButtonGadgetClass, DModePullDown, NULL);
   XtAddCallback(w, XmNactivateCallback, dmodeCB, (XtPointer)SHORT_DISPLAY);
   w = XtVaCreateManagedWidget("Long",
      xmPushButtonGadgetClass, DModePullDown, NULL);
   XtAddCallback(w, XmNactivateCallback, dmodeCB, (XtPointer)LONG_DISPLAY);




   /* add the menu items for the Help menu */
   str1 = XmStringCreateSimple("Ctrl+h");
   w = XtVaCreateManagedWidget("License",
      xmPushButtonGadgetClass, HelpPullDown,
      NULL);
   XtAddCallback(w, XmNactivateCallback, licenseCB, NULL);
   w = XtVaCreateManagedWidget("Help",
      xmPushButtonGadgetClass, HelpPullDown,
      XmNaccelerator, "Ctrl<Key>h",
      XmNacceleratorText, str1,
      NULL);
   XmStringFree(str1);
   XtAddCallback(w, XmNactivateCallback, helpCB, NULL);

   XtManageChild(menuWidget);

   return menuWidget;
}

